/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.metamodel.Model;
import org.plasma.provisioning.xsd.SDOXSchemaConverter;
import org.plasma.provisioning.xsd.XSDSchemaConverter;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaConverter;

public class SchemaMetamodelAssembler {
    private static Log log = LogFactory.getLog(SchemaMetamodelAssembler.class);
    private SchemaConverter processor;

    private SchemaMetamodelAssembler() {
    }

    public SchemaMetamodelAssembler(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        QName sdoxNamespace = this.findOpenAttributeQNameByValue("commonj.sdo/xml", (OpenAttrs)schema);
        this.processor = sdoxNamespace != null ? new SDOXSchemaConverter(schema, destNamespaceURI, destNamespacePrefix) : new XSDSchemaConverter(schema, destNamespaceURI, destNamespacePrefix);
    }

    private QName findOpenAttributeQNameByValue(String value, OpenAttrs attrs) {
        for (QName key : attrs.getOtherAttributes().keySet()) {
            String s = (String)attrs.getOtherAttributes().get(key);
            if (s == null || !s.equals(value)) continue;
            return key;
        }
        return null;
    }

    public Model getModel() {
        return this.processor.buildModel();
    }
}

