/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;
import org.plasma.query.QueryException;
import org.plasma.query.model.Expression;
import org.plasma.query.model.FilterId;
import org.plasma.query.model.ImportDeclaration;
import org.plasma.query.model.Parameter;
import org.plasma.query.model.ParameterDeclaration;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Predicates;
import org.plasma.query.model.Property;
import org.plasma.query.model.TextContent;
import org.plasma.query.model.Variable;
import org.plasma.query.model.VariableDeclaration;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.query.xpath.QueryPredicateVisitor;
import org.plasma.query.xpath.QueryXPath;
import org.plasma.sdo.xpath.XPathDetector;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Where", propOrder={"expressions", "textContent", "importDeclaration", "parameters", "parameterDeclaration", "variableDeclaration", "filterId"})
@XmlRootElement(name="Where")
public class Where
implements org.plasma.query.Where,
Predicates {
    private static Log log = LogFactory.getFactory().getInstance(Where.class);
    @XmlElement(name="Expression", required=true)
    protected List<Expression> expressions;
    @XmlElement(name="TextContent")
    protected TextContent textContent;
    @XmlElement(name="ImportDeclaration")
    protected ImportDeclaration importDeclaration;
    @XmlElement(name="Parameter", required=true)
    protected List<Parameter> parameters;
    @XmlElement(name="ParameterDeclaration")
    protected ParameterDeclaration parameterDeclaration;
    @XmlElement(name="VariableDeclaration")
    protected VariableDeclaration variableDeclaration;
    @XmlElement(name="FilterId")
    protected FilterId filterId;

    public Where() {
    }

    public Where(Expression expr) {
        this();
        this.getExpressions().add(expr);
    }

    public Where(Expression[] exprs) {
        this();
        this.getExpressions().add(new Expression(exprs));
    }

    public Where(String content) {
        this();
        if (XPathDetector.isXPath(content)) {
            try {
                Path path = null;
                PathNode currPathNode = null;
                content = content.startsWith("[") ? "root" + content : "root/" + content;
                QueryXPath xpath = new QueryXPath(content);
                List<Step> steps = xpath.getSteps();
                for (int i = 0; i < steps.size(); ++i) {
                    Step step = steps.get(i);
                    if (!(step instanceof NameStep)) {
                        throw new QueryException("cannot determine traversal path - expected named path step not, " + step.getClass().getName());
                    }
                    NameStep nameStep = (NameStep)step;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("step: " + nameStep.getLocalName()));
                    }
                    if (i > 0) {
                        if (path == null) {
                            path = new Path();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("adding path node: " + nameStep.getLocalName()));
                        }
                        currPathNode = new PathNode(nameStep.getLocalName());
                        path.addPathNode(currPathNode);
                    }
                    Where currentWhere = null;
                    if (step.getPredicates() != null && step.getPredicates().size() > 0) {
                        QueryPredicateVisitor predicateVisitor = new QueryPredicateVisitor();
                        xpath.acceptBreadthFirst(step, predicateVisitor);
                        currentWhere = predicateVisitor.getResult();
                    }
                    if (i + 1 == steps.size()) {
                        if (currentWhere != null) {
                            if (path != null) {
                                currentWhere.accept(new PrependPathVisitor(path));
                            }
                            for (Expression expr : currentWhere.getExpressions()) {
                                this.getExpressions().add(expr);
                            }
                            currentWhere.getExpressions().clear();
                            continue;
                        }
                        throw new QueryException("expected predicate(s) for last path step '" + nameStep.getLocalName() + "'");
                    }
                    if (currentWhere == null) continue;
                    currPathNode.setWhere(currentWhere);
                }
            }
            catch (JaxenException e) {
                throw new QueryException(e);
            }
        } else {
            this.textContent = new TextContent();
            this.textContent.setValue(content);
        }
    }

    public Where(String content, Parameter[] params) {
        this(content);
        for (int i = 0; i < params.length; ++i) {
            this.getParameters().add(params[i]);
        }
    }

    public Where(FilterId filterId) {
        this();
        this.filterId = filterId;
    }

    public void addExpression(Expression e) {
        this.getExpressions().add(e);
    }

    @Override
    public List<Expression> getExpressions() {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        return this.expressions;
    }

    public int getExpressionCount() {
        return this.getExpressions().size();
    }

    public TextContent getTextContent() {
        return this.textContent;
    }

    public void setTextContent(TextContent value) {
        this.textContent = value;
    }

    public ImportDeclaration getImportDeclaration() {
        return this.importDeclaration;
    }

    public void setImportDeclaration(ImportDeclaration value) {
        this.importDeclaration = value;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public ParameterDeclaration getParameterDeclaration() {
        return this.parameterDeclaration;
    }

    public void setParameterDeclaration(ParameterDeclaration value) {
        this.parameterDeclaration = value;
    }

    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public void setVariableDeclaration(VariableDeclaration value) {
        this.variableDeclaration = value;
    }

    public FilterId getFilterId() {
        return this.filterId;
    }

    public void setFilterId(FilterId value) {
        this.filterId = value;
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (int i = 0; i < this.getExpressions().size(); ++i) {
                this.getExpressions().get(i).accept(visitor);
            }
        }
        visitor.end(this);
    }

    public Variable[] getVariables() {
        final ArrayList list = new ArrayList(12);
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            @Override
            public void start(Variable variable) {
                list.add(variable);
            }
        };
        this.accept(visitor);
        Variable[] results = new Variable[list.size()];
        list.toArray(results);
        return results;
    }

    private class PrependPathVisitor
    extends DefaultQueryVisitor {
        private Path path;

        private PrependPathVisitor() {
        }

        public PrependPathVisitor(Path path) {
            this.path = path;
        }

        @Override
        public void start(Property property) {
            if (this.path != null) {
                property.setPath(this.path);
            }
            super.start(property);
        }

        @Override
        public void start(WildcardProperty property) {
            if (this.path != null) {
                property.setPath(this.path);
            }
            super.start(property);
        }
    }
}

