/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.runtime.adapter.PropertyBindingAdapter;
import org.plasma.runtime.adapter.TypeBindingAdapter;
import org.plasma.sdo.Alias;
import org.plasma.sdo.Compression;
import org.plasma.sdo.Concurrent;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.Derivation;
import org.plasma.sdo.EnumerationConstraint;
import org.plasma.sdo.Increment;
import org.plasma.sdo.Key;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.Sort;
import org.plasma.sdo.Temporal;
import org.plasma.sdo.UniqueConstraint;
import org.plasma.sdo.ValueConstraint;
import org.plasma.sdo.ValueSetConstraint;
import org.plasma.sdo.XmlProperty;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.profile.XmlNodeType;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.Property;
import org.plasma.sdo.repository.Visibility;

public class CoreProperty
implements PlasmaProperty {
    private CoreType type;
    private Property property;
    private String name;
    private QName qname;
    private int qnameHashCode;
    private String physicalName;
    private String localName;
    private CoreType containingType;
    private Map<commonj.sdo.Property, Object> instanceProperties;

    private CoreProperty() {
    }

    private CoreProperty(String name, CoreType type, CoreType containingType) {
        this.type = type;
        if (this.type == null) {
            throw new IllegalArgumentException("expected type argument");
        }
        if (!this.type.isDataType()) {
            throw new IllegalArgumentException("expected datatype not, " + this.type.getName());
        }
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException("expected name argument");
        }
        if (containingType != null) {
            PropertyBindingAdapter binding = PlasmaRuntime.getInstance().findPropertyBinding(containingType.getURI(), containingType.getName(), name);
            if (binding != null) {
                if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                    this.name = binding.getLogicalName().trim();
                }
                if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                    this.physicalName = binding.getPhysicalName().trim();
                }
                if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                    this.localName = binding.getLocalName().trim();
                }
            }
            this.containingType = containingType;
            this.qname = new QName(this.containingType.getName(), this.name);
            this.qnameHashCode = this.qname.hashCode();
        } else {
            this.qname = new QName(this.name);
            this.qnameHashCode = this.qname.hashCode();
        }
    }

    public CoreProperty(CoreType type, Property property, CoreType containingType) {
        Long max;
        PropertyBindingAdapter binding;
        this.type = type;
        if (this.type == null) {
            throw new IllegalArgumentException("expected type argument");
        }
        this.property = property;
        this.name = this.property.getName();
        if (this.name == null || this.name.trim().length() == 0) {
            if (this.type.isDataType()) {
                throw new IllegalArgumentException("expected reference (non-datatype) property type not, " + this.type.getName());
            }
            this.name = this.getDerivedName(this.type);
        }
        if ((binding = PlasmaRuntime.getInstance().findPropertyBinding(containingType.getURI(), containingType.getName(), this.name)) != null) {
            if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                this.name = binding.getLogicalName().trim();
            }
            if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                this.physicalName = binding.getPhysicalName().trim();
            }
            if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                this.localName = binding.getLocalName().trim();
            }
        }
        this.containingType = containingType;
        this.qname = new QName(this.containingType.getName(), this.name);
        this.qnameHashCode = this.qname.hashCode();
        this.instanceProperties = new HashMap<commonj.sdo.Property, Object>();
        if (this.property.getComments() != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_OBJECT_DESCRIPTION, this.property.getComments());
        }
        Visibility visibility = Visibility.public_;
        if (this.property.getVisibility() != null) {
            visibility = this.property.getVisibility();
        }
        this.instanceProperties.put(INSTANCE_PROPERTY_OBJECT_VISIBILITY, (Object)visibility);
        String physicalName = this.property.findPhysicalName();
        if (physicalName != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_STRING_PHYSICAL_NAME, physicalName);
        }
        if (this.property.getIsUnique()) {
            this.instanceProperties.put(INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE, new Boolean(true));
        }
        if (this.property.isDataType() && (max = this.property.getMaxLength()) != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_INT_MAXLENGTH, max);
        }
    }

    public int hashCode() {
        return this.qnameHashCode;
    }

    public boolean equals(Object other) {
        if (other != null) {
            CoreProperty otherType = (CoreProperty)other;
            return this.qnameHashCode == otherType.hashCode();
        }
        return false;
    }

    private String getDerivedName(PlasmaType type) {
        return this.getDerivedName(type.getName());
    }

    private String getDerivedName(String typeName) {
        return String.valueOf(typeName.substring(0, 1).toLowerCase()) + typeName.substring(1);
    }

    public static PlasmaProperty createInstanceProperty(String name, DataType dataType) {
        CoreType type = (CoreType)PlasmaTypeHelper.INSTANCE.getType(PlasmaRuntime.getInstance().getSDODataTypesNamespace().getUri(), dataType.name());
        CoreProperty property = new CoreProperty(name, type, null);
        return property;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DataFlavor getDataFlavor() {
        if (!this.getType().isDataType()) {
            throw new UnsupportedOperationException("property " + this.getContainingType().getURI() + "#" + this.getContainingType().getName() + "." + this.getName() + " is not a data type property");
        }
        DataType dataType = DataType.valueOf((String)this.getType().getName());
        return DataFlavor.fromDataType((DataType)dataType);
    }

    @Override
    public List<Comment> getDescription() {
        return (List)this.get(INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
    }

    @Override
    public String getDescriptionText() {
        StringBuilder buf = new StringBuilder();
        List list = (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
        if (list != null) {
            for (Comment comment : list) {
                buf.append(comment.getBody());
            }
        }
        return buf.toString();
    }

    @Override
    public String getPhysicalName() {
        if (this.physicalName != null) {
            return this.physicalName;
        }
        Alias alias = this.property.findAlias();
        if (alias != null && alias.getPhysicalName() != null) {
            return alias.getPhysicalName();
        }
        return null;
    }

    @Override
    public byte[] getNameBytes() {
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES);
        if (result == null) {
            result = this.getName().getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public byte[] getPhysicalNameBytes() {
        String name;
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES);
        if (result == null && (name = this.getPhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        Alias alias = this.property.findAlias();
        if (alias != null && alias.getLocalName() != null) {
            return alias.getLocalName();
        }
        return this.name;
    }

    @Override
    public byte[] getLocalNameBytes() {
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES);
        if (result == null) {
            result = this.getLocalName().getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public Alias getAlias() {
        return this.property.findAlias();
    }

    @Override
    public Key getKey() {
        return this.property.findKey();
    }

    @Override
    public boolean isKey() {
        Key key = this.property.findKey();
        return key != null;
    }

    @Override
    public boolean isKey(KeyType keyType) {
        Key key = this.property.findKey();
        if (key == null) {
            return false;
        }
        return key.getType().ordinal() == keyType.ordinal();
    }

    @Override
    public PlasmaProperty getKeySupplier() {
        Property supplierProperty = this.property.findKeySupplier();
        if (supplierProperty != null) {
            return this.lookup(supplierProperty);
        }
        return null;
    }

    @Override
    public Concurrent getConcurrent() {
        return this.property.findConcurrent();
    }

    @Override
    public boolean isConcurrent() {
        Concurrent concurrent = this.property.findConcurrent();
        return concurrent != null;
    }

    @Override
    public boolean isConcurrent(ConcurrencyType type) {
        Concurrent concurrent = this.property.findConcurrent();
        if (concurrent == null) {
            return false;
        }
        return concurrent.getType().ordinal() == type.ordinal();
    }

    @Override
    public boolean isConcurrent(ConcurrencyType type, ConcurrentDataFlavor dataFlavor) {
        Concurrent concurrent = this.property.findConcurrent();
        if (concurrent == null) {
            return false;
        }
        return concurrent.getType().ordinal() == type.ordinal() && concurrent.getDataFlavor().ordinal() == dataFlavor.ordinal();
    }

    @Override
    public Temporal getTemporal() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findTemporal();
    }

    @Override
    public EnumerationConstraint getEnumerationConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findEnumerationConstraint();
    }

    @Override
    public ValueSetConstraint getValueSetConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findValueSetConstraint();
    }

    @Override
    public ValueConstraint getValueConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findValueConstraint();
    }

    @Override
    public Sort getSort() {
        return this.property.findSort();
    }

    @Override
    public UniqueConstraint getUniqueConstraint() {
        return this.property.findUniqueConstraint();
    }

    @Override
    public Compression getCompression() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findCompression();
    }

    @Override
    public Increment getIncrement() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findIncrement();
    }

    @Override
    public boolean isIncrement() {
        return this.getIncrement() != null;
    }

    @Override
    public XmlProperty getXmlProperty() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findXmlProperty();
    }

    @Override
    public Enumeration getRestriction() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.getRestriction();
    }

    @Override
    public long getMaxLength() {
        Long maxlen = (Long)this.get(INSTANCE_PROPERTY_INT_MAXLENGTH);
        if (maxlen != null) {
            return maxlen;
        }
        return -1L;
    }

    @Override
    public boolean isXMLAttribute() {
        if (!this.getType().isDataType()) {
            return false;
        }
        XmlProperty xmlPropery = this.getXmlProperty();
        if (xmlPropery != null) {
            return xmlPropery.getNodeType().ordinal() == XmlNodeType.attribute.ordinal();
        }
        DataType datatype = DataType.valueOf((String)this.getType().getName());
        switch (datatype) {
            case Boolean: 
            case Byte: 
            case Character: 
            case Date: 
            case DateTime: 
            case Day: 
            case Decimal: 
            case Double: 
            case Duration: 
            case Float: 
            case Int: 
            case UnsignedInt: 
            case Integer: 
            case Long: 
            case UnsignedLong: 
            case Month: 
            case MonthDay: 
            case Short: 
            case Time: 
            case URI: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                return true;
            }
            case Bytes: 
            case Object: {
                return false;
            }
            case String: 
            case Strings: {
                if (this.getEnumerationConstraint() != null) {
                    return true;
                }
                if (this.getValueConstraint() != null) {
                    return true;
                }
                if (this.getMaxLength() == -1L || this.getMaxLength() > 20L) {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public Object get(commonj.sdo.Property property) {
        Object result = null;
        if (this.instanceProperties != null && (result = this.instanceProperties.get(property)) == null) {
            result = this.instanceProperties.get(property.getName());
        }
        return result;
    }

    public List getInstanceProperties() {
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>();
        if (this.instanceProperties != null) {
            Iterator<commonj.sdo.Property> iter = this.instanceProperties.keySet().iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    public List<String> getAliasNames() {
        ArrayList<String> aliasList = new ArrayList<String>();
        Alias alias = this.property.findAlias();
        if (alias != null) {
            if (alias.getPhysicalName() != null) {
                aliasList.add(alias.getPhysicalName());
            }
            if (alias.getLocalName() != null) {
                aliasList.add(alias.getLocalName());
            }
            if (alias.getBusinessName() != null) {
                aliasList.add(alias.getBusinessName());
            }
        }
        return aliasList;
    }

    public Object getDefault() {
        return this.property.findPropertyDefault();
    }

    public commonj.sdo.Property getOpposite() {
        if (!this.getType().isDataType()) {
            Property oppositeProperty = this.property.getOpposite();
            if (oppositeProperty != null) {
                return this.lookup(oppositeProperty);
            }
            return null;
        }
        throw new PlasmaDataObjectException("cannot return opposite property for datatype property " + this.getType().getName() + "." + this.getName());
    }

    public Type getType() {
        return this.type;
    }

    public boolean isContainment() {
        return !this.property.isDataType();
    }

    public Type getContainingType() {
        return this.containingType;
    }

    public boolean isMany() {
        return this.property.isMany();
    }

    public boolean isNullable() {
        return this.property.isNullable();
    }

    public boolean isOpenContent() {
        return false;
    }

    public boolean isReadOnly() {
        return this.property.getIsReadonly();
    }

    public String toString() {
        if (this.containingType != null) {
            return String.valueOf(this.containingType.toString()) + "." + this.getName();
        }
        return this.getName();
    }

    @Override
    public Derivation getDerivation() {
        return this.property.findDerivation();
    }

    @Override
    public PlasmaProperty getDerivationSupplier() {
        Derivation derivation = this.property.findDerivation();
        if (derivation != null) {
            Property supplierProperty = this.property.findDerivationSupplier();
            if (supplierProperty != null) {
                return this.lookup(supplierProperty);
            }
            return null;
        }
        return null;
    }

    private PlasmaProperty lookup(Property repoProperty) {
        Class_ repoClass = repoProperty.getClass_();
        String repoClassNamespaceURI = repoClass.getNamespaceURI();
        String repoTypeName = repoClass.getName();
        TypeBindingAdapter binding = PlasmaRuntime.getInstance().findTypeBinding(repoClassNamespaceURI, repoClass.getName());
        if (binding != null && binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
            repoTypeName = binding.getLogicalName().trim();
        }
        Type repoType = PlasmaTypeHelper.INSTANCE.getType(repoClassNamespaceURI, repoTypeName);
        String repoPropertyName = repoProperty.getName();
        PropertyBindingAdapter propertyBinding = PlasmaRuntime.getInstance().findPropertyBinding(repoClassNamespaceURI, repoClass.getName(), repoProperty.getName());
        if (propertyBinding != null && propertyBinding.getLogicalName() != null && propertyBinding.getLogicalName().trim().length() > 0) {
            repoPropertyName = propertyBinding.getLogicalName().trim();
        }
        if (repoPropertyName != null && repoPropertyName.trim().length() > 0) {
            return (PlasmaProperty)repoType.getProperty(repoPropertyName);
        }
        repoPropertyName = this.getDerivedName(repoProperty.getType().getName());
        return (PlasmaProperty)repoType.getProperty(repoPropertyName);
    }

    @Override
    public String getId() {
        return this.property.getId();
    }
}

