/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.runtime.adapter.TypeBindingAdapter;
import org.plasma.sdo.Alias;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.DataType;
import org.plasma.sdo.Derivation;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreProperty;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.InvalidClassifierNameException;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Property;
import org.plasma.sdo.repository.RepositoryException;
import org.plasma.sdo.repository.Visibility;

public class CoreType
implements PlasmaType {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CoreType.class);
    private static final List<Type> EMPTY_TYPE_LIST = new ArrayList<Type>();
    private String name;
    private String physicalName;
    private String localName;
    private QName qname;
    private int qnameHashCode;
    private Classifier classifier;
    private volatile List<Type> baseTypes;
    private volatile List<Type> subTypes;
    private volatile Map<String, PlasmaProperty> declaredPropertiesMap;
    private Map<PlasmaProperty, Object> instancePropertiesMap;
    private List<commonj.sdo.Property> declaredPropertiesList;
    private String artifactURI;
    private String namespaceURI;

    private CoreType() {
    }

    public CoreType(String uri, String typeName) throws InvalidClassifierNameException {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("namespace URI is a required argument");
        }
        org.plasma.runtime.Namespace configNamespace = PlasmaRuntime.getInstance().getSDONamespaceByURI(uri);
        this.artifactURI = configNamespace.getArtifact();
        this.namespaceURI = configNamespace.getUri();
        this.name = typeName;
        this.qname = new QName(this.namespaceURI, this.name);
        this.qnameHashCode = this.qname.hashCode();
        String lookupName = this.name;
        TypeBindingAdapter binding = PlasmaRuntime.getInstance().findTypeBinding(uri, typeName);
        if (binding != null) {
            if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                this.name = binding.getLogicalName().trim();
                lookupName = binding.getType();
                PlasmaRuntime.getInstance().remapTypeBinding(uri, binding);
            }
            if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                this.physicalName = binding.getPhysicalName().trim();
            }
            if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                this.localName = binding.getLocalName().trim();
            }
        }
        Classifier repoClassifier = null;
        Namespace repoNamespace = PlasmaRepository.getInstance().getNamespaceForUri(this.namespaceURI);
        if (repoNamespace != null) {
            String packageQualifiedName = repoNamespace.getQualifiedPackageName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("found repo namespace/package " + packageQualifiedName + " (" + repoNamespace.getId() + ") linked to URI: " + this.namespaceURI));
            }
            packageQualifiedName = String.valueOf(packageQualifiedName) + "." + lookupName;
            try {
                repoClassifier = PlasmaRepository.getInstance().getClassifier(packageQualifiedName);
            }
            catch (RepositoryException e) {
                throw new InvalidClassifierNameException("namespace/package qualified classifier '" + packageQualifiedName + "' does not exist", (Throwable)((Object)e));
            }
        }
        String artifactQualifiedName = String.valueOf(this.artifactURI) + "#" + lookupName;
        try {
            repoClassifier = PlasmaRepository.getInstance().getClassifier(artifactQualifiedName);
        }
        catch (RepositoryException e) {
            throw new InvalidClassifierNameException("artifact qualified classifier '" + artifactQualifiedName + "' does not exist", (Throwable)((Object)e));
        }
        String urn = repoClassifier.getArtifactNamespaceURI();
        if (urn != null) {
            String qualifiedName = String.valueOf(urn) + "#" + repoClassifier.getName();
            Classifier resultClassifier = PlasmaRepository.getInstance().getClassifier(qualifiedName);
            if (!resultClassifier.getId().equals(repoClassifier.getId())) {
                log.warn((Object)("found xmi-id mismatch for result (" + resultClassifier.getId() + ") and lookup (" + repoClassifier.getId() + ") classifier - ignoring"));
            }
            this.classifier = resultClassifier;
        } else {
            this.classifier = repoClassifier;
        }
    }

    public int hashCode() {
        return this.qnameHashCode;
    }

    public boolean equals(Object other) {
        if (other != null) {
            CoreType otherType = (CoreType)other;
            return this.qnameHashCode == otherType.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.qname.toString();
    }

    private boolean propertiesLoaded() {
        return this.declaredPropertiesMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadProperties() {
        CoreType coreType = this;
        synchronized (coreType) {
            if (!this.propertiesLoaded()) {
                this._lazyLoadProperties();
            }
        }
    }

    private void _lazyLoadProperties() {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " start lazy load"));
        }
        HashMap<String, PlasmaProperty> tempDeclaredPropertiesMap = new HashMap<String, PlasmaProperty>();
        ArrayList<commonj.sdo.Property> tempDeclaredPropertiesList = new ArrayList<commonj.sdo.Property>();
        this.declaredPropertiesList = new ArrayList<commonj.sdo.Property>();
        this.instancePropertiesMap = new HashMap<PlasmaProperty, Object>();
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_PHYSICAL_NAME, this.classifier.getPhysicalName());
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_NAMESPACE_URI, this.classifier.getNamespaceURI());
        if (this.classifier.getComments() != null) {
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION, this.classifier.getComments());
        }
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_UUID, UUID.randomUUID().toString());
        Visibility visibility = Visibility.public_;
        if (this.classifier.getVisibility() != null) {
            visibility = this.classifier.getVisibility();
        }
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_VISIBILITY, (Object)visibility);
        List<Property> properties = ((Class_)this.classifier).getDeclaredProperties();
        for (Property prop : properties) {
            Type propertyType = null;
            if (!prop.isDataType()) {
                String oppositeClassNamespaceURI;
                Property oppositeProperty = prop.getOpposite();
                if (oppositeProperty != null) {
                    Class_ oppositeClass = oppositeProperty.getClass_();
                    oppositeClassNamespaceURI = oppositeClass.getNamespaceURI();
                    propertyType = PlasmaTypeHelper.INSTANCE.getType(oppositeClassNamespaceURI, oppositeClass.getName());
                } else {
                    Classifier repoClassifier = prop.getType();
                    oppositeClassNamespaceURI = repoClassifier.getNamespaceURI();
                    propertyType = PlasmaTypeHelper.INSTANCE.getType(oppositeClassNamespaceURI, repoClassifier.getName());
                }
            } else {
                Classifier propertyClassifier = prop.getType();
                DataType dataType = DataType.valueOf((String)propertyClassifier.getName());
                propertyType = PlasmaTypeHelper.INSTANCE.getType(PlasmaRuntime.getInstance().getSDODataTypesNamespace().getUri(), dataType.name());
            }
            CoreProperty property = new CoreProperty((CoreType)propertyType, prop, this);
            tempDeclaredPropertiesMap.put(property.getName(), property);
            PlasmaProperty existing = null;
            for (String alias : property.getAliasNames()) {
                existing = (PlasmaProperty)tempDeclaredPropertiesMap.get(alias);
                if (existing != null && !existing.getName().equals(property.getName())) {
                    throw new IllegalStateException("found existing property, " + existing.getContainingType().toString() + "." + existing.getName() + ", already mapped to alias '" + alias + "' while loading property " + this.toString() + "." + property.getName());
                }
                tempDeclaredPropertiesMap.put(alias, property);
            }
            existing = (PlasmaProperty)tempDeclaredPropertiesMap.get(property.getId());
            if (existing != null) {
                throw new IllegalStateException("found existing property, " + existing.getContainingType().toString() + "." + existing.getName() + ", already mapped to id '" + property.getId() + "' while loading property " + this.toString() + "." + property.getName());
            }
            tempDeclaredPropertiesMap.put(property.getId(), property);
            tempDeclaredPropertiesList.add(property);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " lazy loaded " + property));
            }
            if (property.isKey(KeyType.primary)) {
                ArrayList<CoreProperty> pkPropList = (ArrayList<CoreProperty>)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES);
                if (pkPropList == null) {
                    pkPropList = new ArrayList<CoreProperty>();
                    this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES, pkPropList);
                }
                pkPropList.add(property);
            }
            if (!property.isConcurrent()) continue;
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISCONCURRENT, new Boolean(true));
            PlasmaProperty existingConcurr = (PlasmaProperty)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENT_PROP);
            if (existingConcurr != null) {
                throw new IllegalStateException("found existing concurrent property, " + existingConcurr + ", already found on type, " + this);
            }
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENT_PROP, property);
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_ORIGINATION_TIMESTAMP, property);
            }
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.user)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_ORIGINATION_USER, property);
            }
            if (property.isConcurrent(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_LOCKING_TIMESTAMP, property);
            }
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.user)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_LOCKING_USER, property);
            }
            if (property.isConcurrent(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENT_TIMESTAMP, property);
            }
            if (property.isConcurrent(ConcurrencyType.optimistic, ConcurrentDataFlavor.version)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENT_VERSION, property);
            }
            if (!property.isConcurrent(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) continue;
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENT_USER, property);
        }
        this.declaredPropertiesList = tempDeclaredPropertiesList;
        this.declaredPropertiesMap = tempDeclaredPropertiesMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " end lazy load"));
        }
    }

    public String getName() {
        if (this.name == null) {
            return this.classifier.getName();
        }
        return this.name;
    }

    @Override
    public byte[] getNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES)) == null) {
            result = this.getName().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public QName getQualifiedName() {
        return this.qname;
    }

    @Override
    public byte[] getQualifiedNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_NAME_BYTES)) == null) {
            result = this.getQualifiedName().toString().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public QName getQualifiedPhysicalName() {
        String urPhysicalName;
        String physicalName = this.getPhysicalName();
        if (physicalName != null && (urPhysicalName = this.getURIPhysicalName()) != null) {
            return new QName(urPhysicalName, physicalName);
        }
        return null;
    }

    @Override
    public int getQualifiedNameHashCode() {
        return this.qnameHashCode;
    }

    @Override
    public byte[] getQualifiedPhysicalNameBytes() {
        QName qname;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_PHYSICAL_NAME_BYTES)) == null && (qname = this.getQualifiedPhysicalName()) != null) {
            result = qname.toString().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    public String getURI() {
        return this.namespaceURI;
    }

    @Override
    public byte[] getURIBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_URI_BYTES)) == null) {
            result = this.getURI().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_URI_BYTES, result);
        }
        return result;
    }

    @Override
    public String getPhysicalName() {
        if (this.physicalName == null) {
            return this.classifier.getPhysicalName();
        }
        return this.physicalName;
    }

    @Override
    public byte[] getPhysicalNameBytes() {
        String name;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES)) == null && (name = this.getPhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        Alias alias = this.classifier.findAlias();
        if (alias != null && alias.getLocalName() != null) {
            return alias.getLocalName();
        }
        return this.name;
    }

    @Override
    public byte[] getLocalNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES)) == null) {
            result = this.getLocalName().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getPackageName() {
        return this.classifier.getPackageName();
    }

    @Override
    public String getPackagePhysicalName() {
        return this.classifier.getPackagePhysicalName();
    }

    @Override
    public byte[] getPackagePhysicalNameBytes() {
        String name;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PACKAGE_PHYSICAL_NAME_BYTES)) == null && (name = this.getPackagePhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PACKAGE_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getURIPhysicalName() {
        return this.getPackagePhysicalName();
    }

    @Override
    public byte[] getURIPhysicalNameBytes() {
        return this.getPackagePhysicalNameBytes();
    }

    @Override
    public List<Comment> getDescription() {
        return (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
    }

    @Override
    public String getDescriptionText() {
        StringBuilder buf = new StringBuilder();
        List list = (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
        if (list != null) {
            for (Comment comment : list) {
                buf.append(comment.getBody());
            }
        }
        return buf.toString();
    }

    @Override
    public Alias getAlias() {
        return this.classifier.findAlias();
    }

    @Override
    public Classifier getClassifier() {
        return this.classifier;
    }

    public boolean isAbstract() {
        return this.classifier.isAbstract();
    }

    public boolean isDataType() {
        return this.classifier.isDataType();
    }

    public List<String> getAliasNames() {
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        String alias = (String)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_STRING_PHYSICAL_NAME);
        if (alias != null) {
            aliasList.add(alias);
        }
        if ((alias = (String)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_STRING_LOCAL_NAME)) != null) {
            aliasList.add(alias);
        }
        if ((alias = (String)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_STRING_BUSINESS_NAME)) != null) {
            aliasList.add(alias);
        }
        return aliasList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> getBaseTypes() {
        if (this.baseTypes == null) {
            CoreType coreType = this;
            synchronized (coreType) {
                this.initBaseTypes();
            }
        }
        return Collections.unmodifiableList(this.baseTypes);
    }

    private void initBaseTypes() {
        if (this.baseTypes == null) {
            ArrayList<Type> list = new ArrayList<Type>();
            PlasmaTypeHelper helper = PlasmaTypeHelper.INSTANCE;
            List<Classifier> generalizations = this.classifier.getGeneralization();
            for (Classifier classifier : generalizations) {
                String namespaceURI = classifier.getNamespaceURI();
                Type type = helper.getType(namespaceURI, classifier.getName());
                list.add(type);
            }
            this.baseTypes = list;
        }
    }

    @Override
    public boolean isBaseType(PlasmaType other) {
        for (Type t : this.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)t;
            if (baseType.getQualifiedNameHashCode() == other.getQualifiedNameHashCode()) {
                return true;
            }
            if (!baseType.isBaseType(other)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Type> getSubTypes() {
        if (this.subTypes == null) {
            CoreType coreType = this;
            synchronized (coreType) {
                this.initSubTypes();
            }
        }
        return Collections.unmodifiableList(this.subTypes);
    }

    private void initSubTypes() {
        if (this.subTypes == null) {
            ArrayList<Type> list = new ArrayList<Type>();
            PlasmaTypeHelper helper = PlasmaTypeHelper.INSTANCE;
            List<Classifier> specializations = this.classifier.getSpecializations();
            for (Classifier classifier : specializations) {
                String namespaceURI = classifier.getNamespaceURI();
                Type type = helper.getType(namespaceURI, classifier.getName());
                list.add(type);
            }
            this.subTypes = list;
        }
    }

    @Override
    public boolean isSubType(PlasmaType other) {
        for (Type t : this.getSubTypes()) {
            PlasmaType subType = (PlasmaType)t;
            if (subType.getQualifiedNameHashCode() == other.getQualifiedNameHashCode()) {
                return true;
            }
            if (!subType.isSubType(other)) continue;
            return true;
        }
        return false;
    }

    public List<commonj.sdo.Property> getDeclaredProperties() {
        if (!this.propertiesLoaded()) {
            this.lazyLoadProperties();
        }
        return Collections.unmodifiableList(this.declaredPropertiesList);
    }

    @Override
    public List<commonj.sdo.Property> getDeclaredPropertiesSorted() {
        List<commonj.sdo.Property> list = this.getDeclaredProperties();
        commonj.sdo.Property[] properties = new commonj.sdo.Property[list.size()];
        list.toArray(properties);
        Arrays.sort(properties, new Comparator<commonj.sdo.Property>(){

            @Override
            public int compare(commonj.sdo.Property o1, commonj.sdo.Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>(properties.length);
        commonj.sdo.Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            commonj.sdo.Property prop = propertyArray[n2];
            result.add(prop);
            ++n2;
        }
        return result;
    }

    public List<commonj.sdo.Property> getInstanceProperties() {
        if (!this.propertiesLoaded()) {
            this.lazyLoadProperties();
        }
        Iterator<PlasmaProperty> iter = this.instancePropertiesMap.keySet().iterator();
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>(this.instancePropertiesMap.size());
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public List<commonj.sdo.Property> getProperties() {
        if (!this.propertiesLoaded()) {
            this.lazyLoadProperties();
        }
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, result);
        return result;
    }

    public Object get(commonj.sdo.Property property) {
        if (!this.propertiesLoaded()) {
            this.lazyLoadProperties();
        }
        return this.instancePropertiesMap.get(property);
    }

    @Override
    public List<Object> search(commonj.sdo.Property property) {
        if (!this.propertiesLoaded()) {
            this.lazyLoadProperties();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.collectInstancePropertyValues(this, property, result);
        return result;
    }

    private void collectInstancePropertyValues(Type type, commonj.sdo.Property property, List<Object> result) {
        Object value = type.get(property);
        if (value != null) {
            result.add(value);
        }
        for (Type baseType : type.getBaseTypes()) {
            this.collectInstancePropertyValues(baseType, property, result);
        }
    }

    public commonj.sdo.Property getProperty(String propertyName) {
        commonj.sdo.Property result = this.findDeclaredProperty(this, propertyName);
        if (result == null) {
            throw new IllegalArgumentException("given property name '" + propertyName + "' is undefined for type " + this.getURI() + "#" + this.getName() + " and all its base types");
        }
        return result;
    }

    @Override
    public commonj.sdo.Property findProperty(String propertyName) {
        return this.findDeclaredProperty(this, propertyName);
    }

    @Override
    public commonj.sdo.Property findProperty(ConcurrencyType concurrencyType) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties((PlasmaType)this, concurrencyType, properties);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (commonj.sdo.Property)properties.get(0);
        }
        log.warn((Object)("Found multiple declared properties for type " + this.getURI() + "#" + this.getName() + " tagged with " + ConcurrencyType.class.getSimpleName() + " '" + concurrencyType.name() + "'"));
        return (commonj.sdo.Property)properties.get(0);
    }

    @Override
    public commonj.sdo.Property findProperty(ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, concurrencyType, dataFlavor, properties);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (commonj.sdo.Property)properties.get(0);
        }
        log.warn((Object)("Found multiple declared properties for type " + this.getURI() + "#" + this.getName() + " tagged with " + ConcurrencyType.class.getSimpleName() + " '" + concurrencyType.name() + "' and concurrency data flavor '" + dataFlavor.name() + "'"));
        return (commonj.sdo.Property)properties.get(0);
    }

    @Override
    public commonj.sdo.Property findProperty(KeyType keyType) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties((PlasmaType)this, keyType, properties);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (commonj.sdo.Property)properties.get(0);
        }
        log.warn((Object)("Found multiple declared properties for type " + this.getURI() + "#" + this.getName() + " tagged with " + KeyType.class.getSimpleName() + " '" + keyType.name() + "'"));
        return (commonj.sdo.Property)properties.get(0);
    }

    @Override
    public List<commonj.sdo.Property> findProperties(KeyType keyType) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties((PlasmaType)this, keyType, properties);
        return properties;
    }

    private commonj.sdo.Property findDeclaredProperty(PlasmaType currentType, String propertyName) {
        commonj.sdo.Property result;
        CoreType currentCoreType = (CoreType)currentType;
        if (!currentCoreType.propertiesLoaded()) {
            currentCoreType.lazyLoadProperties();
        }
        if ((result = (commonj.sdo.Property)currentCoreType.declaredPropertiesMap.get(propertyName)) != null) {
            return result;
        }
        for (Type base : currentCoreType.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)base;
            result = this.findDeclaredProperty(baseType, propertyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private commonj.sdo.Property findDeclaredProperty(PlasmaType currentType, ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor) {
        CoreType currentCoreType = (CoreType)currentType;
        if (!currentCoreType.propertiesLoaded()) {
            currentCoreType.lazyLoadProperties();
        }
        commonj.sdo.Property result = null;
        for (commonj.sdo.Property property : this.getDeclaredProperties()) {
            if (!((PlasmaProperty)property).isConcurrent(concurrencyType, dataFlavor)) continue;
            result = property;
            break;
        }
        for (Type base : currentCoreType.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)base;
            result = this.findDeclaredProperty(baseType, concurrencyType, dataFlavor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void collectDeclaredProperties(PlasmaType type, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, properties);
        }
    }

    private void collectDeclaredProperties(PlasmaType type, ConcurrencyType concurrencyType, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            PlasmaProperty plasmaProp = (PlasmaProperty)p;
            if (!plasmaProp.isConcurrent(concurrencyType)) continue;
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, concurrencyType, properties);
        }
    }

    private void collectDeclaredProperties(PlasmaType type, ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            PlasmaProperty plasmaProp = (PlasmaProperty)p;
            if (!plasmaProp.isConcurrent(concurrencyType, dataFlavor)) continue;
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, concurrencyType, dataFlavor, properties);
        }
    }

    private void collectDeclaredProperties(PlasmaType type, KeyType keyType, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            PlasmaProperty plasmaProp = (PlasmaProperty)p;
            if (!plasmaProp.isKey(keyType)) continue;
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, keyType, properties);
        }
    }

    public Class<?> getInstanceClass() {
        if (!this.isDataType()) {
            org.plasma.runtime.Namespace namespace = PlasmaRuntime.getInstance().getSDONamespaceByURI(this.getURI());
            if (namespace != null && namespace.getProvisioning() != null) {
                String qualifiedName = String.valueOf(namespace.getProvisioning().getPackageName()) + "." + this.getName();
                try {
                    Class<?> interfaceImplClass = Class.forName(qualifiedName);
                    return interfaceImplClass;
                }
                catch (ClassNotFoundException e) {
                    return CoreDataObject.class;
                }
            }
            return CoreDataObject.class;
        }
        return this.toDataTypeInstanceClass(DataType.valueOf((String)this.getName()));
    }

    public boolean isInstance(Object object) {
        boolean result = false;
        if (DataObject.class.isAssignableFrom(object.getClass())) {
            DataObject dataObject = (DataObject)object;
            Type type = dataObject.getType();
            result = type.getName().equals(this.getName()) && type.getURI().equals(this.getURI());
        } else if (this.isDataType()) {
            Class<?> instanceClass = this.toDataTypeInstanceClass(DataType.valueOf((String)this.getName()));
            return instanceClass.isAssignableFrom(object.getClass());
        }
        return result;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isSequenced() {
        return false;
    }

    @Override
    public Class<?> toDataTypeInstanceClass(DataType dataType) {
        return DataConverter.INSTANCE.toWrapperJavaClass(dataType);
    }

    @Override
    public boolean isRelation(PlasmaType other, AssociationPath relationPath) {
        return ((Class_)this.classifier).isRelation((Class_)other.getClassifier(), relationPath);
    }

    @Override
    public Derivation getDerivation() {
        return this.classifier.findDerivation();
    }

    @Override
    public PlasmaType getDerivationSupplier() {
        Classifier classifier = this.classifier.getDerivationSupplier();
        if (classifier != null) {
            return this.lookup(classifier);
        }
        return null;
    }

    private PlasmaType lookup(Classifier repoClassifier) {
        String repoClassNamespaceURI = repoClassifier.getNamespaceURI();
        String repoTypeName = repoClassifier.getName();
        TypeBindingAdapter binding = PlasmaRuntime.getInstance().findTypeBinding(repoClassNamespaceURI, repoClassifier.getName());
        if (binding != null && binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
            repoTypeName = binding.getLogicalName().trim();
        }
        PlasmaType repoType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(repoClassNamespaceURI, repoTypeName);
        return repoType;
    }

    @Override
    public String getId() {
        return this.classifier.getId();
    }

    @Override
    public boolean isConcurrent() {
        Boolean result = (Boolean)this.findInstancePropertyValue(this, PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISCONCURRENT);
        if (result != null) {
            return result;
        }
        return false;
    }

    private Object findInstancePropertyValue(PlasmaType currentType, PlasmaProperty instanceProp) {
        Object result;
        CoreType currentCoreType = (CoreType)currentType;
        if (!currentCoreType.propertiesLoaded()) {
            currentCoreType.lazyLoadProperties();
        }
        if ((result = currentCoreType.get(instanceProp)) != null) {
            return result;
        }
        for (Type base : currentCoreType.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)base;
            result = this.findInstancePropertyValue(baseType, instanceProp);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

