/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.plasma.runtime.ConfigurationException;

public class PlasmaCacheDelegate<T> {
    private static String cacheFileName = "ehcache.xml";
    private CacheManager cacheManager;
    private Cache cache;

    private PlasmaCacheDelegate() {
    }

    public PlasmaCacheDelegate(String cacheName) {
        InputStream is = PlasmaCacheDelegate.class.getClassLoader().getResourceAsStream(cacheFileName);
        if (is == null) {
            throw new ConfigurationException("no ehcache file found: " + cacheFileName);
        }
        this.cacheManager = CacheManager.create((InputStream)is);
        if (!this.cacheManager.cacheExists(cacheName)) {
            this.cacheManager.addCache(cacheName);
        }
        this.cache = this.cacheManager.getCache(cacheName);
    }

    public T getObject(Serializable key) {
        Element elem = this.cache.get(key);
        return (T)(elem != null ? elem.getObjectValue() : null);
    }

    public void putObject(Serializable key, T object) {
        Element elem = new Element((Object)key, object);
        this.cache.put(elem);
    }

    public T clearObject(Serializable key) {
        Element elem = this.cache.get(key);
        if (elem != null) {
            Object object = elem.getObjectValue();
            this.cache.remove(key);
            return (T)object;
        }
        return null;
    }
}

