/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.runtime.ConfigurationException;
import org.plasma.sdo.PlasmaDataObjectConstants;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.helper.PlasmaCacheDelegate;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.InvalidClassifierNameException;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Stereotype;

public class PlasmaTypeHelper
implements TypeHelper {
    private static Log log = LogFactory.getLog(PlasmaTypeHelper.class);
    public static volatile PlasmaTypeHelper INSTANCE = PlasmaTypeHelper.initializeInstance();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private PlasmaCacheDelegate<PlasmaType> namespaceQualifiedNameToTypeCache;
    private Map<String, String> qualifiedAliasToLogicalNameMap = new HashMap<String, String>();

    private PlasmaTypeHelper() {
        try {
            this.namespaceQualifiedNameToTypeCache = new PlasmaCacheDelegate("plasmaTypeCache");
        }
        catch (ConfigurationException ce) {
            log.warn((Object)"no cache configuration found - continuing w/o cache");
        }
    }

    private static synchronized PlasmaTypeHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaTypeHelper();
        }
        return INSTANCE;
    }

    public Type getType(String uri, String typeName) {
        String qualifiedName = String.valueOf(uri) + "#" + typeName;
        return this.getType(qualifiedName);
    }

    public Type findTypeByPhysicalName(String uriPhisicalName, String typePhysicalName) {
        String qualifiedPhysicalName = String.valueOf(uriPhisicalName) + "#" + typePhysicalName;
        return this.getType(qualifiedPhysicalName);
    }

    private Type getType(String qualifiedName) {
        this.lock.readLock().lock();
        PlasmaType result = null;
        if (this.namespaceQualifiedNameToTypeCache != null) {
            result = this.namespaceQualifiedNameToTypeCache.getObject((Serializable)((Object)qualifiedName));
        }
        if (result == null) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.namespaceQualifiedNameToTypeCache != null) {
                    result = this.namespaceQualifiedNameToTypeCache.getObject((Serializable)((Object)qualifiedName));
                }
                if (result == null) {
                    result = this.createAndCacheType(qualifiedName);
                }
                this.lock.readLock().lock();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().unlock();
        return result;
    }

    private PlasmaType createAndCacheType(String qualifiedName) {
        String qualifiedPhysicalName;
        CoreType result = null;
        String qualifiedLogicalName = qualifiedName;
        if (this.qualifiedAliasToLogicalNameMap.containsKey(qualifiedLogicalName)) {
            qualifiedLogicalName = this.qualifiedAliasToLogicalNameMap.get(qualifiedLogicalName);
        }
        String[] tokens = qualifiedLogicalName.split("#");
        try {
            result = new CoreType(tokens[0], tokens[1]);
        }
        catch (InvalidClassifierNameException e) {
            log.warn((Object)e.getMessage(), (Throwable)((Object)e));
            return null;
        }
        if (this.namespaceQualifiedNameToTypeCache != null) {
            this.namespaceQualifiedNameToTypeCache.putObject((Serializable)((Object)qualifiedName), result);
        }
        if (!result.getName().equals(tokens[1])) {
            String aliasQualifiedName = String.valueOf(tokens[0]) + "#" + result.getName();
            this.qualifiedAliasToLogicalNameMap.put(aliasQualifiedName, qualifiedLogicalName);
        }
        if ((qualifiedPhysicalName = this.findQualifiedPhysicalName(result)) != null) {
            this.qualifiedAliasToLogicalNameMap.put(qualifiedPhysicalName, qualifiedLogicalName);
        }
        return result;
    }

    public void releaseType(Type type) {
        this.releaseType(type.getURI(), type.getName());
    }

    public void releaseType(String uri, String typeName) {
        String qualifiedName = String.valueOf(uri) + "#" + typeName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("releasing type: " + qualifiedName));
        }
        if (this.namespaceQualifiedNameToTypeCache != null) {
            this.namespaceQualifiedNameToTypeCache.clearObject((Serializable)((Object)qualifiedName));
        }
    }

    public Type getType(Class interfaceClass) {
        String uri = null;
        try {
            Field uriField = interfaceClass.getDeclaredField(PlasmaDataObjectConstants.NAMESPACE_URI_FIELD_NAME);
            uri = (String)uriField.get(null);
        }
        catch (SecurityException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new PlasmaDataObjectException(e);
        }
        return this.getType(uri, interfaceClass.getSimpleName());
    }

    public List<Type> getTypes(String uri) {
        ArrayList<Type> result = new ArrayList<Type>();
        List<Classifier> list = PlasmaRepository.getInstance().getClassifiers(uri);
        for (Classifier classifier : list) {
            if (classifier instanceof Stereotype) {
                log.warn((Object)("ignoring stereotype: " + classifier.getName()));
                continue;
            }
            Type type = this.getType(uri, classifier.getName());
            result.add(type);
        }
        return result;
    }

    public Type define(DataObject type) {
        throw new RuntimeException("not yet supported");
    }

    public List define(List types) {
        throw new RuntimeException("not yet supported");
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        throw new RuntimeException("not yet supported");
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        throw new RuntimeException("not yet supported");
    }

    private String getQualifiedName(PlasmaType type) {
        return String.valueOf(type.getURI()) + "#" + type.getName();
    }

    private String findQualifiedPhysicalName(PlasmaType type) {
        String uriPhysicalName = type.getURIPhysicalName();
        if (uriPhysicalName == null) {
            return null;
        }
        String physicalName = type.getPhysicalName();
        if (physicalName == null) {
            return null;
        }
        return String.valueOf(uriPhysicalName) + "#" + physicalName;
    }
}

