/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.XMLDocument;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.xml.MarshallerFlavor;
import org.plasma.sdo.xml.XMLOptions;
import org.plasma.sdo.xml.XMLProcessor;

public abstract class Marshaller
extends XMLProcessor {
    protected XMLDocument document;
    protected MarshallerFlavor flavor;

    private Marshaller() {
    }

    protected Marshaller(MarshallerFlavor flavor, XMLDocument document) {
        this.flavor = flavor;
        this.document = document;
        if (this.document == null) {
            throw new IllegalArgumentException("expected 'document' argument");
        }
    }

    protected Marshaller(XMLDocument document, XMLOptions options) {
        super(options);
        this.document = document;
        if (this.document == null) {
            throw new IllegalArgumentException("expected 'document' argument");
        }
    }

    protected String fromObject(Type sourceType, Object value) {
        return DataConverter.INSTANCE.toString(sourceType, value);
    }

    protected class PathNode {
        private DataObject target;
        private DataObject source;
        private Property sourceProperty;
        private Object userObject;
        private boolean terminated;

        private PathNode() {
        }

        public PathNode(DataObject target, Object userObject, DataObject source, Property sourceProperty) {
            this.target = target;
            this.userObject = userObject;
            this.source = source;
            this.sourceProperty = sourceProperty;
        }

        public PathNode(DataObject target, DataObject source, Property sourceProperty) {
            this.target = target;
            this.source = source;
            this.sourceProperty = sourceProperty;
        }

        public DataObject getTarget() {
            return this.target;
        }

        public DataObject getSource() {
            return this.source;
        }

        public Property getSourceProperty() {
            return this.sourceProperty;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }
    }
}

