/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import org.plasma.sdo.PlasmaType;

public abstract class StreamNode {
    private PlasmaType type;
    protected int line;
    protected int column;
    protected QName name;

    private StreamNode() {
    }

    public StreamNode(PlasmaType type, QName name, Location loc) {
        if (type == null) {
            throw new IllegalArgumentException("expected type argument");
        }
        this.type = type;
        this.name = name;
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public PlasmaType getType() {
        return this.type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getLocalName() {
        return this.name.getLocalPart();
    }

    public String getNamespaceURI() {
        return this.name.getNamespaceURI();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }
}

