/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xpath;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.util.SingleObjectIterator;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.xpath.DataGraphXPath;
import org.plasma.sdo.xpath.XPathDataObject;
import org.plasma.sdo.xpath.XPathDataProperty;
import org.plasma.sdo.xpath.XPathDataValue;

public class DataGraphNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = -1636727587303584165L;
    private static Log log = LogFactory.getFactory().getInstance(DataGraphNavigator.class);

    public boolean isElement(Object obj) {
        return obj instanceof XPathDataObject;
    }

    public boolean isComment(Object obj) {
        return false;
    }

    public boolean isText(Object obj) {
        return obj instanceof XPathDataValue;
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof XPathDataProperty;
    }

    public boolean isProcessingInstruction(Object obj) {
        return false;
    }

    public boolean isDocument(Object obj) {
        return false;
    }

    public boolean isNamespace(Object obj) {
        return false;
    }

    public String getElementName(Object obj) {
        XPathDataObject elem = (XPathDataObject)obj;
        return elem.getDataObject().getType().getName();
    }

    public String getElementNamespaceUri(Object obj) {
        XPathDataObject elem = (XPathDataObject)obj;
        String uri = elem.getDataObject().getType().getURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public String getAttributeName(Object obj) {
        XPathDataProperty attr = (XPathDataProperty)obj;
        return attr.getProperty().getName();
    }

    public String getAttributeNamespaceUri(Object obj) {
        XPathDataProperty attr = (XPathDataProperty)obj;
        String uri = attr.getProperty().getType().getURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        if (contextNode instanceof XPathDataProperty) {
            XPathDataProperty contextProperty = (XPathDataProperty)contextNode;
            Property property = contextProperty.getProperty();
            Object target = contextProperty.getSource().get(property);
            if (target != null) {
                if (target instanceof List) {
                    return ((List)target).iterator();
                }
                return new SingleObjectIterator((Object)new XPathDataValue(target, contextProperty.getSource(), property));
            }
            return new SingleObjectIterator((Object)new XPathDataValue(null, contextProperty.getSource(), property));
        }
        if (contextNode instanceof PlasmaDataObject) {
            return this.getChildResult((PlasmaDataObject)contextNode);
        }
        return this.getChildResult(((XPathDataObject)contextNode).getDataObject());
    }

    public Iterator getChildAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (contextNode instanceof PlasmaDataObject) {
            PlasmaDataObject source = (PlasmaDataObject)contextNode;
            return this.getChildResult(source, localName);
        }
        if (contextNode instanceof XPathDataObject) {
            XPathDataObject contextAdapter = (XPathDataObject)contextNode;
            PlasmaDataObject source = contextAdapter.getDataObject();
            return this.getChildResult(source, localName);
        }
        throw new IllegalArgumentException("unexpected instance, " + contextNode.getClass().getName());
    }

    private Iterator getChildResult(PlasmaDataObject source, String localName) {
        Property sourceProp;
        String propertyName = localName;
        int indexPosition = localName.indexOf(".");
        int index = 0;
        if (indexPosition >= 0) {
            propertyName = localName.substring(0, indexPosition);
            try {
                index = Integer.parseInt(localName.substring(indexPosition + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(localName, e);
            }
        }
        if ((sourceProp = ((PlasmaType)source.getType()).findProperty(propertyName)) == null) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        if (sourceProp.getType().isDataType()) {
            return new SingleObjectIterator((Object)new XPathDataProperty(sourceProp, source, sourceProp));
        }
        if (!sourceProp.isMany() && indexPosition >= 0) {
            throw new IllegalArgumentException("index specified for singular property, " + source.getType().getURI() + "#" + source.getType().getName() + "." + propertyName);
        }
        Object target = source.get(sourceProp);
        if (target != null) {
            if (target instanceof List) {
                List targetList = (List)target;
                ArrayList<XPathDataObject> list = new ArrayList<XPathDataObject>(targetList.size());
                if (indexPosition == -1) {
                    for (Object targetObject : targetList) {
                        PlasmaDataObject dataObject = (PlasmaDataObject)targetObject;
                        list.add(new XPathDataObject(dataObject, source, sourceProp));
                    }
                } else {
                    try {
                        PlasmaDataObject dataObject = (PlasmaDataObject)targetList.get(index);
                        list.add(new XPathDataObject(dataObject, source, sourceProp));
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalArgumentException(localName, e);
                    }
                }
                return list.iterator();
            }
            return new SingleObjectIterator((Object)new XPathDataObject((PlasmaDataObject)target, source, sourceProp));
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    private Iterator getChildResult(PlasmaDataObject source) {
        final ArrayList children = new ArrayList();
        PlasmaDataGraphVisitor visitor = new PlasmaDataGraphVisitor(){

            @Override
            public void visit(DataObject target, DataObject traversalSource, String sourcePropertyName, int level) {
                if (traversalSource == null) {
                    return;
                }
                Property sourceProperty = traversalSource.getType().getProperty(sourcePropertyName);
                children.add(new XPathDataObject((PlasmaDataObject)target, (PlasmaDataObject)traversalSource, sourceProperty));
            }
        };
        source.accept(visitor, 1);
        return children.iterator();
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XPathDataObject)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        XPathDataObject elem = (XPathDataObject)contextNode;
        return elem.getDataObject().getType().getProperties().iterator();
    }

    public Iterator getAttributeAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (contextNode instanceof XPathDataObject) {
            XPathDataObject adapter = (XPathDataObject)contextNode;
            Property prop = adapter.getDataObject().getType().getProperty(localName);
            return new SingleObjectIterator((Object)new XPathDataProperty(prop, adapter.getDataObject(), prop));
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new DataGraphXPath(xpath);
    }

    public Object getDocumentNode(Object contextNode) {
        DataObject dataObject = null;
        if (contextNode instanceof DataObject) {
            dataObject = (DataObject)contextNode;
        } else if (contextNode instanceof XPathDataObject) {
            dataObject = ((XPathDataObject)contextNode).getDataObject();
        }
        return dataObject.getDataGraph().getRootObject();
    }

    public String getElementQName(Object obj) {
        XPathDataObject elem = (XPathDataObject)obj;
        return elem.getDataObject().getType().getName();
    }

    public String getAttributeQName(Object obj) {
        XPathDataProperty adapter = (XPathDataProperty)obj;
        return adapter.getProperty().getName();
    }

    public String getNamespaceStringValue(Object obj) {
        return obj.toString();
    }

    public String getNamespacePrefix(Object obj) {
        return obj.toString();
    }

    public String getTextStringValue(Object obj) {
        return obj.toString();
    }

    public String getAttributeStringValue(Object obj) {
        XPathDataProperty adapter = (XPathDataProperty)obj;
        return adapter.getSource().getString(adapter.getProperty());
    }

    public String getElementStringValue(Object obj) {
        return obj.toString();
    }

    public String getProcessingInstructionTarget(Object obj) {
        return null;
    }

    public String getProcessingInstructionData(Object obj) {
        return null;
    }

    public String getCommentStringValue(Object obj) {
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object context) {
        XPathDataObject element = null;
        if (context instanceof XPathDataObject) {
            element = (XPathDataObject)context;
            return element.getDataObject().getType().getURI();
        }
        return null;
    }

    public Object getDocument(String url) throws FunctionCallException {
        throw new UnsupportedOperationException();
    }
}

