/**
 * Copyright 2017 TerraMeta Software, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.plasma.sdo;

import org.plasma.sdo.core.CoreEdge;
import org.plasma.sdo.core.TraversalDirection;

public class PlasmaDataLink extends CoreEdge implements PlasmaEdge {
  protected PlasmaNode left;
  protected PlasmaNode right;

  @SuppressWarnings("unused")
  private PlasmaDataLink() {
  }

  public PlasmaDataLink(PlasmaNode left, PlasmaNode right) {
    this.left = left;
    this.right = right;
  }

  public boolean canTraverse(PlasmaNode fromNode) {
    return this.getDirection() == TraversalDirection.RIGHT && left.equals(fromNode);
  }

  public PlasmaNode getOpposite(PlasmaNode fromNode) {
    if (this.left.equals(fromNode))
      return right;
    else if (this.right.equals(fromNode))
      return left;
    else
      throw new IllegalArgumentException("given node '" + fromNode.getUUIDAsString()
          + "' not found");
  }

  public PlasmaNode getLeft() {
    return left;
  }

  public void setLeft(PlasmaNode left) {
    this.left = left;
  }

  public PlasmaNode getRight() {
    return right;
  }

  public void setRight(PlasmaNode right) {
    this.right = right;
  }
}
