/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import jakarta.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.ValueConstraint;
import org.plasma.provisioning.xsd.AbstractAssembler;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.xml.schema.AbstractSimpleType;
import org.plasma.xml.schema.Facet;
import org.plasma.xml.schema.Pattern;
import org.plasma.xml.schema.Restriction;

public class ConstraintAssembler
extends AbstractAssembler {
    private static Log log = LogFactory.getLog(ConstraintAssembler.class);

    public ConstraintAssembler(ConverterSupport converterSupport, String destNamespaceURI, String destNamespacePrefix) {
        super(destNamespaceURI, destNamespacePrefix, converterSupport);
    }

    public EnumerationConstraint buildEnumerationConstraint(AbstractSimpleType simpleType, AbstractSimpleType source) {
        EnumerationConstraint constraint = new EnumerationConstraint();
        EnumerationRef enumRef = new EnumerationRef();
        String localName = null;
        if (simpleType.getName() != null) {
            localName = simpleType.getName();
        } else if (source.getName() != null) {
            localName = source.getName();
        } else {
            throw new IllegalStateException("could not create enumeration reference");
        }
        String logicalName = this.formatLocalClassName(localName);
        enumRef.setName(logicalName);
        enumRef.setUri(this.destNamespaceURI);
        constraint.setValue(enumRef);
        return constraint;
    }

    public ValueConstraint buildValueConstraint(AbstractSimpleType simpleType) {
        return this.buildValueConstraint(simpleType.getRestriction());
    }

    public ValueConstraint buildValueConstraint(Restriction rest) {
        ValueConstraint constraint = new ValueConstraint();
        for (Object obj : rest.getMinExclusivesAndMinInclusivesAndMaxExclusives()) {
            if (obj instanceof JAXBElement) {
                Facet numFacet;
                JAXBElement facet = (JAXBElement)obj;
                if (facet.getName().getLocalPart().equals("maxInclusive")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setMaxInclusive(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("minInclusive")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setMinInclusive(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("minExclusive")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setMinExclusive(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("maxExclusive")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setMaxExclusive(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("totalDigits")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setTotalDigits(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("fractionDigits")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setFractionDigits(numFacet.getValue());
                    continue;
                }
                if (facet.getName().getLocalPart().equals("maxLength")) {
                    numFacet = (Facet)facet.getValue();
                    constraint.setMaxLength(numFacet.getValue());
                    continue;
                }
                if (!facet.getName().getLocalPart().equals("minLength")) continue;
                numFacet = (Facet)facet.getValue();
                constraint.setMinLength(numFacet.getValue());
                continue;
            }
            if (!(obj instanceof Pattern)) continue;
            Pattern pattern = (Pattern)obj;
            constraint.setPattern(pattern.getValue());
        }
        return constraint;
    }
}

