/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import jakarta.xml.bind.JAXBElement;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.metamodel.Alias;
import org.plasma.metamodel.Body;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.Key;
import org.plasma.metamodel.KeyType;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.metamodel.Sort;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.ValueConstraint;
import org.plasma.metamodel.VisibilityType;
import org.plasma.metamodel.XmlNodeType;
import org.plasma.metamodel.XmlProperty;
import org.plasma.provisioning.xsd.ConstraintAssembler;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.provisioning.xsd.EnumerationAssembler;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Attribute;
import org.plasma.xml.schema.ComplexType;
import org.plasma.xml.schema.Element;
import org.plasma.xml.schema.ExplicitGroup;
import org.plasma.xml.schema.ExtensionType;
import org.plasma.xml.schema.Facet;
import org.plasma.xml.schema.LocalElement;
import org.plasma.xml.schema.LocalSimpleType;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaConverter;
import org.plasma.xml.schema.SchemaUtil;
import org.plasma.xml.schema.SimpleType;

public class SDOXSchemaConverter
extends ConverterSupport
implements SchemaConverter {
    private static Log log = LogFactory.getLog(SDOXSchemaConverter.class);
    private QName appNamespaceQName;
    private EnumerationAssembler enumerationAssembler;
    private ConstraintAssembler constraintAssembler;

    public SDOXSchemaConverter(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        super(schema, destNamespaceURI, destNamespacePrefix);
        this.enumerationAssembler = new EnumerationAssembler(this, destNamespaceURI, destNamespacePrefix);
        this.constraintAssembler = new ConstraintAssembler(this, destNamespaceURI, destNamespacePrefix);
    }

    @Override
    public Model buildModel() {
        ComplexType complexType;
        Model model = new Model();
        model.setName(this.schema.getId());
        model.setId(UUID.randomUUID().toString());
        model.setUri(this.destNamespaceURI);
        this.appNamespaceQName = this.findOpenAttributeQNameByValue(this.schema.getTargetNamespace(), (OpenAttrs)this.schema);
        for (Annotated annotated : this.schema.getSimpleTypesAndComplexTypesAndGroups()) {
            if (annotated instanceof ComplexType) {
                ComplexType complexType2 = (ComplexType)annotated;
                if (complexType2.getName().equals(SchemaUtil.getSerializationBaseTypeName())) continue;
                this.complexTypeMap.put(complexType2.getName(), complexType2);
                Class cls = this.buildClass((Package)model, complexType2);
                this.classQualifiedNameMap.put(this.destNamespaceURI + "#" + cls.getName(), cls);
                continue;
            }
            if (annotated instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)annotated;
                this.simpleTypeMap.put(simpleType.getName(), simpleType);
                continue;
            }
            if (annotated instanceof Element) continue;
            log.warn((Object)("unknown annotated class, " + annotated.getClass().getName()));
        }
        for (Annotated annotated : this.schema.getSimpleTypesAndComplexTypesAndGroups()) {
            Element element;
            if (!(annotated instanceof Element) || (element = (Element)annotated).getName().equals(SchemaUtil.getSerializationBaseTypeName()) || (complexType = (ComplexType)this.complexTypeMap.get(element.getName())) != null) continue;
            throw new IllegalStateException("found top-level Element '" + element.getName() + "' but expected top-level " + "ComplexType with the same name (XML Schema re-use best practice)");
        }
        for (Class cls : this.classQualifiedNameMap.values()) {
            String localName = cls.getName();
            if (cls.getAlias() != null && cls.getAlias().getLocalName() != null) {
                localName = cls.getAlias().getLocalName();
            }
            complexType = (ComplexType)this.complexTypeMap.get(localName);
            List annotatedList = null;
            annotatedList = complexType.getComplexContent() == null ? complexType.getAttributesAndAttributeGroups() : complexType.getComplexContent().getExtension().getAttributesAndAttributeGroups();
            for (Annotated annot : annotatedList) {
                if (annot instanceof Attribute) {
                    Attribute attribute = (Attribute)annot;
                    Property property = this.buildDatatypeProperty(complexType, attribute);
                    cls.getProperties().add(property);
                    continue;
                }
                throw new IllegalStateException("unexpected ComplexType child class, " + annot.getClass().getName());
            }
            ExplicitGroup sequence = null;
            sequence = complexType.getComplexContent() == null ? complexType.getSequence() : complexType.getComplexContent().getExtension().getSequence();
            if (sequence == null) continue;
            for (int i = 0; i < sequence.getElementsAndGroupsAndAlls().size(); ++i) {
                JAXBElement element;
                Object obj = sequence.getElementsAndGroupsAndAlls().get(i);
                if (obj instanceof JAXBElement) {
                    element = (JAXBElement)obj;
                    if (!(element.getValue() instanceof LocalElement)) {
                        throw new IllegalStateException("unexpected JAXBElement value class, " + element.getValue().getClass().getName());
                    }
                } else {
                    throw new IllegalStateException("unexpected sequence child class, " + obj.getClass().getName());
                }
                LocalElement localElement = (LocalElement)element.getValue();
                Property property = this.buildProperty(complexType, localElement, i);
                cls.getProperties().add(property);
            }
        }
        for (Class cls : this.classQualifiedNameMap.values()) {
            Property[] props = new Property[cls.getProperties().size()];
            cls.getProperties().toArray(props);
            for (Property prop : props) {
                if (prop.getType() instanceof DataTypeRef) continue;
                ClassRef classRef = (ClassRef)prop.getType();
                String qualifiedName = classRef.getUri() + "#" + classRef.getName();
                Class targetClass = (Class)this.classQualifiedNameMap.get(qualifiedName);
                if (targetClass == null) {
                    throw new IllegalStateException("no class definition found for qualified name '" + qualifiedName + "'");
                }
                Property targetProperty = null;
                Property[] pdefs2 = new Property[targetClass.getProperties().size()];
                targetClass.getProperties().toArray(pdefs2);
                for (Property pdef2 : pdefs2) {
                    if (!pdef2.getName().equals(prop.getOpposite())) continue;
                    targetProperty = pdef2;
                    break;
                }
                if (targetProperty != null || prop.getOpposite() == null) continue;
                targetProperty = this.createDerivedPropertyOpposite(cls, prop);
                targetClass.getProperties().add(targetProperty);
            }
        }
        for (SimpleType simpleType : this.simpleTypeMap.values()) {
            Enumeration enm = this.enumerationAssembler.buildEnumeration(simpleType);
            model.getEnumerations().add(enm);
        }
        return model;
    }

    private Class buildClass(Package pkg, ComplexType complexType) {
        ExtensionType baseType;
        QName base;
        Class clss = new Class();
        pkg.getClazzs().add(clss);
        clss.setId(UUID.randomUUID().toString());
        clss.setUri(this.destNamespaceURI);
        Alias alias = new Alias();
        clss.setAlias(alias);
        alias.setLocalName(complexType.getName());
        String name = this.getSDOXValue(complexType, "name");
        clss.setName(name);
        String physicalNameAlias = this.findSDOXValue(complexType, "aliasName");
        if (physicalNameAlias != null) {
            alias.setPhysicalName(physicalNameAlias);
        }
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent((Annotated)complexType));
        clss.getDocumentations().add(documentation);
        if (complexType.getComplexContent() != null && !(base = (baseType = complexType.getComplexContent().getExtension()).getBase()).getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
            ClassRef baseRef = new ClassRef();
            baseRef.setName(base.getLocalPart());
            baseRef.setUri(this.destNamespaceURI);
            clss.getSuperClasses().add(baseRef);
        }
        return clss;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Property buildProperty(ComplexType complexType, LocalElement element, int sequenceNum) {
        QName typeQName;
        QName aliasQName;
        String physicalNameAlias;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        Alias alias = new Alias();
        property.setAlias(alias);
        alias.setLocalName(element.getName());
        QName nameQName = new QName("commonj.sdo/xml", "name", "sdox");
        String name = this.getOpenAttributeValue(nameQName, (OpenAttrs)element);
        property.setName(name);
        XmlProperty xmlProp = new XmlProperty();
        xmlProp.setNodeType(XmlNodeType.ELEMENT);
        property.setXmlProperty(xmlProp);
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent((Annotated)element));
        property.getDocumentations().add(documentation);
        property.setVisibility(VisibilityType.PUBLIC);
        if ("1".equals(String.valueOf(element.getMinOccurs()))) {
            property.setNullable(false);
        }
        if ((physicalNameAlias = this.findOpenAttributeValue(aliasQName = new QName("commonj.sdo/xml", "aliasName", "sdox"), (OpenAttrs)element)) != null) {
            alias.setPhysicalName(physicalNameAlias);
        } else if (!"unbounded".equals(element.getMaxOccurs())) {
            log.warn((Object)("expected SDOX 'aliasName' attribute for local Element '" + element.getName() + "' for ComplexType '" + complexType.getName() + "'"));
        }
        QName manyQName = new QName("commonj.sdo/xml", "many", "sdox");
        Boolean many = new Boolean(this.getOpenAttributeValue(manyQName, (OpenAttrs)element));
        if (many.booleanValue()) {
            property.setMany(true);
        } else {
            property.setMany(false);
        }
        QName keyQName = new QName("commonj.sdo/xml", "key", "sdox");
        Boolean isKey = new Boolean(this.findOpenAttributeValue(keyQName, (OpenAttrs)element));
        if (isKey.booleanValue()) {
            property.setVisibility(VisibilityType.PRIVATE);
            Key key = new Key();
            key.setType(KeyType.PRIMARY);
            property.setKey(key);
        }
        if ((typeQName = element.getType()).getPrefix() == null || this.appNamespaceQName != null && typeQName.getPrefix().equals(this.appNamespaceQName.getPrefix())) {
            QName datatypeQName;
            Class targetDef;
            QName oppositeQName = new QName("commonj.sdo/xml", "oppositeProperty", "sdox");
            String oppositeName = this.findOpenAttributeValue(oppositeQName, (OpenAttrs)element);
            if (oppositeName != null) {
                property.setOpposite(oppositeName);
            }
            if ((targetDef = (Class)this.classQualifiedNameMap.get(this.getOpenAttributeValue(datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox"), (OpenAttrs)element))) == null) throw new IllegalStateException("could not find target class from, " + datatypeQName);
            ClassRef targetClassRef = new ClassRef();
            targetClassRef.setName(targetDef.getName());
            targetClassRef.setUri(targetDef.getUri());
            property.setType((TypeRef)targetClassRef);
            property.setContainment(Boolean.valueOf(true));
        } else {
            QName datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox");
            DataTypeRef dataTypeRef = new DataTypeRef();
            dataTypeRef.setName(this.getOpenAttributeValue(datatypeQName, (OpenAttrs)element));
            dataTypeRef.setUri(PlasmaRuntime.getInstance().getSDODataTypesNamespace().getUri());
            property.setType((TypeRef)dataTypeRef);
        }
        QName readonlyQName = new QName("commonj.sdo/xml", "readOnly", "sdox");
        Boolean isReadonly = new Boolean(this.getOpenAttributeValue(readonlyQName, (OpenAttrs)element));
        property.setReadOnly(isReadonly);
        if (sequenceNum <= -1) return property;
        Sort seq = new Sort();
        seq.setKey(String.valueOf(sequenceNum));
        property.setSort(seq);
        return property;
    }

    private Property createDerivedPropertyOpposite(Class clss, Property sourceProperty) {
        Property targetProperty = new Property();
        targetProperty.setId(UUID.randomUUID().toString());
        targetProperty.setName(sourceProperty.getOpposite());
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, "private derived opposite for, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        targetProperty.getDocumentations().add(documentation);
        targetProperty.setVisibility(VisibilityType.PRIVATE);
        targetProperty.setNullable(true);
        targetProperty.setMany(true);
        targetProperty.setDerived(Boolean.valueOf(true));
        targetProperty.setContainment(Boolean.valueOf(false));
        targetProperty.setOpposite(sourceProperty.getName());
        ClassRef targetClassRef = new ClassRef();
        targetClassRef.setName(clss.getName());
        targetClassRef.setUri(clss.getUri());
        targetProperty.setType((TypeRef)targetClassRef);
        return targetProperty;
    }

    private Property buildDatatypeProperty(ComplexType complexType, Attribute attribute) {
        QName typeQName;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        Alias alias = new Alias();
        property.setAlias(alias);
        alias.setLocalName(attribute.getName());
        QName nameQName = new QName("commonj.sdo/xml", "name", "sdox");
        String name = this.getOpenAttributeValue(nameQName, (OpenAttrs)attribute);
        property.setName(name);
        QName aliasQName = new QName("commonj.sdo/xml", "aliasName", "sdox");
        String physicalNameAlias = this.getOpenAttributeValue(aliasQName, (OpenAttrs)attribute);
        alias.setPhysicalName(physicalNameAlias);
        XmlProperty xmlProp = new XmlProperty();
        xmlProp.setNodeType(XmlNodeType.ATTRIBUTE);
        property.setXmlProperty(xmlProp);
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        body.setValue(this.getDocumentationContent((Annotated)attribute));
        documentation.setBody(body);
        property.getDocumentations().add(documentation);
        property.setVisibility(VisibilityType.PUBLIC);
        if ("required".equals(attribute.getUse())) {
            property.setNullable(false);
        } else {
            property.setNullable(true);
        }
        QName manyQName = new QName("commonj.sdo/xml", "many", "sdox");
        Boolean many = new Boolean(this.getOpenAttributeValue(manyQName, (OpenAttrs)attribute));
        if (many.booleanValue()) {
            property.setMany(true);
        } else {
            property.setMany(false);
        }
        QName datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox");
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(this.getOpenAttributeValue(datatypeQName, (OpenAttrs)attribute));
        dataTypeRef.setUri(PlasmaRuntime.getInstance().getSDODataTypesNamespace().getUri());
        property.setType((TypeRef)dataTypeRef);
        QName keyQName = new QName("commonj.sdo/xml", "key", "sdox");
        Boolean isKey = new Boolean(this.findOpenAttributeValue(keyQName, (OpenAttrs)attribute));
        if (isKey.booleanValue()) {
            QName keyTypeQName = new QName("commonj.sdo/xml", "keyType", "sdox");
            String keyType = this.findOpenAttributeValue(keyTypeQName, (OpenAttrs)attribute);
            property.setVisibility(VisibilityType.PRIVATE);
            Key key = new Key();
            key.setType(KeyType.valueOf((String)keyType.toUpperCase()));
            property.setKey(key);
        }
        if ((typeQName = attribute.getType()) != null) {
            if (typeQName.getPrefix() == null || this.appNamespaceQName != null && typeQName.getPrefix().equals(this.appNamespaceQName.getPrefix())) {
                SimpleType simpleType = (SimpleType)this.simpleTypeMap.get(typeQName.getLocalPart());
                EnumerationConstraint constraint = new EnumerationConstraint();
                EnumerationRef enumRef = new EnumerationRef();
                enumRef.setName(simpleType.getName());
                enumRef.setUri(this.destNamespaceURI);
                constraint.setValue(enumRef);
                property.setEnumerationConstraint(constraint);
            }
        } else {
            LocalSimpleType lst = attribute.getSimpleType();
            Restriction rest = lst.getRestriction();
            ValueConstraint constraint = this.constraintAssembler.buildValueConstraint(rest);
            property.setValueConstraint(constraint);
        }
        return property;
    }

    private JAXBElement<Facet> findFacet(String name, List<Object> list) {
        for (Object obj : list) {
            JAXBElement facet;
            if (!(obj instanceof JAXBElement) || !(facet = (JAXBElement)obj).getName().getLocalPart().equals(name)) continue;
            return facet;
        }
        return null;
    }
}

