/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.dsl;

import commonj.sdo.Type;
import java.util.List;
import org.plasma.query.DataProperty;
import org.plasma.query.Expression;
import org.plasma.query.From;
import org.plasma.query.GroupBy;
import org.plasma.query.Having;
import org.plasma.query.Join;
import org.plasma.query.OrderBy;
import org.plasma.query.Select;
import org.plasma.query.Where;
import org.plasma.query.Wildcard;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.dsl.DomainQuery;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.WildcardNode;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Clause;
import org.plasma.query.model.Entity;
import org.plasma.query.model.Function;
import org.plasma.query.model.FunctionName;
import org.plasma.query.model.Path;
import org.plasma.query.model.Property;
import org.plasma.query.model.Query;

public class DomainRoot
extends PathNode
implements DomainQuery {
    private Query query;

    protected DomainRoot(Type type) {
        super(type);
        this.query = new Query();
        org.plasma.query.model.From from = new org.plasma.query.model.From();
        from.setEntity(new Entity(this.type.getName(), this.type.getURI()));
        this.query.getClauses().add(new Clause(from));
        this.isRoot = true;
    }

    protected DomainRoot(PathNode source, String sourceProperty) {
        super(source, sourceProperty);
    }

    protected DomainRoot(PathNode source, String sourceProperty, Expression expr) {
        super(source, sourceProperty, expr);
    }

    @Override
    public Query getModel() {
        return this.query;
    }

    @Override
    public DomainQuery where(Expression expr) {
        org.plasma.query.model.Where where = this.query.findWhereClause();
        org.plasma.query.model.Expression root = (org.plasma.query.model.Expression)expr;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (where == null) {
            where = new org.plasma.query.model.Where();
            this.query.getClauses().add(new Clause(where));
            where.addExpression(root);
        } else {
            where.addExpression(org.plasma.query.model.Expression.and());
            where.addExpression(root);
        }
        return this;
    }

    @Override
    public DomainQuery select(DataProperty property) {
        org.plasma.query.model.Select select = this.getOrInitSelect();
        DataNode domainProperty = (DataNode)property;
        AbstractProperty prop = domainProperty.getModel();
        select.addProperty(prop);
        return this;
    }

    @Override
    public DomainQuery select(FunctionName func, DataProperty property) {
        org.plasma.query.model.Select select = this.getOrInitSelect();
        DataNode domainProperty = (DataNode)property;
        Property prop = (Property)domainProperty.getModel();
        prop.getFunctions().add(new Function(func));
        select.addProperty(prop);
        return this;
    }

    @Override
    public DomainQuery select(Wildcard property) {
        org.plasma.query.model.Select select = this.getOrInitSelect();
        WildcardNode domainProperty = (WildcardNode)property;
        AbstractProperty prop = domainProperty.getModel();
        select.addProperty(prop);
        return this;
    }

    private org.plasma.query.model.Select getOrInitSelect() {
        org.plasma.query.model.Select select = null;
        for (int i = 0; i < this.query.getClauses().size() && (select = this.query.getClauses().get(i).getSelect()) == null; ++i) {
        }
        if (select == null) {
            select = new org.plasma.query.model.Select();
            this.query.getClauses().add(new Clause(select));
        }
        return select;
    }

    @Override
    public DomainQuery orderBy(DataProperty property) {
        org.plasma.query.model.OrderBy orderBy = this.query.findOrderByClause();
        if (orderBy == null) {
            orderBy = new org.plasma.query.model.OrderBy();
            this.query.getClauses().add(new Clause(orderBy));
        }
        DataNode domainProperty = (DataNode)property;
        String[] path = domainProperty.getPath();
        AbstractProperty prop = domainProperty.getModel();
        orderBy.addProperty((Property)prop);
        return this;
    }

    @Override
    public DomainQuery groupBy(DataProperty property) {
        org.plasma.query.model.GroupBy groupBy = this.query.findGroupByClause();
        if (groupBy == null) {
            groupBy = new org.plasma.query.model.GroupBy();
            this.query.getClauses().add(new Clause(groupBy));
        }
        DataNode domainProperty = (DataNode)property;
        String[] path = domainProperty.getPath();
        Property prop = null;
        prop = path != null && path.length > 0 ? Property.forName(domainProperty.getName(), new Path(path)) : Property.forName(domainProperty.getName());
        groupBy.addProperty(prop);
        return this;
    }

    @Override
    public DomainQuery having(Expression expr) {
        org.plasma.query.model.Having having = this.query.findHavingClause();
        org.plasma.query.model.Expression root = (org.plasma.query.model.Expression)expr;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (having == null) {
            having = new org.plasma.query.model.Having();
            this.query.getClauses().add(new Clause(having));
            having.addExpression(root);
        } else {
            having.addExpression(org.plasma.query.model.Expression.and());
            having.addExpression(root);
        }
        return this;
    }

    @Override
    public From getFromClause() {
        return this.query.getFromClause();
    }

    @Override
    public void clearOrderByClause() {
        this.query.clearOrderByClause();
    }

    @Override
    public GroupBy findGroupByClause() {
        return this.query.findGroupByClause();
    }

    @Override
    public Having findHavingClause() {
        return this.query.findHavingClause();
    }

    @Override
    public OrderBy findOrderByClause() {
        return this.query.findOrderByClause();
    }

    @Override
    public Where findWhereClause() {
        return this.query.findWhereClause();
    }

    @Override
    public Integer getEndRange() {
        return this.query.getEndRange();
    }

    @Override
    public String getName() {
        return this.query.getName();
    }

    @Override
    public Select getSelectClause() {
        return this.query.getSelectClause();
    }

    @Override
    public Integer getStartRange() {
        return this.query.getStartRange();
    }

    @Override
    public Where getWhereClause() {
        return this.query.getWhereClause();
    }

    @Override
    public void setEndRange(Integer value) {
        this.query.setEndRange(value);
    }

    @Override
    public void setName(String value) {
        this.query.setName(value);
    }

    @Override
    public void setStartRange(Integer value) {
        this.query.setStartRange(value);
    }

    @Override
    public void addConfigurationProperty(String name, String value) {
        this.query.addConfigurationProperty(name, value);
    }

    @Override
    public String getConfigurationProperty(String name) {
        return this.query.getConfigurationProperty(name);
    }

    @Override
    public List<Join> findJoinClauses() {
        return this.query.findJoinClauses();
    }
}

