/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.plasma.query.visitor.QueryVisitor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Entity")
@XmlRootElement(name="Entity")
public class Entity
implements Comparable<Entity> {
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute
    protected String namespaceURI;
    @XmlAttribute(name="alias")
    protected String alias;
    protected transient String physicalName;
    protected transient byte[] physicalNameBytes;
    private transient String qualifiedName;
    protected transient String uniqueId;

    public Entity() {
    }

    public Entity(String name, String namespaceURI) {
        this();
        this.setName(name);
        this.setNamespaceURI(namespaceURI);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String value) {
        this.physicalName = value;
    }

    public byte[] getPhysicalNameBytes() {
        return this.physicalNameBytes;
    }

    public void setPhysicalNameBytes(byte[] value) {
        this.physicalNameBytes = value;
    }

    public void setNamespaceURI(String value) {
        this.namespaceURI = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    public static String qualifiedNameFor(String namespaceURI, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append(namespaceURI);
        buf.append("#");
        buf.append(name);
        return buf.toString();
    }

    public static String qualifiedNameFor(String namespaceURI, String name, String alias) {
        StringBuilder buf = new StringBuilder();
        buf.append(namespaceURI);
        buf.append("#");
        buf.append(name);
        buf.append(" (");
        buf.append(alias);
        buf.append("}");
        return buf.toString();
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.namespaceURI != null && this.alias != null ? Entity.qualifiedNameFor(this.namespaceURI, this.name, this.alias) : Entity.qualifiedNameFor(this.namespaceURI, this.name);
        }
        return this.qualifiedName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getQualifiedName() == null ? 0 : this.getQualifiedName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return !(this.getQualifiedName() == null ? other.getQualifiedName() != null : !this.getQualifiedName().equals(other.getQualifiedName()));
    }

    @Override
    public int compareTo(Entity o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }
}

