/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.plasma.query.Join;
import org.plasma.query.QueryException;
import org.plasma.query.model.Clause;
import org.plasma.query.model.ConfigurationProperty;
import org.plasma.query.model.Delete;
import org.plasma.query.model.From;
import org.plasma.query.model.GroupBy;
import org.plasma.query.model.Having;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Select;
import org.plasma.query.model.Update;
import org.plasma.query.model.Where;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Query", propOrder={"clauses", "startRange", "endRange", "configurationProperties"})
@XmlRootElement(name="Query")
public class Query
implements org.plasma.query.Query {
    @XmlElement(name="Clause", required=true)
    protected List<Clause> clauses;
    @XmlElement(namespace="", defaultValue="0")
    protected Integer startRange;
    @XmlElement(namespace="", defaultValue="0")
    protected Integer endRange;
    @XmlElement(name="ConfigurationProperty", required=true)
    protected List<ConfigurationProperty> configurationProperties;
    @XmlAttribute
    protected String name;

    public Query() {
    }

    public Query(Select select, From from) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
    }

    public Query(Select select, From from, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, Where where) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
    }

    public Query(Select select, From from, Where where, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, OrderBy orderBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(orderBy));
    }

    public Query(Select select, From from, OrderBy orderBy, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(orderBy));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, Where where, OrderBy orderBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(orderBy));
    }

    public Query(Select select, From from, Where where, OrderBy orderBy, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(orderBy));
        this.getClauses().add(new Clause(groupBy));
    }

    @Override
    public Query getModel() {
        return this;
    }

    public List<Clause> getClauses() {
        if (this.clauses == null) {
            this.clauses = new ArrayList<Clause>();
        }
        return this.clauses;
    }

    @Override
    public Integer getStartRange() {
        if (this.startRange != null) {
            return this.startRange;
        }
        return null;
    }

    @Override
    public void setStartRange(Integer value) {
        this.startRange = value;
    }

    @Override
    public Integer getEndRange() {
        if (this.endRange != null) {
            return this.endRange;
        }
        return null;
    }

    @Override
    public void setEndRange(Integer value) {
        this.endRange = value;
    }

    public List<ConfigurationProperty> getConfigurationProperties() {
        if (this.configurationProperties == null) {
            this.configurationProperties = new ArrayList<ConfigurationProperty>();
        }
        return this.configurationProperties;
    }

    public void addConfigurationProperty(ConfigurationProperty prop) {
        this.getConfigurationProperties().add(prop);
    }

    @Override
    public void addConfigurationProperty(String name, String value) {
        ConfigurationProperty prop = new ConfigurationProperty();
        prop.setName(name);
        prop.setValue(value);
        this.addConfigurationProperty(prop);
    }

    @Override
    public String getConfigurationProperty(String name) {
        for (ConfigurationProperty prop : this.getConfigurationProperties()) {
            if (!prop.getName().equals(name)) continue;
            return prop.getValue();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (int i = 0; i < this.getClauses().size(); ++i) {
                this.getClauses().get(i).accept(visitor);
            }
        }
        visitor.end(this);
    }

    @Override
    public Select getSelectClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Select select = this.getClauses().get(i).getSelect();
            if (select == null) continue;
            return select;
        }
        throw new QueryException("could not get Select clause");
    }

    public Update getUpdateClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Update update = this.getClauses().get(i).getUpdate();
            if (update == null) continue;
            return update;
        }
        throw new QueryException("could not get Update clause");
    }

    public Delete getDeleteClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Delete delete = this.getClauses().get(i).getDelete();
            if (delete == null) continue;
            return delete;
        }
        throw new QueryException("could not get Delete clause");
    }

    @Override
    public From getFromClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            From from = this.getClauses().get(i).getFrom();
            if (from == null) continue;
            return from;
        }
        throw new QueryException("could not get From clause");
    }

    @Override
    public Where getWhereClause() {
        Where result = this.findWhereClause();
        if (result == null) {
            throw new QueryException("could not get Where clause");
        }
        return result;
    }

    @Override
    public Where findWhereClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Where where = this.getClauses().get(i).getWhere();
            if (where == null) continue;
            return where;
        }
        return null;
    }

    @Override
    public void clearOrderByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            OrderBy orderBy = this.getClauses().get(i).getOrderBy();
            if (orderBy == null) continue;
            this.getClauses().remove(this.getClauses().get(i));
        }
    }

    @Override
    public OrderBy findOrderByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            OrderBy orderBy = this.getClauses().get(i).getOrderBy();
            if (orderBy == null) continue;
            return orderBy;
        }
        return null;
    }

    @Override
    public GroupBy findGroupByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            GroupBy groupBy = this.getClauses().get(i).getGroupBy();
            if (groupBy == null) continue;
            return groupBy;
        }
        return null;
    }

    @Override
    public Having findHavingClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Having having = this.getClauses().get(i).getHaving();
            if (having == null) continue;
            return having;
        }
        return null;
    }

    @Override
    public List<Join> findJoinClauses() {
        ArrayList<Join> result = null;
        for (int i = 0; i < this.getClauses().size(); ++i) {
            org.plasma.query.model.Join join = this.getClauses().get(i).getJoin();
            if (join == null) continue;
            if (result == null) {
                result = new ArrayList<Join>();
            }
            result.add((Join)((Object)join));
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }
}

