/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.HashMap;
import java.util.Map;
import org.plasma.query.Operator;
import org.plasma.query.QueryException;
import org.plasma.query.model.RelationalOperatorName;
import org.plasma.query.visitor.QueryVisitor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RelationalOperator", propOrder={"value"})
@XmlRootElement(name="RelationalOperator")
public class RelationalOperator
implements Operator {
    private static Map<String, RelationalOperatorName> operMap = new HashMap<String, RelationalOperatorName>();
    @XmlValue
    protected RelationalOperatorName value;

    public RelationalOperator() {
    }

    public RelationalOperator(String content) {
        this();
        this.setValue(RelationalOperatorName.valueOf(content));
    }

    public RelationalOperator(RelationalOperatorName content) {
        this();
        this.setValue(content);
    }

    public static RelationalOperator valueOf(String value) {
        RelationalOperatorName oper = operMap.get(value);
        if (oper != null) {
            return new RelationalOperator(oper);
        }
        throw new QueryException("invalid operator '" + value + "'");
    }

    public RelationalOperatorName getValue() {
        return this.value;
    }

    public void setValue(RelationalOperatorName value) {
        this.value = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    static {
        operMap.put("=", RelationalOperatorName.EQUALS);
        operMap.put("!=", RelationalOperatorName.NOT_EQUALS);
        operMap.put(">", RelationalOperatorName.GREATER_THAN);
        operMap.put(">=", RelationalOperatorName.GREATER_THAN_EQUALS);
        operMap.put("<", RelationalOperatorName.LESS_THAN);
        operMap.put("<=", RelationalOperatorName.LESS_THAN_EQUALS);
    }
}

