/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;
import org.plasma.query.DataProperty;
import org.plasma.query.QueryException;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Property;
import org.plasma.query.model.TextContent;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.query.xpath.QueryPredicateVisitor;
import org.plasma.query.xpath.QueryXPath;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Select", propOrder={"properties", "textContent"})
@XmlRootElement(name="Select")
public class Select
implements org.plasma.query.Select {
    private static Log log = LogFactory.getFactory().getInstance(Select.class);
    @XmlElement(name="TextContent")
    protected TextContent textContent;
    @XmlElementRef
    protected List<AbstractProperty> properties;

    public Select() {
    }

    public Select(Property p1) {
        this();
        this.getProperties().add(p1);
    }

    public Select(Property p1, Property p2) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
    }

    public Select(Property p1, Property p2, Property p3) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
        this.getProperties().add(p3);
    }

    public Select(Property p1, Property p2, Property p3, Property p4) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
        this.getProperties().add(p3);
        this.getProperties().add(p4);
    }

    public Select(Property[] properties) {
        this();
        for (int i = 0; i < properties.length; ++i) {
            this.getProperties().add(properties[i]);
        }
    }

    public Select(WildcardProperty p1) {
        this();
        this.getProperties().add(p1);
    }

    public Select(WildcardProperty p1, WildcardProperty p2) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
    }

    public Select(WildcardProperty p1, WildcardProperty p2, WildcardProperty p3) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
        this.getProperties().add(p3);
    }

    public Select(WildcardProperty p1, WildcardProperty p2, WildcardProperty p3, WildcardProperty p4) {
        this();
        this.getProperties().add(p1);
        this.getProperties().add(p2);
        this.getProperties().add(p3);
        this.getProperties().add(p4);
    }

    public Select(WildcardProperty[] properties) {
        this();
        for (int i = 0; i < properties.length; ++i) {
            this.getProperties().add(properties[i]);
        }
    }

    public Select(AbstractProperty[] properties) {
        this();
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i] instanceof Property) {
                this.getProperties().add((Property)properties[i]);
                continue;
            }
            if (properties[i] instanceof WildcardProperty) {
                this.getProperties().add((WildcardProperty)properties[i]);
                continue;
            }
            throw new QueryException("expected instance of Property or WildcardProperty");
        }
    }

    public Select(String expression) {
        this(new String[]{expression});
    }

    public Select(String[] expressions) {
        this();
        if (expressions == null || expressions.length == 0) {
            throw new IllegalArgumentException("argument 'content' is null or zero length");
        }
        try {
            for (int i = 0; i < expressions.length; ++i) {
                Path path = null;
                PathNode currPathNode = null;
                QueryXPath xpath = new QueryXPath(expressions[i]);
                List<Step> steps = xpath.getSteps();
                for (int j = 0; j < steps.size(); ++j) {
                    Step step = steps.get(j);
                    if (!(step instanceof NameStep)) {
                        throw new QueryException("cannot determine traversal path - expected named path step not, " + step.getClass().getName());
                    }
                    NameStep nameStep = (NameStep)step;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("step: " + nameStep.getLocalName()));
                    }
                    if (j + 1 == steps.size()) {
                        if (path != null) {
                            if (!"*".equals(nameStep.getLocalName())) {
                                this.getProperties().add(new Property(nameStep.getLocalName(), path));
                                continue;
                            }
                            this.getProperties().add(new WildcardProperty(path));
                            continue;
                        }
                        if (!"*".equals(nameStep.getLocalName())) {
                            this.getProperties().add(new Property(nameStep.getLocalName()));
                            continue;
                        }
                        this.getProperties().add(new WildcardProperty());
                        continue;
                    }
                    if (path == null) {
                        path = new Path();
                    }
                    currPathNode = new PathNode(nameStep.getLocalName());
                    path.addPathNode(currPathNode);
                    if (step.getPredicates() == null || step.getPredicates().size() <= 0) continue;
                    QueryPredicateVisitor visitor = new QueryPredicateVisitor();
                    xpath.acceptBreadthFirst(step, visitor);
                    currPathNode.setWhere(visitor.getResult());
                }
            }
        }
        catch (JaxenException e) {
            throw new QueryException(e);
        }
    }

    public List<AbstractProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<AbstractProperty>();
        }
        return this.properties;
    }

    public void addProperty(AbstractProperty property) {
        this.getProperties().add(property);
    }

    public void addAll(AbstractProperty[] properties) {
        if (properties != null) {
            for (AbstractProperty prop : properties) {
                this.getProperties().add(prop);
            }
        }
    }

    public TextContent getTextContent() {
        return this.textContent;
    }

    public void setTextContent(TextContent value) {
        this.textContent = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (int i = 0; i < this.getProperties().size(); ++i) {
                this.getProperties().get(i).accept(visitor);
            }
        }
        visitor.end(this);
    }

    public DataProperty[] getPropertiesDeep() {
        final ArrayList list = new ArrayList(12);
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            @Override
            public void start(Property property) {
                list.add(property);
                super.start(property);
            }
        };
        this.accept(visitor);
        DataProperty[] results = new Property[list.size()];
        list.toArray(results);
        return results;
    }

    public boolean hasDistinct(DataProperty[] props) {
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].isDistinct()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDistinctProperties() {
        DataProperty[] props = this.getPropertiesDeep();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].isDistinct()) continue;
            return true;
        }
        return false;
    }
}

