/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.plasma.query.model.Entity;
import org.plasma.query.model.Expression;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Update", propOrder={"entity", "expressions"})
@XmlRootElement(name="Update")
public class Update {
    @XmlElement(name="Entity", required=true)
    protected Entity entity;
    @XmlElement(name="Expression", required=true)
    protected List<Expression> expressions;

    public Update() {
    }

    public Update(Expression expr) {
        this();
        this.getExpressions().add(expr);
    }

    public Update(Expression[] exprs) {
        this();
        this.getExpressions().add(new Expression(exprs));
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity value) {
        this.entity = value;
    }

    public void addExpression(Expression e) {
        this.getExpressions().add(e);
    }

    public List<Expression> getExpressions() {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        return this.expressions;
    }

    public int getExpressionCount() {
        return this.getExpressions().size();
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (int i = 0; i < this.getExpressions().size(); ++i) {
                this.getExpressions().get(i).accept(visitor);
            }
        }
        visitor.end(this);
    }
}

