/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.xpath;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.RelationalExpr;
import org.plasma.query.model.Expression;
import org.plasma.query.model.RelationalOperator;
import org.plasma.query.model.Where;
import org.plasma.sdo.xpath.XPathExprVisitor;

public class QueryPredicateVisitor
implements XPathExprVisitor {
    private static Log log = LogFactory.getFactory().getInstance(QueryPredicateVisitor.class);
    private Where result;
    private Map<Expr, Expression> map = new HashMap<Expr, Expression>();

    @Override
    public void visit(Expr target, Expr source, int level) {
        if (target instanceof BinaryExpr) {
            BinaryExpr binExpr = (BinaryExpr)target;
            Expression left = this.map.get(binExpr.getLHS());
            Expression right = this.map.get(binExpr.getRHS());
            if (left == null && right == null) {
                if (binExpr instanceof RelationalExpr) {
                    RelationalExpr expr = (RelationalExpr)target;
                    Expression qexpr = Expression.valueOf(expr);
                    this.map.put((Expr)expr, qexpr);
                } else if (binExpr instanceof LogicalExpr) {
                    LogicalExpr expr = (LogicalExpr)target;
                    Expression qexpr = Expression.valueOf(expr);
                    this.map.put((Expr)expr, qexpr);
                } else if (binExpr instanceof EqualityExpr) {
                    EqualityExpr expr = (EqualityExpr)target;
                    Expression qexpr = Expression.valueOf(expr);
                    this.map.put((Expr)expr, qexpr);
                }
            } else {
                Expression qexpr = new Expression(left, RelationalOperator.valueOf(binExpr.getOperator()), right);
                this.map.put((Expr)binExpr, qexpr);
            }
        }
        if (source == null) {
            this.result = new Where();
            Expression qexpr = this.map.get(target);
            this.result.addExpression(qexpr);
        }
    }

    public Where getResult() {
        return this.result;
    }
}

