/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.xpath;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.Navigator;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.expr.XPathExpr;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.XPathSyntaxException;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.plasma.query.xpath.QueryPathNavigator;
import org.plasma.sdo.xpath.DefaultXPath;
import org.plasma.sdo.xpath.XPathExprVisitor;

public class QueryXPath
extends DefaultXPath {
    private static Log log = LogFactory.getFactory().getInstance(QueryXPath.class);
    private static final long serialVersionUID = 1L;
    private final XPathExpr queryXpath;

    public QueryXPath(String xpathExpr, QueryPathNavigator navigator) throws JaxenException {
        super(xpathExpr, (Navigator)navigator);
        navigator.setXpath(this);
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            JaxenHandler handler = new JaxenHandler();
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(xpathExpr);
            this.queryXpath = handler.getXPathExpr();
        }
        catch (XPathSyntaxException e) {
            throw new org.jaxen.XPathSyntaxException(e);
        }
        catch (SAXPathException e) {
            throw new JaxenException((Throwable)e);
        }
    }

    public QueryXPath(String xpathExpr) throws JaxenException {
        super(xpathExpr);
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            JaxenHandler handler = new JaxenHandler();
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(xpathExpr);
            this.queryXpath = handler.getXPathExpr();
        }
        catch (XPathSyntaxException e) {
            throw new org.jaxen.XPathSyntaxException(e);
        }
        catch (SAXPathException e) {
            throw new JaxenException((Throwable)e);
        }
    }

    public List<Step> getSteps() throws JaxenException {
        LocationPath path = (LocationPath)this.queryXpath.getRootExpr();
        return path.getSteps();
    }

    public void accept(Step step, XPathExprVisitor visitor) {
        List predicates = step.getPredicates();
        if (predicates != null) {
            for (Object pred : predicates) {
                Predicate predicate = (Predicate)pred;
                Expr ex = predicate.getExpr();
                this.accept(visitor, ex, null, true, 0);
            }
        }
    }

    public void acceptBreadthFirst(Step step, XPathExprVisitor visitor) {
        List predicates = step.getPredicates();
        if (predicates != null) {
            for (Object pred : predicates) {
                Predicate predicate = (Predicate)pred;
                Expr ex = predicate.getExpr();
                this.accept(visitor, ex, null, false, 0);
            }
        }
    }

    private void accept(XPathExprVisitor visitor, Expr target, Expr source, boolean depthFirst, int level) {
        if (depthFirst) {
            visitor.visit(target, source, level);
        }
        if (target instanceof BinaryExpr) {
            BinaryExpr expr = (BinaryExpr)target;
            this.accept(visitor, expr.getLHS(), target, depthFirst, level + 1);
            this.accept(visitor, expr.getRHS(), target, depthFirst, level + 1);
        } else if (target instanceof FilterExpr) {
            FilterExpr expr = (FilterExpr)target;
            this.accept(visitor, expr.getExpr(), target, depthFirst, level + 1);
        } else if (target instanceof PathExpr) {
            PathExpr expr = (PathExpr)target;
            this.accept(visitor, expr.getFilterExpr(), target, depthFirst, level + 1);
        } else if (target instanceof UnaryExpr) {
            UnaryExpr expr = (UnaryExpr)target;
            this.accept(visitor, expr.getExpr(), source, depthFirst, level + 1);
        }
        if (!depthFirst) {
            visitor.visit(target, source, level);
        }
    }
}

