/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo;

import org.plasma.sdo.PlasmaEdge;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.core.CoreEdge;
import org.plasma.sdo.core.TraversalDirection;

public class PlasmaDataLink
extends CoreEdge
implements PlasmaEdge {
    protected PlasmaNode left;
    protected PlasmaNode right;

    private PlasmaDataLink() {
    }

    public PlasmaDataLink(PlasmaNode left, PlasmaNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean canTraverse(PlasmaNode fromNode) {
        return this.getDirection() == TraversalDirection.RIGHT && this.left.equals(fromNode);
    }

    @Override
    public PlasmaNode getOpposite(PlasmaNode fromNode) {
        if (this.left.equals(fromNode)) {
            return this.right;
        }
        if (this.right.equals(fromNode)) {
            return this.left;
        }
        throw new IllegalArgumentException("given node '" + fromNode.getUUIDAsString() + "' not found");
    }

    @Override
    public PlasmaNode getLeft() {
        return this.left;
    }

    @Override
    public void setLeft(PlasmaNode left) {
        this.left = left;
    }

    @Override
    public PlasmaNode getRight() {
        return this.right;
    }

    @Override
    public void setRight(PlasmaNode right) {
        this.right = right;
    }
}

