/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaType;

public abstract class SimpleCollector {
    private static Log log = LogFactory.getFactory().getInstance(SimpleCollector.class);
    private List<PlasmaDataObject> result = new ArrayList<PlasmaDataObject>();
    private HashSet<PlasmaDataObject> resultMap = new HashSet();
    protected PlasmaChangeSummary changeSummary;
    protected Map<String, Boolean> isDescendantResultsMap = new HashMap<String, Boolean>();

    public List<PlasmaDataObject> getResult() {
        return this.result;
    }

    protected DataObject[] toArray() {
        DataObject[] resultArray = new DataObject[this.result.size()];
        this.result.toArray(resultArray);
        return resultArray;
    }

    protected boolean contains(DataObject dataObject) {
        return this.resultMap.contains(dataObject);
    }

    protected void add(PlasmaDataObject dataObject) {
        this.result.add(dataObject);
        this.resultMap.add(dataObject);
    }

    protected void add(int index, PlasmaDataObject dataObject) {
        this.result.add(index, dataObject);
        this.resultMap.add(dataObject);
    }

    protected boolean isRelation(DataObject target, DataObject source, AssociationPath relationPath) {
        return ((PlasmaType)target.getType()).isRelation((PlasmaType)source.getType(), relationPath);
    }

    protected boolean hasChildLink(DataObject target, DataObject source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing " + target.toString() + "/" + source.toString()));
        }
        for (Property property : target.getType().getProperties()) {
            Object value;
            if (property.getType().isDataType() || property.isMany() || (value = target.get(property)) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking property " + target.getType().getName() + "." + property.getName()));
            }
            if (!this.isLinked(source, value)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("found child data link " + target.getType().getName() + "." + property.getName() + "->" + source.getType().getName()));
            }
            return true;
        }
        return false;
    }

    protected boolean isLinked(DataObject other, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (DataObject dataObject : list) {
                PlasmaNode dataNode = (PlasmaNode)dataObject;
                if (!dataNode.getUUIDAsString().equals(((PlasmaNode)other).getUUIDAsString())) continue;
                return true;
            }
        } else {
            DataObject dataObject = (DataObject)value;
            PlasmaNode dataNode = (PlasmaNode)dataObject;
            if (dataNode.getUUIDAsString().equals(((PlasmaNode)other).getUUIDAsString())) {
                return true;
            }
        }
        return false;
    }
}

