/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaSetting;
import org.plasma.sdo.core.NullValue;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class CoreSetting
implements PlasmaSetting {
    private static Log log = LogFactory.getLog(CoreSetting.class);
    private DataObject source;
    private transient Property property;
    private String propertyName;
    private String propertyTypeName;
    private String propertyTypeUri;
    private Object value;
    private String valuePath;
    private boolean isSet;
    private long createdMillis = System.currentTimeMillis();

    private CoreSetting() {
    }

    public CoreSetting(DataObject source, Property property, Object value) {
        this.source = source;
        this.property = property;
        this.value = value;
        this.isSet = source.isSet(property);
        if (!property.getType().isDataType()) {
            if (this.value instanceof List) {
                List list = (List)this.value;
                StringBuffer buf = new StringBuffer();
                buf.append("list[");
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        DataObject dataObject = (DataObject)list.get(i);
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(((PlasmaNode)dataObject).getUUIDAsString());
                    }
                }
                buf.append("]");
                this.valuePath = buf.toString();
            } else if (this.value != null) {
                if (this.value instanceof PlasmaNode) {
                    this.valuePath = ((PlasmaNode)this.value).getUUIDAsString();
                } else if (!(this.value instanceof NullValue)) {
                    log.error((Object)"expected instance of PlasmaNode or NullValue");
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.propertyName = this.property.getName();
        this.propertyTypeName = this.property.getContainingType().getName();
        this.propertyTypeUri = this.property.getContainingType().getURI();
        this.property = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Type propertyType = PlasmaTypeHelper.INSTANCE.getType(this.propertyTypeUri, this.propertyTypeName);
        this.property = propertyType.getProperty(this.propertyName);
        this.propertyName = null;
        this.propertyTypeName = null;
        this.propertyTypeUri = null;
    }

    public Property getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String getValuePath() {
        return this.valuePath;
    }

    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public long getCreatedMillis() {
        return this.createdMillis;
    }
}

