/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core.collector;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.List;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.core.collector.LinkedNode;

public class SourceNodeCollector
implements PlasmaDataGraphVisitor {
    private List<LinkedNode> result = new ArrayList<LinkedNode>();
    private DataObject target;

    public SourceNodeCollector(DataObject target) {
        this.target = target;
    }

    @Override
    public void visit(DataObject target, DataObject source, String sourcePropertyName, int level) {
        PlasmaDataObject targetObject = (PlasmaDataObject)target;
        PlasmaDataObject sourceObject = (PlasmaDataObject)source;
        PlasmaProperty sourceProperty = null;
        if (sourceObject != null) {
            sourceProperty = (PlasmaProperty)source.getType().getProperty(sourcePropertyName);
        }
        if (targetObject.equals(this.target)) {
            return;
        }
        for (Property prop : target.getType().getProperties()) {
            if (prop.getType().isDataType() || !targetObject.isSet(prop)) continue;
            if (prop.isMany()) {
                List list = targetObject.getList(prop);
                for (DataObject dataObject : list) {
                    if (!dataObject.equals(this.target)) continue;
                    this.addNode(targetObject, sourceObject, sourceProperty, (PlasmaProperty)prop);
                }
                continue;
            }
            DataObject dataObject = targetObject.getDataObject(prop);
            if (!dataObject.equals(this.target)) continue;
            this.addNode(targetObject, sourceObject, sourceProperty, (PlasmaProperty)prop);
        }
    }

    private void addNode(PlasmaDataObject targetObject, PlasmaDataObject sourceObject, PlasmaProperty sourceProperty, PlasmaProperty targetProperty) {
        LinkedNode node = null;
        node = sourceObject == null ? new LinkedNode(targetObject, null, null) : new LinkedNode(targetObject, sourceObject, sourceProperty);
        node.setTargetProperty(targetProperty);
        this.result.add(node);
    }

    public List<LinkedNode> getResult() {
        return this.result;
    }
}

