/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreNode;
import org.plasma.sdo.helper.DataGraphCopyVisitor;
import org.plasma.sdo.helper.PlasmaDataFactory;

public class PlasmaCopyHelper
implements CopyHelper {
    public static volatile PlasmaCopyHelper INSTANCE = PlasmaCopyHelper.initializeInstance();

    private PlasmaCopyHelper() {
    }

    public static PlasmaCopyHelper instance() {
        if (INSTANCE == null) {
            PlasmaCopyHelper.initializeInstance();
        }
        return INSTANCE;
    }

    private static synchronized PlasmaCopyHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaCopyHelper();
        }
        return INSTANCE;
    }

    public DataObject copyShallow(DataObject dataObject) {
        CoreDataObject result = (CoreDataObject)PlasmaDataFactory.INSTANCE.create(dataObject.getType());
        this.copy((CoreDataObject)dataObject, result);
        return result;
    }

    public DataObject copyShallowAsReference(DataObject dataObject) {
        CoreDataObject source = (CoreDataObject)dataObject;
        CoreDataObject result = (CoreDataObject)PlasmaDataFactory.INSTANCE.create(source.getType());
        result.setValue("snapshotTimestamp", ((CoreNode)dataObject).getValue("snapshotTimestamp"));
        result.resetUUID(source.getUUID());
        this.copy(source, result);
        return result;
    }

    private void copy(CoreDataObject source, CoreDataObject result) {
        PlasmaType type = (PlasmaType)source.getType();
        Object value = null;
        for (String key : source.getValueObject().getKeys()) {
            Property property = type.findProperty(key);
            if (property != null) {
                value = source.get(property);
                if (value == null || !property.getType().isDataType()) continue;
                if (!property.isReadOnly()) {
                    result.set(property, value);
                    continue;
                }
                result.getValueObject().put(property.getName(), value);
                continue;
            }
            value = source.getValueObject().get(key);
            if (value == null) continue;
            result.getValueObject().put(key, value);
        }
    }

    public DataObject copy(DataObject dataObject) {
        DataGraphCopyVisitor visitor = new DataGraphCopyVisitor();
        ((PlasmaDataObject)dataObject).accept(visitor);
        return visitor.getResult();
    }

    public DataObject copyAsReference(DataObject dataObject) {
        DataGraphCopyVisitor visitor = new DataGraphCopyVisitor();
        visitor.setCopyUUIDs(true);
        ((PlasmaDataObject)dataObject).accept(visitor);
        return visitor.getResult();
    }

    public DataObject copy(DataObject dataObject, Type[] referenceTypes) {
        DataGraphCopyVisitor visitor = new DataGraphCopyVisitor(referenceTypes);
        ((PlasmaDataObject)dataObject).accept(visitor);
        return visitor.getResult();
    }
}

