/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.Type;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.adapter.ModelAdapter;
import org.plasma.provisioning.MetamodelAssembler;
import org.plasma.provisioning.MetamodelDataBinding;
import org.plasma.query.Query;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.xml.uml.MDModelAssembler;
import org.xml.sax.SAXException;

public class PlasmaQueryHelper {
    private static Log log = LogFactory.getLog(PlasmaQueryHelper.class);
    public static volatile PlasmaQueryHelper INSTANCE = PlasmaQueryHelper.initializeInstance();

    private PlasmaQueryHelper() {
    }

    private static synchronized PlasmaQueryHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaQueryHelper();
        }
        return INSTANCE;
    }

    public List<Type> define(String queryXML, String supplierUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling Query");
        }
        Query query = this.unmarshalQuery(queryXML);
        return this.define(query, null, "tns", supplierUri);
    }

    public List<Type> define(Reader queryReader, String targetNamespaceURI, String supplierUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling Query");
        }
        Query query = this.unmarshalQuery(queryReader);
        return this.define(query, targetNamespaceURI, "tns", supplierUri);
    }

    public List<Type> define(InputStream queryInputStream, String targetNamespaceURI, String supplierUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling schema");
        }
        Query query = this.unmarshalQuery(queryInputStream);
        return this.define(query, targetNamespaceURI, "tns", supplierUri);
    }

    public List<Type> define(Query query, String targetNamespaceURI, String targetNamespacePrefix, String supplierUri) {
        String outputLocation = ".";
        MetamodelAssembler stagingAssembler = new MetamodelAssembler(query, targetNamespaceURI, targetNamespacePrefix);
        Model stagingModel = stagingAssembler.getModel();
        if (log.isDebugEnabled()) {
            log.debug((Object)"provisioning UML/XMI model");
        }
        if (log.isDebugEnabled()) {
            this.writeStagingModel(stagingModel, outputLocation, this.getClass().getSimpleName() + "-" + query.getName() + "-model.xml");
        }
        ModelAdapter helper = new ModelAdapter(stagingModel);
        MDModelAssembler assembler = new MDModelAssembler(stagingModel, targetNamespaceURI, targetNamespacePrefix);
        String xmi = assembler.getContent();
        if (log.isDebugEnabled()) {
            File xmiDebugFile = null;
            try {
                xmiDebugFile = outputLocation != null ? new File(".", this.getClass().getSimpleName() + "-" + query.getName() + "-model.mdxml") : File.createTempFile(query.getName(), "mdxml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.debug((Object)("Writing UML/XMI to: " + xmiDebugFile.getAbsolutePath()));
            try {
                FileOutputStream os = new FileOutputStream(xmiDebugFile);
                assembler.getContent((OutputStream)os);
            }
            catch (FileNotFoundException os) {
                // empty catch block
            }
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(xmi.getBytes());
        if (log.isDebugEnabled()) {
            log.debug((Object)"loading UML/XMI model");
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(targetNamespaceURI, targetNamespaceURI, (InputStream)stream));
        if (supplierUri == null) {
            PlasmaRuntime.getInstance().addDynamicSDONamespace(targetNamespaceURI, null);
        } else {
            PlasmaRuntime.getInstance().addDynamicSDONamespace(targetNamespaceURI, supplierUri);
        }
        List entities = stagingAssembler.getModel().getClazzs();
        ArrayList<Type> result = new ArrayList<Type>(entities.size());
        for (Class cls : entities) {
            result.add(PlasmaTypeHelper.INSTANCE.getType(cls.getUri(), cls.getName()));
        }
        return result;
    }

    private void writeStagingModel(Model stagingModel, String location, String fileName) {
        try {
            BindingValidationEventHandler debugHandler = new BindingValidationEventHandler(){

                public int getErrorCount() {
                    return 0;
                }

                public boolean handleEvent(ValidationEvent ve) {
                    ValidationEventLocator vel = ve.getLocator();
                    String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
                    switch (ve.getSeverity()) {
                        default: 
                    }
                    log.debug((Object)message);
                    return true;
                }
            };
            MetamodelDataBinding binding = new MetamodelDataBinding(debugHandler);
            String xml = binding.marshal(stagingModel);
            binding.validate(xml);
            File provDebugFile = null;
            provDebugFile = location != null ? new File(location, fileName) : File.createTempFile(fileName, "");
            FileOutputStream provDebugos = new FileOutputStream(provDebugFile);
            log.debug((Object)("Writing provisioning model to: " + provDebugFile.getAbsolutePath()));
            binding.marshal(stagingModel, provDebugos);
        }
        catch (JAXBException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void marshalQuery(Query schema, OutputStream stream) {
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            binding.marshal(schema, stream);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Query unmarshalQuery(InputStream stream) {
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Query)binding.unmarshal(stream);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Query unmarshalQuery(String xml) {
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Query)binding.unmarshal(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Query unmarshalQuery(Reader reader) {
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Query)binding.unmarshal(reader);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Query unmarshalQuery(Source source) {
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Query)binding.unmarshal(source);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }
}

