/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.io.StreamCopier;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.core.CoreXMLDocument;
import org.plasma.sdo.xml.DefaultErrorHandler;
import org.plasma.sdo.xml.MarshallerException;
import org.plasma.sdo.xml.StreamMarshaller;
import org.plasma.sdo.xml.StreamUnmarshaller;
import org.plasma.sdo.xml.UnmarshallerException;
import org.plasma.sdo.xml.XMLOptions;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class PlasmaXMLHelper
implements XMLHelper {
    private static Log log = LogFactory.getLog(PlasmaXMLHelper.class);
    public static volatile PlasmaXMLHelper INSTANCE = PlasmaXMLHelper.initializeInstance();

    private PlasmaXMLHelper() {
    }

    private static synchronized PlasmaXMLHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaXMLHelper();
        }
        return INSTANCE;
    }

    public XMLDocument createDocument(DataObject dataObject, String rootElementURI, String rootElementName) {
        return new CoreXMLDocument(dataObject, rootElementURI, rootElementName);
    }

    public XMLDocument load(String inputString) {
        try {
            return this.load(new ByteArrayInputStream(inputString.getBytes("UTF-8")), null, null);
        }
        catch (IOException e) {
            throw new PlasmaDataObjectException(e);
        }
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        return this.load(inputStream, null, null);
    }

    public XMLDocument load(InputStream inputStream, String locationURI, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamUnmarshaller unmarshaler = new StreamUnmarshaller(xmlOptions, locationURI);
        InputStream unmarshalStream = inputStream;
        if (xmlOptions != null && xmlOptions.isValidate()) {
            File tempFile = File.createTempFile(PlasmaXMLHelper.class.getSimpleName(), "xml");
            StreamCopier.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(tempFile));
            this.validateDOM(new FileInputStream(tempFile), locationURI, (XMLOptions)options);
            unmarshalStream = new FileInputStream(tempFile);
        }
        try {
            unmarshaler.unmarshal(unmarshalStream);
        }
        catch (UnmarshallerException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (XMLStreamException e) {
            throw new PlasmaDataObjectException(e);
        }
        XMLDocument result = unmarshaler.getResult();
        result.setNoNamespaceSchemaLocation(locationURI);
        return result;
    }

    public XMLDocument load(Reader inputReader, String locationURI, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamUnmarshaller unmarshaler = new StreamUnmarshaller(xmlOptions, locationURI);
        try {
            unmarshaler.unmarshal(inputReader);
        }
        catch (UnmarshallerException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (XMLStreamException e) {
            throw new PlasmaDataObjectException(e);
        }
        return unmarshaler.getResult();
    }

    public XMLDocument load(Source inputSource, String locationURI, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamUnmarshaller unmarshaler = new StreamUnmarshaller((XMLOptions)options, locationURI);
        try {
            unmarshaler.unmarshal(inputSource);
        }
        catch (UnmarshallerException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (XMLStreamException e) {
            throw new PlasmaDataObjectException(e);
        }
        return unmarshaler.getResult();
    }

    public String save(DataObject dataObject, String rootElementURI, String rootElementName) {
        String result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.save(dataObject, rootElementURI, rootElementName, os);
            os.flush();
            result = os.toString();
        }
        catch (IOException e) {
            throw new PlasmaDataObjectException(e);
        }
        return result;
    }

    public void save(DataObject dataObject, String rootElementURI, String rootElementName, OutputStream outputStream) throws IOException {
        CoreXMLDocument doc = new CoreXMLDocument(dataObject, rootElementURI, rootElementName);
        StreamMarshaller marshaler = new StreamMarshaller(doc, (XMLOptions)null);
        try {
            marshaler.marshal(outputStream);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (MarshallerException e) {
            throw new IOException(e);
        }
    }

    public void save(XMLDocument xmlDocument, OutputStream outputStream, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamMarshaller marshaler = new StreamMarshaller(xmlDocument);
        marshaler.setOptions(xmlOptions);
        try {
            marshaler.marshal(outputStream);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (MarshallerException e) {
            throw new IOException(e);
        }
    }

    public void save(XMLDocument xmlDocument, Writer outputWriter, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamMarshaller marshaler = new StreamMarshaller(xmlDocument);
        marshaler.setOptions(xmlOptions);
        try {
            marshaler.marshal(outputWriter);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (MarshallerException e) {
            throw new IOException(e);
        }
    }

    public void save(XMLDocument xmlDocument, Result outputResult, Object options) throws IOException {
        if (options != null && !(options instanceof XMLOptions)) {
            throw new IllegalArgumentException("expected 'options' as instance of " + XMLOptions.class.getName());
        }
        XMLOptions xmlOptions = (XMLOptions)options;
        StreamMarshaller marshaler = new StreamMarshaller(xmlDocument);
        marshaler.setOptions(xmlOptions);
        try {
            marshaler.marshal(outputResult);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (MarshallerException e) {
            throw new IOException(e);
        }
    }

    private void validateDOM(InputStream inputStream, String locationURI, XMLOptions options) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setValidating(true);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"parser does not support JAXP 1.2");
        }
        if (locationURI != null) {
            factory.setAttribute("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", locationURI);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (options.getErrorHandler() == null) {
                builder.setErrorHandler(new DefaultErrorHandler(options));
            } else {
                builder.setErrorHandler(options.getErrorHandler());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"validating...");
            }
            builder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (SAXException e) {
            throw new PlasmaDataObjectException(e);
        }
    }

    private void validateSAX(InputStream inputStream, String locationURI, XMLOptions options) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            SAXParser parser = factory.newSAXParser();
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException e) {
                log.warn((Object)"parses does not support JAXP 1.2");
            }
            if (locationURI != null) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", locationURI);
            }
            XMLReader xmlReader = parser.getXMLReader();
            if (options.getErrorHandler() == null) {
                xmlReader.setErrorHandler(new DefaultErrorHandler(options));
            } else {
                xmlReader.setErrorHandler(options.getErrorHandler());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"validating...");
            }
            xmlReader.parse(new InputSource(inputStream));
        }
        catch (SAXNotRecognizedException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (SAXException e) {
            throw new PlasmaDataObjectException(e);
        }
    }
}

