/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.XSDHelper;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.ModelAppInfo;
import org.plasma.metamodel.adapter.ModelAdapter;
import org.plasma.provisioning.MetamodelAssembler;
import org.plasma.provisioning.MetamodelDataBinding;
import org.plasma.provisioning.xsd.SchemaMetamodelAssembler;
import org.plasma.query.Query;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.xml.schema.Annotation;
import org.plasma.xml.schema.Appinfo;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaDataBinding;
import org.plasma.xml.schema.SchemaModelAssembler;
import org.plasma.xml.uml.MDModelAssembler;
import org.xml.sax.SAXException;

public class PlasmaXSDHelper
implements XSDHelper {
    private static Log log = LogFactory.getLog(PlasmaXSDHelper.class);
    public static volatile PlasmaXSDHelper INSTANCE = PlasmaXSDHelper.initializeInstance();

    private PlasmaXSDHelper() {
    }

    private static synchronized PlasmaXSDHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaXSDHelper();
        }
        return INSTANCE;
    }

    public List<Type> define(String xsd) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling schema");
        }
        Schema schema = this.unmarshalSchema(xsd);
        return this.define(schema, null);
    }

    public List<Type> define(Reader xsdReader, String schemaLocation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling schema");
        }
        Schema schema = this.unmarshalSchema(xsdReader);
        return this.define(schema, schemaLocation);
    }

    public List<Type> define(InputStream xsdInputStream, String schemaLocation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"unmarshaling schema");
        }
        Schema schema = this.unmarshalSchema(xsdInputStream);
        return this.define(schema, schemaLocation);
    }

    private List<Type> define(Schema schema, String schemaLocation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"provisioning UML/XMI model");
        }
        SchemaMetamodelAssembler stagingAssembler = new SchemaMetamodelAssembler(schema, schema.getTargetNamespace(), "tns");
        Model stagingModel = stagingAssembler.getModel();
        if (log.isDebugEnabled()) {
            this.writeSchemaStagingModel(stagingModel, schemaLocation, this.getClass().getSimpleName() + "-" + schema.getId() + "-model.xml");
        }
        ModelAdapter helper = new ModelAdapter(stagingModel);
        MDModelAssembler assembler = new MDModelAssembler(stagingModel, schema.getTargetNamespace(), "tns");
        String xmi = assembler.getContent();
        if (log.isDebugEnabled()) {
            File xmiDebugFile = null;
            try {
                xmiDebugFile = schemaLocation != null ? new File(schemaLocation, this.getClass().getSimpleName() + "-" + schema.getId() + "-model.mdxml") : File.createTempFile(schema.getId(), "mdxml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.debug((Object)("Writing UML/XMI to: " + xmiDebugFile.getAbsolutePath()));
            try {
                FileOutputStream os = new FileOutputStream(xmiDebugFile);
                assembler.getContent((OutputStream)os);
            }
            catch (FileNotFoundException os) {
                // empty catch block
            }
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(xmi.getBytes());
        if (log.isDebugEnabled()) {
            log.debug((Object)"loading UML/XMI model");
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(schema.getTargetNamespace(), schema.getTargetNamespace(), (InputStream)stream));
        ModelAppInfo modelAppInfo = this.getModelAppInfo(schema);
        if (modelAppInfo != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("supplier: " + modelAppInfo.getDerivation().getPackageSupplier().getUri()));
            }
            PlasmaRuntime.getInstance().addDynamicSDONamespace(schema.getTargetNamespace(), modelAppInfo.getDerivation().getPackageSupplier().getUri());
        } else {
            PlasmaRuntime.getInstance().addDynamicSDONamespace(schema.getTargetNamespace(), null);
        }
        List entities = stagingAssembler.getModel().getClazzs();
        ArrayList<Type> result = new ArrayList<Type>(entities.size());
        for (Class cls : entities) {
            result.add(PlasmaTypeHelper.INSTANCE.getType(cls.getUri(), cls.getName()));
        }
        return result;
    }

    private ModelAppInfo getModelAppInfo(Schema schema) {
        ModelAppInfo modelAppInfo = null;
        for (OpenAttrs attr : schema.getIncludesAndImportsAndRedefines()) {
            if (!(attr instanceof Annotation)) continue;
            Annotation annot = (Annotation)attr;
            block1: for (Object obj : annot.getAppinfosAndDocumentations()) {
                if (!(obj instanceof Appinfo)) continue;
                for (Object obj2 : ((Appinfo)obj).getContent()) {
                    if (!(obj2 instanceof ModelAppInfo)) continue;
                    modelAppInfo = (ModelAppInfo)obj2;
                    continue block1;
                }
            }
        }
        return modelAppInfo;
    }

    public String generate(List<Type> types) {
        return null;
    }

    public String generate(List<Type> types, Map<String, String> namespaceToSchemaLocation) {
        return null;
    }

    public String generate(Query query, String targetNamespaceURI, String targetNamespacePrefix, Map<String, String> namespaceToSchemaLocation) {
        if (targetNamespaceURI == null || targetNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument 'targetNamespaceURI'");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.generate(query, targetNamespaceURI, targetNamespacePrefix, namespaceToSchemaLocation, stream);
        return new String(stream.toByteArray());
    }

    public void generate(Query query, String targetNamespaceURI, String targetNamespacePrefix, Map<String, String> namespaceToSchemaLocation, OutputStream xsdOutputStream) {
        if (targetNamespaceURI == null || targetNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument 'targetNamespaceURI'");
        }
        MetamodelAssembler assembler = new MetamodelAssembler(query, targetNamespaceURI, targetNamespacePrefix);
        Model model = assembler.getModel();
        if (log.isDebugEnabled()) {
            this.writeSchemaStagingModel(model, ".", this.getClass().getSimpleName() + "-" + query.getName() + "-model.xml");
        }
        SchemaModelAssembler builder = new SchemaModelAssembler(model, targetNamespaceURI, targetNamespacePrefix);
        Schema schema = builder.getSchema();
        this.marshalSchema(schema, xsdOutputStream);
    }

    public String getAppinfo(Type type, String source) {
        return null;
    }

    public String getAppinfo(Property property, String source) {
        return null;
    }

    public Property getGlobalProperty(String uri, String propertyName, boolean isElement) {
        return null;
    }

    public String getLocalName(Type type) {
        return ((PlasmaType)type).getLocalName();
    }

    public String getLocalName(Property property) {
        return ((PlasmaProperty)property).getLocalName();
    }

    public String getNamespaceURI(Property property) {
        return property.getContainingType().getURI();
    }

    public boolean isAttribute(Property property) {
        return ((PlasmaProperty)property).isXMLAttribute();
    }

    public boolean isElement(Property property) {
        return !((PlasmaProperty)property).isXMLAttribute();
    }

    public boolean isMixed(Type type) {
        return false;
    }

    public boolean isXSD(Type type) {
        return false;
    }

    private void marshalSchema(Schema schema, OutputStream stream) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            binding.marshal(schema, stream);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Schema unmarshalSchema(InputStream stream) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Schema)binding.unmarshal(stream);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Schema unmarshalSchema(String xml) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Schema)binding.unmarshal(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Schema unmarshalSchema(Reader reader) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Schema)binding.unmarshal(reader);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private Schema unmarshalSchema(Source source) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Schema)binding.unmarshal(source);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private void writeSchemaStagingModel(Model stagingModel, String location, String fileName) {
        try {
            BindingValidationEventHandler debugHandler = new BindingValidationEventHandler(){

                public int getErrorCount() {
                    return 0;
                }

                public boolean handleEvent(ValidationEvent ve) {
                    ValidationEventLocator vel = ve.getLocator();
                    String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
                    switch (ve.getSeverity()) {
                        default: 
                    }
                    log.debug((Object)message);
                    return true;
                }
            };
            MetamodelDataBinding binding = new MetamodelDataBinding(debugHandler);
            String xml = binding.marshal(stagingModel);
            binding.validate(xml);
            File provDebugFile = null;
            provDebugFile = location != null ? new File(location, fileName) : File.createTempFile(fileName, "");
            FileOutputStream provDebugos = new FileOutputStream(provDebugFile);
            log.debug((Object)("Writing provisioning model to: " + provDebugFile.getAbsolutePath()));
            binding.marshal(stagingModel, provDebugos);
        }
        catch (JAXBException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }
}

