/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository.fuml;

import java.util.ArrayList;
import java.util.List;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Package;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.fuml.FumlElement;
import org.plasma.sdo.repository.fuml.FumlRepository;

class FumlNamespace
extends FumlElement<Package>
implements Namespace {
    private String packageQualifiedName;

    public FumlNamespace(Package namespace) {
        super(namespace);
    }

    @Override
    public String getUri() {
        List<Stereotype> stereotypes = FumlRepository.getFumlRepositoryInstance().getStereotypes((Element)this.element);
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!(stereotype.getDelegate() instanceof SDONamespace)) continue;
                SDONamespace sdoNamespaceStereotype = (SDONamespace)stereotype.getDelegate();
                return sdoNamespaceStereotype.getUri();
            }
        }
        return null;
    }

    @Override
    public String getQualifiedPackageName() {
        if (this.packageQualifiedName == null) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(((Package)this.element).getName());
            for (Package parent = ((Package)this.element).getNestingPackage(); parent != null; parent = parent.getNestingPackage()) {
                names.add(parent.getName());
            }
            StringBuilder buf = new StringBuilder();
            int len = names.size();
            for (int i = len - 1; i >= 0; --i) {
                if (i < len - 1) {
                    buf.append(".");
                }
                String name = (String)names.get(i);
                buf.append(name);
            }
            this.packageQualifiedName = buf.toString();
        }
        return this.packageQualifiedName;
    }
}

