/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository.fuml;

import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.PackageableElement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.modeldriven.fuml.repository.NamedElement;
import org.modeldriven.fuml.repository.RepositorylException;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.runtime.Artifact;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Element;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.EnumerationLiteral;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.Property;
import org.plasma.sdo.repository.RelationCache;
import org.plasma.sdo.repository.Repository;
import org.plasma.sdo.repository.RepositoryException;
import org.plasma.sdo.repository.fuml.FumlClass_;
import org.plasma.sdo.repository.fuml.FumlClassifier;
import org.plasma.sdo.repository.fuml.FumlElement;
import org.plasma.sdo.repository.fuml.FumlEnumeration;
import org.plasma.sdo.repository.fuml.FumlEnumerationLiteral;
import org.plasma.sdo.repository.fuml.FumlNamespace;
import org.plasma.sdo.repository.fuml.FumlProperty;
import org.plasma.sdo.repository.fuml.FumlRelationCache;

public class FumlRepository
implements Repository {
    private static Log log = LogFactory.getLog(FumlRepository.class);
    private static volatile FumlRepository instance;
    private static org.modeldriven.fuml.repository.Repository delegate;
    private RelationCache relationCache = new FumlRelationCache();
    private static List<Classifier> EMPTY_CLASSIFIER_LIST;

    private FumlRepository() {
    }

    public static Repository getInstance() throws RepositoryException {
        return FumlRepository.getFumlRepositoryInstance();
    }

    static FumlRepository getFumlRepositoryInstance() throws RepositoryException {
        if (instance == null) {
            FumlRepository.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws RepositorylException {
        if (instance == null) {
            for (org.plasma.runtime.Repository repo : PlasmaRuntime.getInstance().getRepositories()) {
                for (Artifact artifact : repo.getArtifacts()) {
                    InputStream stream = PlasmaRuntime.class.getResourceAsStream(artifact.getUrn());
                    if (stream == null) {
                        stream = PlasmaRuntime.class.getClassLoader().getResourceAsStream(artifact.getUrn());
                    }
                    if (stream == null) {
                        throw new PlasmaRuntimeException("could not find artifact resource '" + artifact.getUrn() + "' on the current classpath");
                    }
                    Fuml.load((ResourceArtifact)new ResourceArtifact(artifact.getUrn(), artifact.getNamespaceUri(), stream));
                }
            }
            delegate = org.modeldriven.fuml.repository.Repository.INSTANCE;
            instance = new FumlRepository();
        }
    }

    @Override
    public List<String> getAllNamespaceUris() {
        ArrayList<String> result = new ArrayList<String>();
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            result.add(namespace.getUri());
        }
        return result;
    }

    @Override
    public List<Namespace> getAllNamespaces() {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            Package pkg = namespace.getBase_Package();
            org.modeldriven.fuml.repository.Package repoPkg = (org.modeldriven.fuml.repository.Package)delegate.getElementById(pkg.getXmiId());
            result.add(new FumlNamespace(repoPkg));
        }
        return result;
    }

    @Override
    public FumlNamespace getNamespaceForUri(String uri) {
        List list = delegate.getStereotypes(SDONamespace.class);
        FumlNamespace result = null;
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            if (!namespace.getUri().equals(uri)) continue;
            if (result != null) {
                throw new RepositoryException("multiple namespaces stereotyped as " + SDONamespace.class.getSimpleName() + " with URI " + uri);
            }
            String packageXmiId = namespace.getBase_Package().getXmiId();
            org.modeldriven.fuml.repository.Package pkg = (org.modeldriven.fuml.repository.Package)delegate.findElementById(packageXmiId);
            result = new FumlNamespace(pkg);
        }
        return result;
    }

    @Override
    public List<Classifier> getClassifiers(String uri) {
        Package nsPackage = this.findPackage(uri);
        if (nsPackage != null) {
            ArrayList<Classifier> result = new ArrayList<Classifier>();
            this.addClasses(nsPackage, result);
            return result;
        }
        return EMPTY_CLASSIFIER_LIST;
    }

    @Override
    public List<Classifier> getEnumerations(String uri) {
        Package nsPackage = this.findPackage(uri);
        if (nsPackage != null) {
            ArrayList<Classifier> result = new ArrayList<Classifier>();
            this.addEnumerations(nsPackage, result);
            return result;
        }
        return EMPTY_CLASSIFIER_LIST;
    }

    private Package findPackage(String uri) {
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            if (!uri.equals(namespace.getUri())) continue;
            return namespace.getBase_Package();
        }
        return null;
    }

    private void addClasses(Package pkg, List<Classifier> result) {
        for (PackageableElement pe : pkg.packagedElement) {
            if (pe instanceof Package) {
                this.addClasses((Package)pe, result);
                continue;
            }
            if (!(pe instanceof fUML.Syntax.Classes.Kernel.Class_)) continue;
            Classifier classifier = this.getClassifierById(pe.getXmiId());
            result.add(classifier);
        }
    }

    private void addEnumerations(Package pkg, List<Classifier> result) {
        for (PackageableElement pe : pkg.packagedElement) {
            if (pe instanceof Package) {
                this.addEnumerations((Package)pe, result);
                continue;
            }
            if (!(pe instanceof fUML.Syntax.Classes.Kernel.Enumeration)) continue;
            Classifier classifier = this.getClassifierById(pe.getXmiId());
            result.add(classifier);
        }
    }

    public Element getElementById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlElement<NamedElement>(e);
    }

    @Override
    public Class_ getClassById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlClass_((org.modeldriven.fuml.repository.Class_)e);
    }

    public Enumeration getEnumerationById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlEnumeration((org.modeldriven.fuml.repository.Enumeration)e);
    }

    public EnumerationLiteral getEnumerationLiteralById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlEnumerationLiteral((org.modeldriven.fuml.repository.EnumerationLiteral)e);
    }

    public Classifier getClassifierById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlClassifier<org.modeldriven.fuml.repository.Classifier>((org.modeldriven.fuml.repository.Classifier)e);
    }

    public Property getPropertyById(String id) {
        NamedElement e = (NamedElement)delegate.getElementById(id);
        if (e == null) {
            throw new RepositoryException("no element defined for id, " + id);
        }
        return new FumlProperty((org.modeldriven.fuml.repository.Property)e);
    }

    @Override
    public Classifier getClassifier(String name) {
        org.modeldriven.fuml.repository.Classifier result = delegate.getClassifier(name);
        if (result == null) {
            throw new RepositoryException("no classifier defined for qualified name, " + name);
        }
        if (org.modeldriven.fuml.repository.Class_.class.isAssignableFrom(result.getClass())) {
            return new FumlClass_((org.modeldriven.fuml.repository.Class_)result);
        }
        return new FumlClassifier<org.modeldriven.fuml.repository.Classifier>(result);
    }

    @Override
    public Classifier findClassifier(String name) {
        org.modeldriven.fuml.repository.Classifier result = delegate.findClassifier(name);
        if (result != null) {
            if (org.modeldriven.fuml.repository.Class_.class.isAssignableFrom(result.getClass())) {
                return new FumlClass_((org.modeldriven.fuml.repository.Class_)result);
            }
            return new FumlClassifier<org.modeldriven.fuml.repository.Classifier>(result);
        }
        return null;
    }

    public Element findElementById(String id) {
        NamedElement e = (NamedElement)delegate.findElementById(id);
        if (e != null) {
            return new FumlElement<NamedElement>(e);
        }
        return null;
    }

    public Element findElementByName(String name) {
        NamedElement e = (NamedElement)delegate.findElementByName(name);
        if (e != null) {
            return new FumlElement<NamedElement>(e);
        }
        return null;
    }

    public Element findElementByQualifiedName(String qualifiedName) {
        NamedElement e = (NamedElement)delegate.findElementByQualifiedName(qualifiedName);
        if (e != null) {
            return new FumlElement<NamedElement>(e);
        }
        return null;
    }

    public Classifier getClassifierByName(String name) {
        org.modeldriven.fuml.repository.Classifier result = delegate.getClassifierByName(name);
        if (result == null) {
            throw new RepositoryException("no classifier defined for qualified name, " + name);
        }
        if (org.modeldriven.fuml.repository.Class_.class.isAssignableFrom(result.getClass())) {
            return new FumlClass_((org.modeldriven.fuml.repository.Class_)result);
        }
        return new FumlClassifier<org.modeldriven.fuml.repository.Classifier>(result);
    }

    public Classifier getClassifierByQualifiedName(String qualifiedName) {
        org.modeldriven.fuml.repository.Classifier result = delegate.getClassifierByQualifiedName(qualifiedName);
        if (result == null) {
            throw new RepositoryException("no classifier defined for qualified name, " + qualifiedName);
        }
        if (org.modeldriven.fuml.repository.Class_.class.isAssignableFrom(result.getClass())) {
            return new FumlClass_((org.modeldriven.fuml.repository.Class_)result);
        }
        return new FumlClassifier<org.modeldriven.fuml.repository.Classifier>(result);
    }

    public String getDefaultUMLNamespaceURI() {
        return delegate.getDefaultUMLNamespaceURI();
    }

    public Element getElementByName(String name) {
        NamedElement e = (NamedElement)delegate.getElementByName(name);
        if (e == null) {
            throw new RepositoryException("no element defined for name, " + name);
        }
        return new FumlElement<NamedElement>(e);
    }

    public Element getElementByQualifiedName(String qualifiedName) {
        NamedElement e = (NamedElement)delegate.getElementByQualifiedName(qualifiedName);
        if (e == null) {
            throw new RepositoryException("no element defined for qualified name, " + qualifiedName);
        }
        return new FumlElement<NamedElement>(e);
    }

    @Override
    public RelationCache getRelationCache() {
        return this.relationCache;
    }

    List<Stereotype> getStereotypes(org.modeldriven.fuml.repository.Element element) {
        return delegate.getStereotypes(element);
    }

    List<org.modeldriven.fuml.repository.Classifier> getSpecializations(org.modeldriven.fuml.repository.Classifier classifier) {
        return delegate.getSpecializations(classifier);
    }

    static {
        EMPTY_CLASSIFIER_LIST = new ArrayList<Classifier>();
    }
}

