/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.xml.ErrorLocator;
import org.plasma.sdo.xml.XMLOptions;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler {
    private static Log log = LogFactory.getLog(DefaultErrorHandler.class);
    private XMLOptions options;

    private DefaultErrorHandler() {
    }

    public DefaultErrorHandler(XMLOptions options) {
        this.options = options;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String msg = "line:column[" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
        msg = msg + " - " + e.getMessage();
        if (this.options.isFailOnValidationError()) {
            throw new SAXParseException(msg, new ErrorLocator(e));
        }
        if (this.options.getValidationLog() != null) {
            this.options.getValidationLog().error((Object)msg);
        } else {
            log.error((Object)msg);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String msg = "line:column[" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
        msg = msg + " - " + e.getMessage();
        if (this.options.isFailOnValidationError()) {
            throw new SAXParseException(msg, new ErrorLocator(e));
        }
        if (this.options.getValidationLog() != null) {
            this.options.getValidationLog().fatal((Object)msg);
        } else {
            log.fatal((Object)msg);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        String msg = "line:column[" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
        msg = msg + " - " + e.getMessage();
        if (this.options.getValidationLog() != null) {
            this.options.getValidationLog().warn((Object)msg);
        } else {
            log.warn((Object)msg);
        }
    }
}

