/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.xml.StreamNode;
import org.plasma.sdo.xml.StreamObjectVisitor;

class StreamObject
extends StreamNode {
    protected PlasmaProperty source;
    private PlasmaDataObject dataObject;
    protected Map<PlasmaProperty, Object> values;
    private boolean isNonContainmentReference;
    private String serialId;

    public StreamObject(PlasmaType type, QName name, Location loc) {
        super(type, name, loc);
    }

    public StreamObject(PlasmaType type, PlasmaProperty source, QName name, Location loc) {
        super(type, name, loc);
        this.source = source;
    }

    public PlasmaProperty getSource() {
        return this.source;
    }

    public boolean isNonContainmentReference() {
        return this.isNonContainmentReference;
    }

    public void setNonContainmentReference(boolean isReference) {
        this.isNonContainmentReference = isReference;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public PlasmaDataObject getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(PlasmaDataObject dataObject) {
        this.dataObject = dataObject;
    }

    public Map<PlasmaProperty, Object> getValues() {
        if (this.values == null) {
            this.values = new HashMap<PlasmaProperty, Object>();
        }
        return this.values;
    }

    public Object get(PlasmaProperty property) {
        return this.getValues().get(property);
    }

    public Object set(PlasmaProperty property, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("expected non-null value arg");
        }
        return this.getValues().put(property, value);
    }

    public void accept(StreamObjectVisitor visitor) {
        this.accept(visitor, this, null, null, this, false, 0, new HashMap<StreamObject, HashSet<StreamObject>>());
    }

    private void accept(StreamObjectVisitor visitor, StreamObject target, StreamObject source, PlasmaProperty sourceProperty, StreamObject root, boolean depthFirst, int level, HashMap<StreamObject, HashSet<StreamObject>> visitedObjects) {
        if (source != null) {
            HashSet<StreamObject> visitedChildren;
            if (!visitedObjects.containsKey(source)) {
                visitedObjects.put(source, new HashSet());
            }
            if (!(visitedChildren = visitedObjects.get(source)).contains(target)) {
                visitedChildren.add(target);
            } else {
                return;
            }
        }
        if (!depthFirst) {
            visitor.visit(target, source, sourceProperty, level);
        }
        for (PlasmaProperty property : target.getValues().keySet()) {
            if (property.getType().isDataType()) continue;
            if (!property.isMany()) {
                StreamObject child = (StreamObject)target.get(property);
                if (child == null || child.equals(root)) continue;
                child.accept(visitor, child, target, property, root, depthFirst, level + 1, visitedObjects);
                continue;
            }
            List childList = (List)target.get(property);
            if (childList == null) continue;
            StreamObject[] childArray = new StreamObject[childList.size()];
            childList.toArray(childArray);
            for (int i = 0; i < childArray.length; ++i) {
                StreamObject child = childArray[i];
                if (child.equals(root)) continue;
                child.accept(visitor, child, target, property, root, depthFirst, level + 1, visitedObjects);
            }
        }
        if (depthFirst) {
            visitor.visit(target, source, sourceProperty, level);
        }
    }
}

