/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xpath;

import commonj.sdo.DataObject;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.plasma.sdo.xpath.DataGraphNavigator;
import org.plasma.sdo.xpath.DataGraphNodeAdapter;
import org.plasma.sdo.xpath.DefaultXPath;
import org.plasma.sdo.xpath.InvalidEndpointException;
import org.plasma.sdo.xpath.InvalidMultiplicityException;
import org.plasma.sdo.xpath.XPathDataObject;
import org.plasma.sdo.xpath.XPathDataProperty;
import org.plasma.sdo.xpath.XPathDataValue;

public class DataGraphXPath
extends DefaultXPath {
    private static final long serialVersionUID = 1L;
    private static final XPathDataObject[] EMPTY_DATA_OBJECT_ARRAY = new XPathDataObject[0];
    private static final XPathDataProperty[] EMPTY_PROPERTY_ARRAY = new XPathDataProperty[0];
    private static final DataGraphNodeAdapter[] EMPTY_NODE_ARRAY = new DataGraphNodeAdapter[0];

    public DataGraphXPath(String xpathExpr) throws JaxenException {
        super(xpathExpr, (Navigator)new DataGraphNavigator());
    }

    public DataGraphXPath(String xpathExpr, Navigator navigator) throws JaxenException {
        super(xpathExpr, navigator);
    }

    public Context getNodeContext(Object node) {
        return this.getContext(node);
    }

    public DataGraphNodeAdapter[] getResults(DataObject root) throws JaxenException, InvalidMultiplicityException {
        List nodes = this.selectNodes(root);
        if (nodes == null || nodes.size() == 0) {
            return EMPTY_NODE_ARRAY;
        }
        DataGraphNodeAdapter[] adapters = new DataGraphNodeAdapter[nodes.size()];
        nodes.toArray(adapters);
        if (adapters.length > 1) {
            for (DataGraphNodeAdapter adapter : adapters) {
                if (adapter.getSourceProperty().isMany()) continue;
                throw new InvalidMultiplicityException("given XPATH '" + this.toString() + "' resulted in multiple values for singular " + "property, " + adapter.getSource().getType().getURI() + "#" + adapter.getSource().getType().getName() + "." + adapter.getSourceProperty().getName());
            }
        }
        return adapters;
    }

    public XPathDataProperty[] findProperties(DataObject root) throws JaxenException, InvalidEndpointException {
        List nodes = this.selectNodes(root);
        if (nodes == null || nodes.size() == 0) {
            return EMPTY_PROPERTY_ARRAY;
        }
        XPathDataProperty[] adapters = new XPathDataProperty[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Object node = nodes.get(i);
            if (!(node instanceof XPathDataProperty)) {
                if (node instanceof XPathDataObject) {
                    throw new InvalidEndpointException("expected Property results rather than Data Object results for the given XPATH '" + this.toString() + "'");
                }
                if (node instanceof XPathDataValue) {
                    throw new InvalidEndpointException("expected Property results rather than value results for the given XPATH '" + this.toString() + "'");
                }
                throw new InvalidEndpointException("expected Property results for the given XPATH '" + this.toString() + "'");
            }
            adapters[i] = (XPathDataProperty)node;
        }
        return adapters;
    }

    public XPathDataProperty findDataProperty(DataObject root) throws JaxenException, InvalidEndpointException {
        Object node = this.selectSingleNode(root);
        if (node == null) {
            return null;
        }
        if (!(node instanceof XPathDataProperty)) {
            if (node instanceof XPathDataObject) {
                throw new InvalidEndpointException("expected Property results rather than Data Object results for the given XPATH '" + this.toString() + "'");
            }
            if (node instanceof XPathDataValue) {
                throw new InvalidEndpointException("expected Property results rather than value results for the given XPATH '" + this.toString() + "'");
            }
            throw new InvalidEndpointException("expected Property results for the given XPATH '" + this.toString() + "'");
        }
        return (XPathDataProperty)node;
    }

    public XPathDataObject findDataObject(DataObject root) throws JaxenException, InvalidEndpointException {
        Object node = this.selectSingleNode(root);
        if (node == null) {
            return null;
        }
        if (!(node instanceof XPathDataObject)) {
            if (node instanceof XPathDataProperty) {
                throw new InvalidEndpointException("expected Data Object results rather than Property results for the given XPATH '" + this.toString() + "'");
            }
            if (node instanceof XPathDataValue) {
                throw new InvalidEndpointException("expected Data Object results rather than value results for the given XPATH '" + this.toString() + "'");
            }
            throw new InvalidEndpointException("expected Data Object results for the given XPATH '" + this.toString() + "'");
        }
        return (XPathDataObject)node;
    }

    public XPathDataObject[] findDataObjects(DataObject root) throws JaxenException, InvalidEndpointException, InvalidMultiplicityException {
        List nodes = this.selectNodes(root);
        if (nodes == null || nodes.size() == 0) {
            return EMPTY_DATA_OBJECT_ARRAY;
        }
        XPathDataObject[] adapters = new XPathDataObject[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Object node = nodes.get(i);
            if (!(node instanceof XPathDataObject)) {
                if (node instanceof XPathDataProperty) {
                    throw new InvalidEndpointException("expected Data Object results rather than Property results for the given XPATH '" + this.toString() + "'");
                }
                if (node instanceof XPathDataValue) {
                    throw new InvalidEndpointException("expected Data Object results rather than value results for the given XPATH '" + this.toString() + "'");
                }
                throw new InvalidEndpointException("expected Data Object results for the given XPATH '" + this.toString() + "'");
            }
            adapters[i] = (XPathDataObject)node;
            if (nodes.size() <= 1 || adapters[i].getSourceProperty().isMany()) continue;
            throw new InvalidMultiplicityException("given path '" + this.toString() + "' resulted in multiple values for singular " + "property, " + adapters[i].getSource().getType().getURI() + "#" + adapters[i].getSource().getType().getName() + "." + adapters[i].getSourceProperty().getName());
        }
        return adapters;
    }
}

