/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.xml.schema;

import commonj.sdo.Property;
import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassAppInfo;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.ModelAppInfo;
import org.plasma.metamodel.PropertyAppInfo;
import org.plasma.metamodel.VisibilityType;
import org.plasma.metamodel.adapter.ModelAdapter;
import org.plasma.metamodel.adapter.ProvisioningModel;
import org.plasma.metamodel.adapter.TypeAdapter;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.ValueConstraint;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.helper.PlasmaXSDHelper;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.EnumerationLiteral;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Annotation;
import org.plasma.xml.schema.Appinfo;
import org.plasma.xml.schema.Attribute;
import org.plasma.xml.schema.ComplexContent;
import org.plasma.xml.schema.ComplexType;
import org.plasma.xml.schema.Documentation;
import org.plasma.xml.schema.Element;
import org.plasma.xml.schema.Enumeration;
import org.plasma.xml.schema.ExplicitGroup;
import org.plasma.xml.schema.ExtensionType;
import org.plasma.xml.schema.Facet;
import org.plasma.xml.schema.LocalSimpleType;
import org.plasma.xml.schema.NumFacet;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Pattern;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaUtil;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.sdox.BaseDataGraphType;

public class SchemaModelAssembler {
    private static Log log = LogFactory.getLog(SchemaModelAssembler.class);
    private String destNamespaceURI;
    private String destNamespacePrefix;
    private Model model;
    private Schema schema;
    private boolean createNonContainmentReferenceTypes = true;
    private ProvisioningModel helper;
    private Map<String, SimpleType> topLevelTypes = new HashMap<String, SimpleType>();

    private SchemaModelAssembler() {
    }

    public SchemaModelAssembler(Model model, String destNamespaceURI, String destNamespacePrefix) {
        this.model = model;
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
    }

    public Schema getSchema() {
        this.construct(this.model, this.destNamespaceURI, this.destNamespacePrefix);
        return this.schema;
    }

    public boolean isCreateNonContainmentReferenceTypes() {
        return this.createNonContainmentReferenceTypes;
    }

    public void setCreateNonContainmentReferenceTypes(boolean createNonContainmentReferenceTypes) {
        this.createNonContainmentReferenceTypes = createNonContainmentReferenceTypes;
    }

    private void construct(Model model, String destNamespaceURI, String destNamespacePrefix) {
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespaceURI' argument");
        }
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespacePrefix' argument");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("constructing schema for model: " + model.getName()));
        }
        this.helper = new ModelAdapter(model);
        this.schema = this.buildSchema(model);
        ComplexType serializationBaseType = this.buildSerializationBaseType();
        TypeAdapter[] types = this.helper.getTypesArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processing " + types.length + " types"));
        }
        for (TypeAdapter adapter : types) {
            if (!(adapter.getType() instanceof Class)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ignoring type: " + adapter.getType().getName()));
                continue;
            }
            Class clss = (Class)adapter.getType();
            PlasmaType sdoType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(adapter.getUri(), adapter.getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing class: " + clss.getName()));
            }
            ComplexType complexType = null;
            if (clss.getSuperClasses().size() == 0) {
                ComplexType baseType = serializationBaseType;
                complexType = this.buildComplexType(adapter, baseType);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created complex type: " + complexType.getName()));
                }
                this.addDatatypeAttributesAndElements(complexType, baseType, adapter, sdoType);
            } else {
                if (clss.getSuperClasses().size() > 1) {
                    throw new IllegalStateException("cannot process multiple base classes for type, " + adapter.getKey());
                }
                complexType = this.buildComplexType(adapter, ((ClassRef)clss.getSuperClasses().get(0)).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created complex type: " + complexType.getName()));
                }
                this.addDatatypeAttributesAndElements(complexType, null, adapter, sdoType);
            }
            this.addReferenceElements(complexType, adapter, sdoType);
        }
    }

    private void addDatatypeAttributesAndElements(ComplexType complexType, ComplexType baseType, TypeAdapter adapter, PlasmaType sdoType) {
        for (org.plasma.metamodel.Property prop : adapter.getDeclaredPropertiesArray()) {
            PlasmaProperty property = (PlasmaProperty)sdoType.getProperty(prop.getName());
            if (!(prop.getType() instanceof DataTypeRef)) continue;
            if (property.isXMLAttribute()) {
                Attribute attr = this.buildDataAttributeModel(adapter, sdoType, prop, property, this.schema);
                if (complexType.getComplexContent() == null) {
                    complexType.getAttributesAndAttributeGroups().add(attr);
                    continue;
                }
                complexType.getComplexContent().getExtension().getAttributesAndAttributeGroups().add(attr);
                continue;
            }
            ExplicitGroup group = null;
            if (complexType.getComplexContent() == null) {
                group = complexType.getSequence();
                if (group == null) {
                    group = new ExplicitGroup();
                    complexType.setSequence(group);
                }
            } else {
                group = complexType.getComplexContent().getExtension().getSequence();
                if (group == null) {
                    group = new ExplicitGroup();
                    complexType.getComplexContent().getExtension().setSequence(group);
                }
            }
            Element element = this.buildDataElementModel(adapter, sdoType, prop, property, this.schema);
            group.getElementsAndGroupsAndAlls().add(element);
        }
    }

    private void addReferenceElements(ComplexType complexType, TypeAdapter adapter, PlasmaType sdoType) {
        for (org.plasma.metamodel.Property prop : adapter.getDeclaredPropertiesArray()) {
            PlasmaProperty property = (PlasmaProperty)sdoType.getProperty(prop.getName());
            if (prop.getType() instanceof DataTypeRef || prop.getVisibility() != null && prop.getVisibility().ordinal() == VisibilityType.PRIVATE.ordinal()) continue;
            ExplicitGroup group = null;
            if (complexType.getComplexContent() == null) {
                group = complexType.getSequence();
                if (group == null) {
                    group = new ExplicitGroup();
                    complexType.setSequence(group);
                }
            } else {
                group = complexType.getComplexContent().getExtension().getSequence();
                if (group == null) {
                    group = new ExplicitGroup();
                    complexType.getComplexContent().getExtension().setSequence(group);
                }
            }
            Element element = this.buildReferenceElementModel(adapter, sdoType, prop, property, this.schema);
            group.getElementsAndGroupsAndAlls().add(element);
        }
    }

    private Schema buildSchema(Model model) {
        Schema schema = new Schema();
        schema.setId(model.getName());
        schema.setTargetNamespace(this.destNamespaceURI);
        Annotation annotation = new Annotation();
        schema.getIncludesAndImportsAndRedefines().add(annotation);
        if (model.getDocumentations() != null && model.getDocumentations().size() > 0) {
            Documentation docum = new Documentation();
            docum.getContent().add(((org.plasma.metamodel.Documentation)model.getDocumentations().get(0)).getBody().getValue());
            annotation.getAppinfosAndDocumentations().add(docum);
        }
        ModelAppInfo modelAppInfo = new ModelAppInfo();
        modelAppInfo.setId(model.getId());
        modelAppInfo.setName(model.getName());
        modelAppInfo.setUri(model.getUri());
        modelAppInfo.setDerivation(model.getDerivation());
        Appinfo appinfo = new Appinfo();
        appinfo.getContent().add(modelAppInfo);
        annotation.getAppinfosAndDocumentations().add(appinfo);
        QName plasmaNamespace = new QName("http://www.terrameta.org/plasma/metamodel", "plasma");
        schema.getOtherAttributes().put(plasmaNamespace, "http://www.terrameta.org/plasma/metamodel");
        QName appNamespace = new QName(schema.getTargetNamespace(), this.destNamespacePrefix, this.destNamespacePrefix);
        schema.getOtherAttributes().put(appNamespace, schema.getTargetNamespace());
        QName sdoxNamespace = new QName("commonj.sdo/xml", "sdox", "sdox");
        schema.getOtherAttributes().put(sdoxNamespace, "commonj.sdo/xml");
        QName xmlNamespace = new QName("http://www.w3.org/XML/1998/namespace", "xml", "xml");
        schema.getOtherAttributes().put(xmlNamespace, "http://www.w3.org/XML/1998/namespace");
        return schema;
    }

    private ComplexType buildDatagraphEnvelopeType(Model model) {
        String name = model.getRootClass().getName() + "Datagraph";
        Element topLevelElement = new Element();
        topLevelElement.setName(name);
        QName topLevelType = new QName(this.schema.getTargetNamespace(), name, this.destNamespacePrefix);
        topLevelElement.setType(topLevelType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(topLevelElement);
        ComplexType complexType = new ComplexType();
        complexType.setName(name);
        this.addAnnotation("SDO Data Graph root type", (Annotated)complexType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(complexType);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType extension = new ExtensionType();
        complexContent.setExtension(extension);
        QName base = new QName("commonj.sdo", BaseDataGraphType.class.getSimpleName(), "sdo");
        extension.setBase(base);
        Element element = new Element();
        element.setName(model.getRootClass().getName());
        QName elementType = new QName(this.schema.getTargetNamespace(), model.getRootClass().getName());
        element.setType(elementType);
        element.setMinOccurs(new BigInteger("1"));
        element.setMaxOccurs("1");
        ExplicitGroup group = new ExplicitGroup();
        complexType.getComplexContent().getExtension().setSequence(group);
        group.getElementsAndGroupsAndAlls().add(element);
        return complexType;
    }

    private ComplexType buildSerializationBaseType() {
        Element topLevelElement = new Element();
        topLevelElement.setName(SchemaUtil.getSerializationBaseTypeName());
        QName topLevelType = new QName(this.schema.getTargetNamespace(), SchemaUtil.getSerializationBaseTypeName(), this.destNamespacePrefix);
        topLevelElement.setType(topLevelType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(topLevelElement);
        ComplexType complexType = new ComplexType();
        complexType.setName(SchemaUtil.getSerializationBaseTypeName());
        this.addAnnotation("default XML serialization common base type used to generalize any type within a Data Graph for use in an XML document as either a containment or non-containment reference", (Annotated)complexType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(complexType);
        Attribute attr = new Attribute();
        complexType.getAttributesAndAttributeGroups().add(attr);
        attr.setName(SchemaUtil.getSerializationAttributeName());
        attr.setUse("required");
        QName attrType = new QName("http://www.w3.org/2001/XMLSchema", this.getSchemaDatatype(DataType.String));
        attr.setType(attrType);
        return complexType;
    }

    private ComplexType buildComplexType(TypeAdapter type) {
        return this.buildComplexType(type, (String)null);
    }

    private ComplexType buildComplexType(TypeAdapter type, ComplexType baseType) {
        return this.buildComplexType(type, baseType != null ? baseType.getName() : null);
    }

    private ComplexType buildComplexType(TypeAdapter type, String baseType) {
        Element topLevelElement = new Element();
        topLevelElement.setName(type.getLocalName());
        QName topLevelType = new QName(this.schema.getTargetNamespace(), type.getName(), this.destNamespacePrefix);
        topLevelElement.setType(topLevelType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(topLevelElement);
        ComplexType complexType = new ComplexType();
        complexType.setName(type.getLocalName());
        List docs = type.getDocumentation();
        for (org.plasma.metamodel.Documentation doc : docs) {
            this.addAnnotation(doc, (Annotated)complexType);
        }
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(complexType);
        this.addSDOXTypeAttributes(type, (OpenAttrs)complexType);
        if (baseType != null) {
            ComplexContent complexContent = new ComplexContent();
            complexType.setComplexContent(complexContent);
            ExtensionType extension = new ExtensionType();
            complexContent.setExtension(extension);
            QName base = new QName(this.destNamespaceURI, baseType, this.destNamespacePrefix);
            extension.setBase(base);
        }
        Class clss = (Class)type.getType();
        ClassAppInfo classAppInfo = new ClassAppInfo();
        classAppInfo.setId(clss.getId());
        classAppInfo.setName(clss.getName());
        classAppInfo.setUri(clss.getUri());
        classAppInfo.setAlias(clss.getAlias());
        classAppInfo.setDerivation(clss.getDerivation());
        Appinfo appinfo = new Appinfo();
        appinfo.getContent().add(classAppInfo);
        Annotation annotation = complexType.getAnnotation();
        if (annotation == null) {
            annotation = new Annotation();
            complexType.setAnnotation(annotation);
        }
        annotation.getAppinfosAndDocumentations().add(appinfo);
        return complexType;
    }

    private ComplexType buildNonContainmentReferenceComplexType(TypeAdapter type) {
        String name = this.getNonContainmentReferenceComplexTypeName(type);
        Element topLevelElement = new Element();
        topLevelElement.setName(name);
        QName topLevelType = new QName(this.schema.getTargetNamespace(), name, this.destNamespacePrefix);
        topLevelElement.setType(topLevelType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(topLevelElement);
        ComplexType complexType = new ComplexType();
        complexType.setName(name);
        this.addAnnotation("non-containment reference type for,  " + type.getLocalName(), (Annotated)complexType);
        this.schema.getSimpleTypesAndComplexTypesAndGroups().add(complexType);
        this.addSDOXTypeAttributes(type, (OpenAttrs)complexType);
        return complexType;
    }

    private String getNonContainmentReferenceComplexTypeName(TypeAdapter type) {
        return SchemaUtil.getNonContainmentReferenceName(type);
    }

    private Element buildReferenceElementModel(TypeAdapter adapter, PlasmaType type, org.plasma.metamodel.Property prop, PlasmaProperty property, Schema schema) {
        Element element = new Element();
        element.setName(PlasmaXSDHelper.INSTANCE.getLocalName(property));
        PlasmaType oppositeType = (PlasmaType)property.getType();
        QName elementType = new QName(schema.getTargetNamespace(), PlasmaXSDHelper.INSTANCE.getLocalName(oppositeType));
        elementType = new QName(schema.getTargetNamespace(), SchemaUtil.getSerializationBaseTypeName());
        element.setType(elementType);
        if (property.isNullable()) {
            element.setMinOccurs(new BigInteger("0"));
        } else {
            element.setMinOccurs(new BigInteger("1"));
        }
        if (!property.isMany()) {
            element.setMaxOccurs("1");
        } else {
            element.setMaxOccurs("unbounded");
        }
        if (property.getDescription() != null && property.getDescription().size() > 0) {
            this.addAnnotation(property.getDescription(), (Annotated)element);
        }
        this.addSDOXPropertyAttributes(property, (OpenAttrs)element);
        Property oppositeProp = property.getOpposite();
        if (oppositeProp != null) {
            QName qname = new QName("commonj.sdo/xml", "oppositeProperty", "sdox");
            element.getOtherAttributes().put(qname, PlasmaXSDHelper.INSTANCE.getLocalName(oppositeProp));
            qname = new QName("commonj.sdo/xml", "propertyType", "sdox");
        }
        return element;
    }

    private Element buildDataElementModel(TypeAdapter adapter, PlasmaType type, org.plasma.metamodel.Property prop, PlasmaProperty property, Schema schema) {
        Element element = new Element();
        element.setName(PlasmaXSDHelper.INSTANCE.getLocalName(property));
        if (property.getRestriction() == null) {
            QName elementType = new QName("http://www.w3.org/2001/XMLSchema", this.getSchemaDatatype(DataType.valueOf((String)PlasmaXSDHelper.INSTANCE.getLocalName(property.getType()))));
            element.setType(elementType);
        } else {
            SimpleType simpleType = this.buildTopLevelSimpleTypeEnumerationRestriction(property);
            QName topLevelType = new QName(schema.getTargetNamespace(), simpleType.getName(), this.destNamespacePrefix);
            element.setType(topLevelType);
        }
        if (property.isNullable()) {
            element.setMinOccurs(new BigInteger("0"));
        } else {
            element.setMinOccurs(new BigInteger("1"));
        }
        if (!property.isMany()) {
            element.setMaxOccurs("1");
        } else {
            element.setMaxOccurs("unbounded");
        }
        if (property.getDescription() != null && property.getDescription().size() > 0) {
            this.addAnnotation(property.getDescription(), (Annotated)element);
        }
        this.addSDOXPropertyAttributes(property, (OpenAttrs)element);
        return element;
    }

    private Attribute buildDataAttributeModel(TypeAdapter adapter, PlasmaType type, org.plasma.metamodel.Property prop, PlasmaProperty property, Schema schema) {
        Attribute attr = new Attribute();
        attr.setName(PlasmaXSDHelper.INSTANCE.getLocalName(property));
        if (property.getRestriction() == null) {
            if (property.getValueConstraint() == null) {
                QName attrType = new QName("http://www.w3.org/2001/XMLSchema", this.getSchemaDatatype(DataType.valueOf((String)PlasmaXSDHelper.INSTANCE.getLocalName(property.getType()))));
                attr.setType(attrType);
            }
        } else {
            SimpleType simpleType = this.buildTopLevelSimpleTypeEnumerationRestriction(property);
            QName topLevelType = new QName(schema.getTargetNamespace(), simpleType.getName(), this.destNamespacePrefix);
            attr.setType(topLevelType);
        }
        if (property.getValueConstraint() != null) {
            if (property.getRestriction() == null) {
                ValueConstraint vc = property.getValueConstraint();
                LocalSimpleType simpleType = this.buildLocalSimpleTypeValueRestriction(property, vc);
                attr.setSimpleType(simpleType);
            } else {
                log.warn((Object)("both value constraint and enumeration constraint found for property, " + type.getURI() + "#" + type.getName() + "." + property.getName() + " - ignoring value constraint"));
            }
        }
        if (!prop.isNullable()) {
            attr.setUse("required");
        } else {
            attr.setUse("optional");
        }
        if (property.getDescription() != null) {
            this.addAnnotation(property.getDescription(), (Annotated)attr);
        }
        this.addSDOXPropertyAttributes(property, (OpenAttrs)attr);
        PropertyAppInfo attribAppInfo = new PropertyAppInfo();
        attribAppInfo.setId(prop.getId());
        attribAppInfo.setName(prop.getName());
        attribAppInfo.setAlias(prop.getAlias());
        attribAppInfo.setDerivation(prop.getDerivation());
        attribAppInfo.setKey(prop.getKey());
        attribAppInfo.setConcurrent(prop.getConcurrent());
        attribAppInfo.setUniqueConstraint(prop.getUniqueConstraint());
        attribAppInfo.setValueConstraint(prop.getValueConstraint());
        attribAppInfo.setEnumerationConstraint(prop.getEnumerationConstraint());
        attribAppInfo.setValueSetConstraint(prop.getValueSetConstraint());
        attribAppInfo.setSort(prop.getSort());
        attribAppInfo.setXmlProperty(prop.getXmlProperty());
        Appinfo appinfo = new Appinfo();
        appinfo.getContent().add(attribAppInfo);
        Annotation annotation = attr.getAnnotation();
        if (annotation == null) {
            annotation = new Annotation();
            attr.setAnnotation(annotation);
        }
        annotation.getAppinfosAndDocumentations().add(appinfo);
        return attr;
    }

    private void addSDOXTypeAttributes(TypeAdapter type, OpenAttrs openAttributes) {
        QName qname = null;
        if (type.getPhysicalName() != null) {
            qname = new QName("commonj.sdo/xml", "aliasName", "sdox");
            openAttributes.getOtherAttributes().put(qname, type.getPhysicalName());
        }
        qname = new QName("commonj.sdo/xml", "name", "sdox");
        openAttributes.getOtherAttributes().put(qname, type.getName());
    }

    private void addSDOXPropertyAttributes(PlasmaProperty property, OpenAttrs openAttributes) {
        QName qname = null;
        qname = new QName("commonj.sdo/xml", "name", "sdox");
        openAttributes.getOtherAttributes().put(qname, property.getName());
        if (!property.getType().isDataType()) {
            qname = new QName("commonj.sdo/xml", "propertyType", "sdox");
            openAttributes.getOtherAttributes().put(qname, this.destNamespacePrefix + ":" + PlasmaXSDHelper.INSTANCE.getLocalName(property.getType()));
        }
        if (property.getAliasNames() != null && property.getAliasNames().size() > 0) {
            qname = new QName("commonj.sdo/xml", "aliasName", "sdox");
            openAttributes.getOtherAttributes().put(qname, property.getAliasNames().get(0));
        } else if (!property.isMany()) {
            log.warn((Object)("no aliases found for singular property " + property.getContainingType().getURI() + "#" + property.getContainingType().getName() + "." + property.getName()));
        }
        qname = new QName("commonj.sdo/xml", "dataType", "sdox");
        if (property.getType().isDataType()) {
            openAttributes.getOtherAttributes().put(qname, PlasmaXSDHelper.INSTANCE.getLocalName(property.getType()));
        } else {
            openAttributes.getOtherAttributes().put(qname, this.destNamespaceURI + "#" + PlasmaXSDHelper.INSTANCE.getLocalName(property.getType()));
        }
        if (property.isKey()) {
            qname = new QName("commonj.sdo/xml", "key", "sdox");
            openAttributes.getOtherAttributes().put(qname, "true");
            qname = new QName("commonj.sdo/xml", "keyType", "sdox");
            openAttributes.getOtherAttributes().put(qname, property.getKey().getType().name().toLowerCase());
        }
        qname = new QName("commonj.sdo/xml", "many", "sdox");
        openAttributes.getOtherAttributes().put(qname, String.valueOf(property.isMany()));
        qname = new QName("commonj.sdo/xml", "readOnly", "sdox");
        openAttributes.getOtherAttributes().put(qname, String.valueOf(property.isReadOnly()));
    }

    private SimpleType buildTopLevelSimpleTypeEnumerationRestriction(PlasmaProperty property) {
        SimpleType simpleType = this.topLevelTypes.get(property.getRestriction().getName());
        if (simpleType == null) {
            simpleType = new SimpleType();
            org.plasma.sdo.repository.Enumeration enumeration = property.getRestriction();
            simpleType.setName(enumeration.getName());
            Restriction restriction = this.buildStringEnumerationRestriction(property);
            simpleType.setRestriction(restriction);
            Annotation annotation = this.addAnnotation(property.getRestriction().getComments(), (Annotated)simpleType);
            Appinfo appinfo = new Appinfo();
            appinfo.getContent().add(enumeration.getName());
            annotation.getAppinfosAndDocumentations().add(appinfo);
            this.topLevelTypes.put(property.getRestriction().getName(), simpleType);
            this.schema.getSimpleTypesAndComplexTypesAndGroups().add(simpleType);
        }
        return simpleType;
    }

    private LocalSimpleType buildLocalSimpleTypeEnumerationRestriction(PlasmaProperty property) {
        LocalSimpleType simpleType = new LocalSimpleType();
        Restriction restriction = this.buildStringEnumerationRestriction(property);
        simpleType.setRestriction(restriction);
        return simpleType;
    }

    private LocalSimpleType buildLocalSimpleTypeValueRestriction(PlasmaProperty property, ValueConstraint valueConstrint) {
        LocalSimpleType simpleType = new LocalSimpleType();
        Restriction restriction = null;
        DataFlavor flavor = property.getDataFlavor();
        if (flavor.ordinal() == DataFlavor.string.ordinal()) {
            restriction = this.buildStringValueRestriction(property, valueConstrint);
        } else if (flavor.ordinal() == DataFlavor.integral.ordinal()) {
            restriction = this.buildNumericValueRestriction(property, valueConstrint);
        } else {
            throw new IllegalStateException("value constraint found for unsupported data flavor '" + flavor.name() + "' on property " + property.getContainingType().getURI() + "#" + property.getContainingType().getName() + "." + property.getName());
        }
        simpleType.setRestriction(restriction);
        return simpleType;
    }

    private Restriction buildNumericValueRestriction(PlasmaProperty property, ValueConstraint valueConstrint) {
        Restriction restriction = new Restriction();
        QName stringType = new QName("http://www.w3.org/2001/XMLSchema", "string");
        restriction.setBase(stringType);
        if (valueConstrint.getMaxInclusive() != null) {
            JAXBElement<Facet> maxIncl = this.createNumberFacet("maxInclusive", valueConstrint.getMaxInclusive());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(maxIncl);
        } else if (valueConstrint.getMinInclusive() != null) {
            JAXBElement<Facet> minIncl = this.createNumberFacet("minInclusive", valueConstrint.getMinInclusive());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(minIncl);
        } else if (valueConstrint.getMinExclusive() != null) {
            JAXBElement<Facet> minExcl = this.createNumberFacet("minExclusive", valueConstrint.getMinExclusive());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(minExcl);
        } else if (valueConstrint.getMaxExclusive() != null) {
            JAXBElement<Facet> maxExcl = this.createNumberFacet("maxExclusive", valueConstrint.getMaxExclusive());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(maxExcl);
        }
        if (valueConstrint.getTotalDigits() != null) {
            JAXBElement<Facet> totDig = this.createNumberFacet("totalDigits", valueConstrint.getTotalDigits());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(totDig);
        }
        if (valueConstrint.getFractionDigits() != null) {
            JAXBElement<Facet> fracDig = this.createNumberFacet("fractionDigits", valueConstrint.getFractionDigits());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(fracDig);
        }
        return restriction;
    }

    private Restriction buildStringValueRestriction(PlasmaProperty property, ValueConstraint valueConstrint) {
        Restriction restriction = new Restriction();
        QName stringType = new QName("http://www.w3.org/2001/XMLSchema", "string");
        restriction.setBase(stringType);
        if (valueConstrint.getMaxLength() != null) {
            JAXBElement<Facet> maxLen = this.createNumberFacet("maxLength", valueConstrint.getMaxLength());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(maxLen);
        } else if (valueConstrint.getMinLength() != null) {
            JAXBElement<Facet> minLen = this.createNumberFacet("minLength", valueConstrint.getMinLength());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(minLen);
        } else if (valueConstrint.getPattern() != null) {
            Pattern pattern = new Pattern();
            pattern.setValue(valueConstrint.getPattern());
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(pattern);
        }
        return restriction;
    }

    private JAXBElement<Facet> createNumberFacet(String name, int value) {
        NumFacet facet = new NumFacet();
        facet.setValue(String.valueOf(value));
        QName qname = new QName("http://www.w3.org/2001/XMLSchema", name);
        return new JAXBElement(qname, Facet.class, null, (Object)facet);
    }

    private JAXBElement<Facet> createNumberFacet(String name, String value) {
        NumFacet facet = new NumFacet();
        facet.setValue(String.valueOf(value));
        QName qname = new QName("http://www.w3.org/2001/XMLSchema", name);
        return new JAXBElement(qname, Facet.class, null, (Object)facet);
    }

    private Restriction buildStringEnumerationRestriction(PlasmaProperty property) {
        Restriction restriction = new Restriction();
        QName stringType = new QName("http://www.w3.org/2001/XMLSchema", "string");
        restriction.setBase(stringType);
        org.plasma.sdo.repository.Enumeration propertyRestriction = property.getRestriction();
        for (EnumerationLiteral literal : propertyRestriction.getOwnedLiteral()) {
            Enumeration enumeration = new Enumeration();
            enumeration.setValue(literal.getPhysicalName());
            Annotation annotation = this.addAnnotation(literal.getComments(), (Annotated)enumeration);
            Appinfo appinfo = new Appinfo();
            appinfo.getContent().add(literal.getName());
            annotation.getAppinfosAndDocumentations().add(appinfo);
            restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().add(enumeration);
        }
        return restriction;
    }

    private Annotation addAnnotation(org.plasma.metamodel.Documentation doc, Annotated annotated) {
        Annotation annotation = new Annotation();
        annotated.setAnnotation(annotation);
        Documentation docum = new Documentation();
        docum.getContent().add("" + doc.getBody().getValue());
        annotation.getAppinfosAndDocumentations().add(docum);
        return annotation;
    }

    private Annotation addAnnotation(List<Comment> description, Annotated annotated) {
        Annotation annotation = new Annotation();
        annotated.setAnnotation(annotation);
        Documentation docum = new Documentation();
        for (Comment comment : description) {
            docum.getContent().add("" + comment.getBody());
        }
        annotation.getAppinfosAndDocumentations().add(docum);
        return annotation;
    }

    private Annotation addAnnotation(String content, Annotated annotated) {
        Annotation annotation = new Annotation();
        annotated.setAnnotation(annotation);
        Documentation docum = new Documentation();
        docum.getContent().add(content);
        annotation.getAppinfosAndDocumentations().add(docum);
        return annotation;
    }

    private String getSchemaDatatype(DataType datatype) {
        switch (datatype) {
            case Boolean: {
                return "boolean";
            }
            case Byte: {
                return "byte";
            }
            case Bytes: {
                return "hexBinary";
            }
            case Character: {
                return "string";
            }
            case DateTime: {
                return "dateTime";
            }
            case Date: {
                return "date";
            }
            case Day: {
                return "gDay";
            }
            case Decimal: {
                return "decimal";
            }
            case Duration: {
                return "duration";
            }
            case Float: {
                return "float";
            }
            case Double: {
                return "double";
            }
            case Int: {
                return "int";
            }
            case Integer: {
                return "integer";
            }
            case Long: {
                return "long";
            }
            case Month: {
                return "gMonth";
            }
            case MonthDay: {
                return "gMonthDay";
            }
            case Short: {
                return "short";
            }
            case String: {
                return "string";
            }
            case Time: {
                return "dateTime";
            }
            case URI: {
                return "anyURI";
            }
            case Year: {
                return "gYear";
            }
            case YearMonth: {
                return "gYearMonth";
            }
            case YearMonthDay: {
                return "date";
            }
            case Object: {
                return "anySimpleType";
            }
        }
        throw new IllegalArgumentException("unknown datatype, " + datatype.toString());
    }

    private List<String> sort(List<String> list) {
        Object[] values = new String[list.size()];
        list.toArray(values);
        Arrays.sort(values);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (Object s : values) {
            result.add((String)s);
        }
        return result;
    }
}

