/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.mojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.plasma.mojo.ClassRealmMojo;
import org.plasma.provisioning.cli.QueryTool;
import org.plasma.provisioning.cli.QueryToolAction;

public class QueryMojo
extends ClassRealmMojo {
    private String action;
    private String sourceFile;
    private String destFile;
    private String destFileType;
    private String destNamespaceURI;
    private String destNamespacePrefix;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.getLog().debug((CharSequence)("tool: " + QueryTool.class.getName()));
        this.getLog().debug((CharSequence)("classRealm: " + this.classRealm));
        try {
            QueryToolAction toolAction = this.getToolAction(this.action);
            String[] args = new String[]{"-" + toolAction.name(), this.sourceFile, this.destFile, this.destFileType, this.destNamespaceURI, this.destNamespacePrefix};
            this.getLog().info((CharSequence)("executing tool: " + QueryTool.class.getName()));
            QueryTool.main((String[])args);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private QueryToolAction getToolAction(String action) {
        QueryToolAction command = null;
        try {
            command = QueryToolAction.valueOf((String)action);
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < QueryToolAction.values().length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(QueryToolAction.values()[i].name());
            }
            throw new IllegalArgumentException("'" + action + "' - expected one of [" + buf.toString() + "]");
        }
        return command;
    }
}

