/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public abstract class ClassRealmMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Object classRealm;
    protected List<String> additionalClasspathElements;
    protected Properties systemProperties;

    public MavenProject getProject() {
        return this.project;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    protected void addURL(URL url) {
        if (this.classRealm instanceof ClassRealm) {
            ClassRealm realm = (ClassRealm)this.classRealm;
            realm.addURL(url);
        } else if (this.classRealm instanceof org.codehaus.classworlds.ClassRealm) {
            org.codehaus.classworlds.ClassRealm realm = (org.codehaus.classworlds.ClassRealm)this.classRealm;
            realm.addConstituent(url);
        }
    }

    public void execute() throws MojoExecutionException {
        Iterator<String> iter = this.additionalClasspathElements.iterator();
        while (iter.hasNext()) {
            URL url = null;
            try {
                url = new File(iter.next()).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(String.valueOf(e.getMessage()) + e);
            }
            this.getLog().info((CharSequence)("adding URL:" + url.toString()));
            this.addURL(url);
        }
        if (this.systemProperties != null) {
            Enumeration<?> names = this.systemProperties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = this.systemProperties.getProperty(name);
                this.getLog().debug((CharSequence)("system prop: " + name + ":" + value));
                System.setProperty(name, value);
            }
        }
    }
}

