/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.xml.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.List;
import org.plasma.xml.schema.LocalSimpleType;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.schema.SimpleTypeVisitor;
import org.plasma.xml.schema.Union;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="simpleType", propOrder={"union", "list", "restriction"})
public abstract class AbstractSimpleType
extends Annotated {
    private static Log log = LogFactory.getLog(AbstractSimpleType.class);
    protected Union union;
    protected List list;
    protected Restriction restriction;
    @XmlAttribute(name="final")
    @XmlSchemaType(name="simpleDerivationSet")
    protected java.util.List<String> finals;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NCName")
    protected String name;

    public Union getUnion() {
        return this.union;
    }

    public void setUnion(Union value) {
        this.union = value;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List value) {
        this.list = value;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Restriction value) {
        this.restriction = value;
    }

    public java.util.List<String> getFinals() {
        if (this.finals == null) {
            this.finals = new ArrayList<String>();
        }
        return this.finals;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void accept(SimpleTypeVisitor visitor) {
        this.accept(this, null, visitor, 0);
    }

    private void accept(AbstractSimpleType target, AbstractSimpleType source, SimpleTypeVisitor visitor, int level) {
        block10: {
            block11: {
                QName typeName;
                block12: {
                    block13: {
                        block6: {
                            Restriction restriction;
                            block7: {
                                QName typeName2;
                                block8: {
                                    block9: {
                                        visitor.visit(target, source, level);
                                        if (target.getRestriction() == null) break block6;
                                        restriction = target.getRestriction();
                                        typeName2 = restriction.getBase();
                                        if (typeName2 == null) break block7;
                                        if (typeName2.getNamespaceURI() == null) break block8;
                                        if (!typeName2.getNamespaceURI().equals(visitor.getTargetNamespace())) break block9;
                                        SimpleType baseType = visitor.getTopLevelSimpleType(typeName2);
                                        this.accept(baseType, target, visitor, level++);
                                        break block10;
                                    }
                                    if (typeName2.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) break block10;
                                    log.warn((Object)("could not process namespace URI found for base type, " + typeName2.toString()));
                                    break block10;
                                }
                                log.warn((Object)("could not process (no namespace) base type, " + typeName2.toString()));
                                break block10;
                            }
                            LocalSimpleType localSimpleType = restriction.getSimpleType();
                            if (localSimpleType != null) {
                                this.accept(localSimpleType, target, visitor, level++);
                            } else {
                                log.warn((Object)("no base type or local type found on restriction for type, " + target.getName()));
                            }
                            break block10;
                        }
                        if (target.getList() == null) break block11;
                        List typeList = target.getList();
                        if (typeList.getSimpleType() != null) {
                            log.warn((Object)("ignoring local simple type child for simple type, " + target.getName()));
                        }
                        if ((typeName = typeList.getItemType()) == null || typeName.getNamespaceURI() == null) break block12;
                        if (!typeName.getNamespaceURI().equals(visitor.getTargetNamespace())) break block13;
                        SimpleType baseType = visitor.getTopLevelSimpleType(typeName);
                        this.accept(baseType, target, visitor, level++);
                        break block10;
                    }
                    if (typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) break block10;
                    log.warn((Object)("could not process namespace URI found for type, " + typeName.toString()));
                    break block10;
                }
                log.warn((Object)("no namespace URI found for type, " + typeName.toString()));
                break block10;
            }
            if (target.getUnion() != null) {
                Union union = target.getUnion();
                for (QName member : union.getMemberTypes()) {
                    SimpleType baseType = visitor.getTopLevelSimpleType(member);
                    this.accept(baseType, target, visitor, level++);
                }
                for (LocalSimpleType localBaseType : union.getSimpleTypes()) {
                    this.accept(localBaseType, target, visitor, level++);
                }
            }
        }
    }
}

