//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.annotation;







import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
* 
* This stereotype provides modelling-context specific alternative names for UML named elements within a model. While a UML logical model often differs greatly from a physical model for example, the intent is to provide enough naming and other context specific information to make the physical model entirely reflective or derivitive of the UML logical model. In other words support the generation of multiple context-specific models from a single UML logical model. Modelling context specific names or aliases are particularly important as they often differ greatly between modelling contexts due to various standard naming conventions or technology limitations such as name length.
* 
* @author Plasma-Team
* @version 1.2.5
*/
@Retention(RetentionPolicy.RUNTIME)
public @interface Alias{


    /**
    * Associates a given UML element with a physical data store element. Where the physical data store is a relational database, this tag contains the name of a relational database table, schema, column or other relational database element.
    */
    public String physicalName() default "";

    /**
    * Associates a given UML element with a data transfer or transient storage element. Where the transfer medium is XML, this tag contains the name of an XML element or attribute.
    */
    public String localName() default "";

    /**
    * Associates a given UML element with a business specific, human readable name.
    */
    public String businessName() default "";
}
