//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.annotation;




import org.plasma.sdo.profile.ConcurrencyType;

import org.plasma.sdo.profile.ConcurrentDataFlavor;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
* 
* Annotates or tags properties as applicable for use within various operations involving concurrency control. Concurrency control deals with handling collisions and other issues which arise when allowing multiple users or processes simultaneous access to shared entities within a data store. Generic SDO Data Access Services (DAS) are faced with the problem of determining at runtime for any data-object within a modified data-graph, which properties are useful for various checks and operations under a particular concurrency control type or strategy. Properties tagged as concurrent at the model level are made available to Data Access Services within the PlasmaSDOâ„¢ runtime and build-time environments.
* 
* @author Plasma-Team
* @version 1.2.5
*/
@Retention(RetentionPolicy.RUNTIME)
public @interface Concurrent{


    /**
    * Specifies the general category of concurrency or concurrency control under which a property participates
    */
    public ConcurrencyType type();

    /**
    * Denotes or provides a hint as to the nature of the data instructive to vaious checks and operations under a particular concurrency control type or category.
    */
    public ConcurrentDataFlavor dataFlavor();
}
