//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.annotation;



import org.plasma.sdo.profile.KeyType;





import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
* 
* This stereotype tags or annotates a UML property as representing some type of key within a data store, data transfer or transient storage medium.
* 
* @author Plasma-Team
* @version 1.2.8
*/
@Retention(RetentionPolicy.RUNTIME)
public @interface Key{

    /**
    * Specifies the type of key
    */
    public KeyType type();


    /**
    * Links a property element which supplies the actual data for the key where multiple possible targets exist. Where a key property is a reference SDO property and the target entity has multiple primary keys, the supplier is used by services to disambiguate which target key actually supplies the data.
    */

    /**
    * The key set or constraint name
    */
    public String group() default "";

    /**
    * The position or ordering of a key within a group
    */
    public int sequence() default 0;
}
