//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.annotation;









import org.plasma.sdo.profile.CodingStrength;




import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
* 
* This stereotype allows a value set constraint to be specified for a class attribute. Attributes that have a coded type may be constrained such that the code value in an instance should be taken from the specified value set. The coding strength determines whether exceptions are allowed.
* 
* @author Plasma-Team
* @version 1.3.2
*/
@Retention(RetentionPolicy.RUNTIME)
public @interface ValueSetConstraint{


    /**
    * The globally unique identifier for the value set
    */
    public String id() default "";

    /**
    * The descriptive name associated with the value set
    */
    public String name() default "";

    /**
    * The value which identifies a specific version of the value set. Used when performing static references to a value set
    */
    public String versionIdentifier() default "";

    /**
    * The date on which a specific version of the value set was created. Used when performing static references to a value set
    */
    public String versionDate() default "";

    /**
    * The time when a specific version of the value set was created. Used when performing static references to a value set
    */
    public String versionTime() default "";

    /**
    * Indicates whether or not codes are restricted to those expressed in the value set
    */
    public CodingStrength codingStrength();

    /**
    * Defines the set of codes within the overall value set that must be supported by an implementer to be considered compliant
    */
    public String minimumValueSetId() default "";

    /**
    * Defines the set of codes within the overall value set that the implementer is willing to accept without raising an error, but whose content will be ignored and not processed in any useful manner
    */
    public String ignoredValueSetId() default "";

    /**
    * Allows conveying the root code of the value set. Only usable for key structural attributes.
    */
    public String rootCode() default "";
}
