//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.profile;


import fUML.Syntax.Classes.Kernel.*;
import org.modeldriven.fuml.repository.ext.Stereotype;
import org.plasma.sdo.Alias;
/**
* 
* This stereotype provides modelling-context specific alternative names for UML named elements within a model. While a UML logical model often differs greatly from a physical model for example, the intent is to provide enough naming and other context specific information to make the physical model entirely reflective or derivitive of the UML logical model. In other words support the generation of multiple context-specific models from a single UML logical model. Modelling context specific names or aliases are particularly important as they often differ greatly between modelling contexts due to various standard naming conventions or technology limitations such as name length.
* 
* @author Plasma-Team
* @version 1.3.2
*/
public class SDOAlias extends Stereotype
    implements Alias
{

    public static final String BASE__NAMED_ELEMENT = "base_NamedElement";
    /**
    * Associates a given UML element with a physical data store element. Where the physical data store is a relational database, this tag contains the name of a relational database table, schema, column or other relational database element.
    */
    public static final String PHYSICAL_NAME = "physicalName";
    /**
    * Associates a given UML element with a data transfer or transient storage element. Where the transfer medium is XML, this tag contains the name of an XML element or attribute.
    */
    public static final String LOCAL_NAME = "localName";
    /**
    * Associates a given UML element with a business specific, human readable name.
    */
    public static final String BUSINESS_NAME = "businessName";

    private NamedElement base_NamedElement;
    /**
    * Associates a given UML element with a physical data store element. Where the physical data store is a relational database, this tag contains the name of a relational database table, schema, column or other relational database element.
    */
    private String physicalName;
    /**
    * Associates a given UML element with a data transfer or transient storage element. Where the transfer medium is XML, this tag contains the name of an XML element or attribute.
    */
    private String localName;
    /**
    * Associates a given UML element with a business specific, human readable name.
    */
    private String businessName;


    public NamedElement getBase_NamedElement() {
        return this.base_NamedElement;
    }

    public void setBase_NamedElement(NamedElement value) {
        this.base_NamedElement = value;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String value) {
        this.physicalName = value;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String value) {
        this.localName = value;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String value) {
        this.businessName = value;
    }
}
