/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.naming;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.plasma.common.env.EnvProperties;

public class InitialContextFactory {
    public static String DEFAULT_JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String DPS_NAMING_URL = "dps.jndi.naming.provider.url";
    private static InitialContextFactory contextFactory = new InitialContextFactory();

    public static InitialContextFactory getInstance() {
        return contextFactory;
    }

    private InitialContextFactory() {
    }

    public InitialContext getInitialContext(String namingUrl) throws NamingException {
        if (namingUrl == null) {
            throw new RuntimeException("dps.jndi.naming.provider.url is a required.");
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", DEFAULT_JNDI_FACTORY);
        env.put("java.naming.provider.url", namingUrl);
        return new InitialContext(env);
    }

    public InitialContext getInitialContext() throws NamingException {
        String namingUrl = EnvProperties.instance().getProperty(DPS_NAMING_URL);
        if (namingUrl == null) {
            throw new RuntimeException("The following required property is missing: 'dps.jndi.naming.provider.url':" + EnvProperties.instance().dumpProperties("\n    "));
        }
        return this.getInitialContext(namingUrl);
    }
}

