/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning;

import commonj.sdo.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.NonExistantNamespaceException;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Alias;
import org.plasma.provisioning.Body;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.ConcurentDataFlavor;
import org.plasma.provisioning.ConcurrencyType;
import org.plasma.provisioning.Concurrent;
import org.plasma.provisioning.DataTypeRef;
import org.plasma.provisioning.Derivation;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.DocumentationType;
import org.plasma.provisioning.Enumeration;
import org.plasma.provisioning.EnumerationConstraint;
import org.plasma.provisioning.EnumerationLiteral;
import org.plasma.provisioning.EnumerationRef;
import org.plasma.provisioning.Key;
import org.plasma.provisioning.KeyType;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.PackageRef;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.Sort;
import org.plasma.provisioning.ValueConstraint;
import org.plasma.provisioning.VisibilityType;
import org.plasma.provisioning.XmlNodeType;
import org.plasma.provisioning.XmlProperty;
import org.plasma.query.Query;
import org.plasma.query.collector.PropertySelection;
import org.plasma.query.collector.PropertySelectionCollector;
import org.plasma.query.model.Select;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.SDOAlias;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.PlasmaRepository;

public class ProvisioningModelAssembler {
    private static Log log = LogFactory.getLog(ProvisioningModelAssembler.class);
    private Model model;
    private List<Namespace> namespaces;
    private Map<String, Package> packageMap = new HashMap<String, Package>();
    private Map<String, Class> classMap = new HashMap<String, Class>();
    private Map<String, Enumeration> enumerationMap = new HashMap<String, Enumeration>();
    private String destNamespaceURI;
    private DataAccessProviderName serviceName;

    public ProvisioningModelAssembler() {
        this(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public ProvisioningModelAssembler(DataAccessProviderName serviceName) {
        this.serviceName = serviceName;
        this.construct(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public ProvisioningModelAssembler(List<Namespace> namespaces) {
        this.construct(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public ProvisioningModelAssembler(Query query, String destNamespaceURI, String destNamespacePrefix) {
        this.construct(query, destNamespaceURI, destNamespacePrefix);
    }

    private void construct(List<Namespace> namespaces) {
        this.namespaces = namespaces;
        this.model = new Model();
        for (Namespace namespace : this.namespaces) {
            log.debug((Object)("processing namespace: " + namespace.getUri()));
            if (this.serviceName != null) {
                try {
                    PlasmaConfig.getInstance().getProvisioningByNamespaceURI(this.serviceName, namespace.getUri());
                }
                catch (NonExistantNamespaceException e) {
                    log.debug((Object)("ignoring non " + this.serviceName.name() + " namespace: " + namespace.getUri()));
                    continue;
                }
            }
            List<Type> types = PlasmaTypeHelper.INSTANCE.getTypes(namespace.getUri());
            for (Type type : types) {
                String qualifiedName;
                Class clss;
                PlasmaType plasmaType = (PlasmaType)type;
                Package pkg = this.packageMap.get(plasmaType.getURI());
                if (pkg == null) {
                    pkg = this.createPackage(namespace, plasmaType);
                    this.packageMap.put(plasmaType.getURI(), pkg);
                }
                if ((clss = this.classMap.get(qualifiedName = plasmaType.getURI() + "#" + plasmaType.getName())) != null) continue;
                log.debug((Object)("processing type: " + qualifiedName));
                clss = this.createClass(pkg, plasmaType);
                assert (clss.getUri().equals(pkg.getUri()));
                this.classMap.put(qualifiedName, clss);
                this.createEnumerations(pkg, clss, plasmaType);
            }
        }
        for (Class clss : this.classMap.values()) {
            PlasmaType sdoType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(clss.getUri(), clss.getName());
            Package pkg = this.packageMap.get(sdoType.getURI());
            List<commonj.sdo.Property> properties = sdoType.getDeclaredProperties();
            this.createFields(pkg, clss, properties);
        }
    }

    private void construct(Query query, String destNamespaceURI, String destNamespacePrefix) {
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument 'destNamespaceURI'");
        }
        this.destNamespaceURI = destNamespaceURI;
        this.model = new Model();
        this.model.setId(UUID.randomUUID().toString());
        this.model.setUri(destNamespaceURI);
        this.model.setName(query.getName());
        Derivation derivation = new Derivation();
        PackageRef packageRef = new PackageRef();
        packageRef.setName(query.getName());
        packageRef.setUri(query.getFromClause().getUri());
        derivation.setPackageSupplier(packageRef);
        this.model.setDerivation(derivation);
        PlasmaType rootType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(query.getFromClause().getUri(), query.getFromClause().getName());
        ClassRef rootClass = new ClassRef();
        rootClass.setName(rootType.getName());
        rootClass.setUri(rootType.getURI());
        this.model.setRootClass(rootClass);
        PropertySelectionCollector collector = new PropertySelectionCollector((Select)query.getSelectClause(), rootType);
        Map<Type, List<String>> queryPropertyMap = collector.getResult();
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            Class clazz = this.createClass(this.model, plasmaType);
            this.classMap.put(destNamespaceURI + "#" + clazz.getName(), clazz);
        }
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            this.constructBaseTypes(query, plasmaType, collector, queryPropertyMap);
        }
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            PlasmaProperty plasmaProperty;
            List<String> list = queryPropertyMap.get(plasmaType);
            Class clss = this.classMap.get(destNamespaceURI + "#" + plasmaType.getName());
            for (commonj.sdo.Property p : plasmaType.getDeclaredProperties()) {
                plasmaProperty = (PlasmaProperty)p;
                if (!plasmaProperty.getType().isDataType() || !list.contains(plasmaProperty.getName())) continue;
                Property field = this.createDataProperty(this.model, clss, plasmaProperty);
                Sort sequence = new Sort();
                sequence.setKey(String.valueOf(list.indexOf(plasmaProperty.getName())));
                field.setSort(sequence);
                clss.getProperties().add(field);
            }
            for (commonj.sdo.Property p2 : plasmaType.getDeclaredProperties()) {
                PlasmaType oppositeType;
                plasmaProperty = (PlasmaProperty)p2;
                if (plasmaProperty.getType().isDataType() || !list.contains(plasmaProperty.getName())) continue;
                PlasmaProperty oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite();
                Property field = null;
                field = oppositeProperty != null ? (collector.hasProperty(oppositeType = (PlasmaType)plasmaProperty.getType(), oppositeProperty) ? this.createReferenceProperty(this.model, clss, plasmaProperty, oppositeProperty) : (plasmaProperty.isMany() ? this.createReferenceProperty(this.model, clss, plasmaProperty, oppositeProperty) : this.createReferenceProperty(this.model, clss, plasmaProperty, null))) : this.createReferenceProperty(this.model, clss, plasmaProperty, null);
                Sort sequence = new Sort();
                sequence.setKey(String.valueOf(list.indexOf(plasmaProperty.getName())));
                field.setSort(sequence);
                clss.getProperties().add(field);
            }
            this.constructImplicitDatatypeProperties(query, plasmaType, clss, list);
            this.constructImplicitReferenceProperties(query, plasmaType, clss, collector, list);
        }
    }

    public Model getModel() {
        return this.model;
    }

    private void constructBaseTypes(Query query, Type sdoType, PropertySelection collector, Map<Type, List<String>> queryPropertyMap) {
        for (Type base : sdoType.getBaseTypes()) {
            PlasmaType sdoBaseType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(base.getURI(), base.getName());
            Class existing = this.classMap.get(this.destNamespaceURI + "#" + base.getName());
            if (existing == null) {
                Class baseClss = this.createClass(this.model, (PlasmaType)base);
                this.classMap.put(this.destNamespaceURI + "#" + baseClss.getName(), baseClss);
                List<String> baseList = queryPropertyMap.get(base.getURI() + "#" + base.getName());
                this.constructImplicitDatatypeProperties(query, sdoBaseType, baseClss, baseList);
                this.constructImplicitReferenceProperties(query, sdoBaseType, baseClss, collector, baseList);
            }
            this.constructBaseTypes(query, sdoBaseType, collector, queryPropertyMap);
        }
    }

    private void constructImplicitDatatypeProperties(Query query, PlasmaType sdoType, Class clss, List<String> list) {
        for (commonj.sdo.Property p : sdoType.getDeclaredProperties()) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)p;
            if (!plasmaProperty.getType().isDataType() || list != null && list.contains(plasmaProperty.getName()) || plasmaProperty.getKey() == null && plasmaProperty.getConcurrent() == null) continue;
            Property field = this.createDataProperty(this.model, clss, plasmaProperty);
            field.setVisibility(VisibilityType.PRIVATE);
            field.setNullable(true);
            Sort sequence = new Sort();
            sequence.setKey(String.valueOf(clss.getProperties().size()));
            field.setSort(sequence);
            clss.getProperties().add(field);
        }
    }

    private void constructImplicitReferenceProperties(Query query, PlasmaType sdoType, Class clss, PropertySelection collector, List<String> list) {
        for (commonj.sdo.Property p2 : sdoType.getDeclaredProperties()) {
            PlasmaType oppositeType;
            PlasmaProperty oppositeProperty;
            PlasmaProperty plasmaProperty = (PlasmaProperty)p2;
            if (plasmaProperty.getType().isDataType() || list != null && list.contains(plasmaProperty.getName()) || (oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite()) == null || plasmaProperty.isMany() || !collector.hasProperty(oppositeType = (PlasmaType)plasmaProperty.getType(), oppositeProperty)) continue;
            String oppositeQualName = this.destNamespaceURI + "#" + oppositeType.getName();
            Class oppositeClass = this.classMap.get(oppositeQualName);
            if (oppositeClass == null) {
                throw new IllegalStateException("could not find class, " + oppositeQualName);
            }
            Property property = this.createReferenceProperty(this.model, clss, plasmaProperty, oppositeProperty);
            property.setVisibility(VisibilityType.PRIVATE);
            Sort sequence = new Sort();
            sequence.setKey(String.valueOf(clss.getProperties().size()));
            property.setSort(sequence);
            clss.getProperties().add(property);
        }
    }

    private void createFields(Package pkg, Class clss, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null && !plasmaProperty.isMany()) {
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
            }
            Property field = null;
            if (plasmaProperty.getType().isDataType()) {
                field = this.createDataProperty(pkg, clss, plasmaProperty);
            } else {
                PlasmaProperty oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite();
                field = this.createReferenceProperty(pkg, clss, plasmaProperty, oppositeProperty);
            }
            clss.getProperties().add(field);
        }
    }

    private void createEnumerations(Package pkg, Class clss, PlasmaType sdoType) {
        List<commonj.sdo.Property> properties = sdoType.getDeclaredProperties();
        for (commonj.sdo.Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null) {
                if (plasmaProperty.isMany()) continue;
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
                continue;
            }
            if (!plasmaProperty.getType().isDataType() || plasmaProperty.getRestriction() == null) continue;
            org.plasma.sdo.repository.Enumeration sdoEnumeration = plasmaProperty.getRestriction();
            String enumKey = clss.getUri() + "#" + sdoEnumeration.getName();
            Enumeration enumeration = this.enumerationMap.get(enumKey);
            if (enumeration != null) continue;
            enumeration = this.createEnumeration(clss, sdoEnumeration);
            pkg.getEnumerations().add(enumeration);
            this.enumerationMap.put(enumKey, enumeration);
        }
    }

    private Enumeration createEnumeration(Class clss, org.plasma.sdo.repository.Enumeration sdoEnum) {
        Enumeration enumeration = new Enumeration();
        enumeration.setName(sdoEnum.getName());
        enumeration.setUri(clss.getUri());
        enumeration.setId(UUID.randomUUID().toString());
        if (sdoEnum.findAlias() != null) {
            SDOAlias sdoAlias = sdoEnum.findAlias();
            Alias alias = new Alias();
            enumeration.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (org.plasma.sdo.repository.EnumerationLiteral lit : sdoEnum.getOwnedLiteral()) {
            EnumerationLiteral literal = new EnumerationLiteral();
            literal.setName(lit.getName());
            literal.setValue(lit.getName());
            if (lit.findAlias() != null) {
                SDOAlias sdoAlias = lit.findAlias();
                Alias alias = new Alias();
                literal.setAlias(alias);
                alias.setPhysicalName(sdoAlias.getPhysicalName());
                alias.setLocalName(sdoAlias.getLocalName());
                alias.setBusinessName(sdoAlias.getBusinessName());
            }
            if (lit.getComments() != null && lit.getComments().size() > 0) {
                for (Comment comment : lit.getComments()) {
                    Documentation documentation = new Documentation();
                    documentation.setType(DocumentationType.DEFINITION);
                    Body body = new Body();
                    body.setValue(comment.getBody());
                    documentation.setBody(body);
                    literal.getDocumentations().add(documentation);
                }
            }
            enumeration.getEnumerationLiterals().add(literal);
        }
        return enumeration;
    }

    private Property createDataProperty(Package pkg, Class clss, PlasmaProperty sourceProperty) {
        org.plasma.sdo.repository.Enumeration sdoEnum;
        Property property = this.createProperty(pkg, clss, sourceProperty);
        if (!sourceProperty.getType().isDataType()) {
            throw new IllegalArgumentException("given property is not a data property, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        }
        DataType sdoType = DataType.valueOf(sourceProperty.getType().getName());
        DataTypeRef type = this.createDatatype(sdoType.name());
        property.setType(type);
        if (sourceProperty.getKey() != null) {
            org.plasma.sdo.Key sdoKey = sourceProperty.getKey();
            Key key = new Key();
            key.setType(KeyType.valueOf(sdoKey.getType().name().toUpperCase()));
            property.setKey(key);
        }
        if (sourceProperty.getConcurrent() != null) {
            org.plasma.sdo.Concurrent sdoConcurrent = sourceProperty.getConcurrent();
            Concurrent conc = new Concurrent();
            conc.setType(ConcurrencyType.valueOf(sdoConcurrent.getType().name().toUpperCase()));
            conc.setDataFlavor(ConcurentDataFlavor.valueOf(sdoConcurrent.getDataFlavor().name().toUpperCase()));
            property.setConcurrent(conc);
        }
        if (sourceProperty.getXmlProperty() != null) {
            org.plasma.sdo.XmlProperty sdoXmlProperty = sourceProperty.getXmlProperty();
            XmlProperty xmlProp = new XmlProperty();
            xmlProp.setNodeType(XmlNodeType.valueOf(sdoXmlProperty.getNodeType().name().toUpperCase()));
            property.setXmlProperty(xmlProp);
        }
        if (sourceProperty.getValueConstraint() != null) {
            org.plasma.sdo.ValueConstraint sdoValConst = sourceProperty.getValueConstraint();
            ValueConstraint valueConstraint = new ValueConstraint();
            if (sdoValConst.getFractionDigits() != null) {
                valueConstraint.setFractionDigits(sdoValConst.getFractionDigits());
            }
            if (sdoValConst.getMaxExclusive() != null) {
                valueConstraint.setMaxExclusive(sdoValConst.getMaxExclusive());
            }
            if (sdoValConst.getMaxInclusive() != null) {
                valueConstraint.setMaxInclusive(sdoValConst.getMaxInclusive());
            }
            if (sdoValConst.getMaxLength() != null) {
                valueConstraint.setMaxLength(sdoValConst.getMaxLength());
            }
            if (sdoValConst.getMinExclusive() != null) {
                valueConstraint.setMinExclusive(sdoValConst.getMinExclusive());
            }
            if (sdoValConst.getMinInclusive() != null) {
                valueConstraint.setMinInclusive(sdoValConst.getMinInclusive());
            }
            if (sdoValConst.getMinLength() != null) {
                valueConstraint.setMinLength(sdoValConst.getMinLength());
            }
            if (sdoValConst.getPattern() != null) {
                valueConstraint.setPattern(sdoValConst.getPattern());
            }
            property.setValueConstraint(valueConstraint);
        }
        if ((sdoEnum = sourceProperty.getRestriction()) != null) {
            String enumKey = clss.getUri() + "#" + sdoEnum.getName();
            Enumeration enumeration = this.enumerationMap.get(enumKey);
            if (enumeration == null) {
                enumeration = this.createEnumeration(clss, sdoEnum);
                pkg.getEnumerations().add(enumeration);
                this.enumerationMap.put(enumKey, enumeration);
            }
            EnumerationConstraint enumConstraint = new EnumerationConstraint();
            EnumerationRef enumRef = new EnumerationRef();
            enumRef.setName(enumeration.getName());
            enumRef.setUri(enumeration.getUri());
            enumConstraint.setValue(enumRef);
            property.setEnumerationConstraint(enumConstraint);
        }
        return property;
    }

    private Property createReferenceProperty(Package pkg, Class clss, PlasmaProperty sourceProperty, PlasmaProperty oppositeProperty) {
        Property property = this.createProperty(pkg, clss, sourceProperty);
        if (!sourceProperty.getType().isDataType()) {
            String qualifiedName = null;
            qualifiedName = this.destNamespaceURI != null ? this.destNamespaceURI + "#" + sourceProperty.getType().getName() : sourceProperty.getType().getURI() + "#" + sourceProperty.getType().getName();
            Class propertyClass = this.classMap.get(qualifiedName);
            if (propertyClass == null) {
                throw new ProvisioningException("could not find class, " + qualifiedName);
            }
            ClassRef ref = new ClassRef();
            ref.setName(propertyClass.getName());
            ref.setUri(propertyClass.getUri());
            property.setType(ref);
            if (oppositeProperty != null) {
                property.setOpposite(oppositeProperty.getName());
            }
        } else {
            throw new IllegalArgumentException("given property is not a reference property, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        }
        return property;
    }

    private Property createProperty(Package pkg, Class clss, PlasmaProperty sourceProperty) {
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        property.setName(sourceProperty.getName());
        property.setNullable(sourceProperty.isNullable());
        property.setReadOnly(sourceProperty.isReadOnly());
        property.setMany(sourceProperty.isMany());
        property.setVisibility(VisibilityType.PUBLIC);
        if (sourceProperty.getAlias() != null) {
            org.plasma.sdo.Alias sdoAlias = sourceProperty.getAlias();
            Alias alias = new Alias();
            property.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        if (sourceProperty.getSort() != null) {
            org.plasma.sdo.Sort sdoSort = sourceProperty.getSort();
            Sort sequence = new Sort();
            sequence.setKey(sdoSort.getKey());
            property.setSort(sequence);
        }
        if (sourceProperty.getDescription() != null && sourceProperty.getDescription().size() > 0) {
            for (Comment comment : sourceProperty.getDescription()) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(comment.getBody());
                documentation.setBody(body);
                property.getDocumentations().add(documentation);
            }
        }
        return property;
    }

    private DataTypeRef createDatatype(String name) {
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(name);
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDO().getDefaultNamespace().getUri());
        return dataTypeRef;
    }

    private Package createPackage(Namespace namespace, PlasmaType type) {
        Package pkg = new Package();
        pkg.setName(namespace.getName());
        pkg.setId(UUID.randomUUID().toString());
        if (namespace.findAlias() != null) {
            SDOAlias sdoAlias = namespace.findAlias();
            Alias alias = new Alias();
            pkg.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (Comment cmt : namespace.getComments()) {
            Documentation doc = new Documentation();
            doc.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            body.setValue(cmt.getBody());
            doc.setBody(body);
            pkg.getDocumentations().add(doc);
        }
        this.model.getPackages().add(pkg);
        pkg.setUri(type.getURI());
        return pkg;
    }

    private Class createClass(Package pkg, PlasmaType plasmaType) {
        Class clss = new Class();
        pkg.getClazzs().add(clss);
        clss.setId(UUID.randomUUID().toString());
        clss.setName(plasmaType.getName());
        clss.setUri(plasmaType.getURI());
        clss.setAbstract(plasmaType.isAbstract());
        if (plasmaType.getPhysicalName() != null) {
            Alias alias = new Alias();
            clss.setAlias(alias);
            alias.setPhysicalName(plasmaType.getPhysicalName());
        }
        if (plasmaType.getAlias() != null) {
            org.plasma.sdo.Alias sdoAlias = plasmaType.getAlias();
            Alias alias = new Alias();
            clss.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (Type baseType : plasmaType.getBaseTypes()) {
            ClassRef ref = new ClassRef();
            ref.setName(baseType.getName());
            ref.setUri(baseType.getURI());
            clss.getSuperClasses().add(ref);
        }
        if (plasmaType.getDescription() != null && plasmaType.getDescription().size() > 0) {
            for (Comment comment : plasmaType.getDescription()) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(comment.getBody());
                documentation.setBody(body);
                clss.getDocumentations().add(documentation);
            }
        }
        return clss;
    }
}

