/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.plasma.provisioning.EnumerationConstraint;
import org.plasma.provisioning.ValueConstraint;
import org.plasma.provisioning.xsd.AbstractCollector;
import org.plasma.provisioning.xsd.ConstraintAssembler;
import org.plasma.provisioning.xsd.SimpleTypeUtils;
import org.plasma.xml.schema.AbstractSimpleType;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.schema.SimpleTypeVisitor;

public class ConstraintCollector
extends AbstractCollector
implements SimpleTypeVisitor {
    private Schema schema;
    private Map<String, SimpleType> simpleTypeMap;
    private ConstraintAssembler assembler;
    private List<EnumerationConstraint> enumerationConstraints = new ArrayList<EnumerationConstraint>();
    private List<ValueConstraint> valueConstraints = new ArrayList<ValueConstraint>();

    public ConstraintCollector(Schema schema, Map<String, SimpleType> simpleTypeMap, ConstraintAssembler assembler) {
        this.schema = schema;
        this.simpleTypeMap = simpleTypeMap;
        this.assembler = assembler;
    }

    public List<EnumerationConstraint> getEnumerationConstraints() {
        return this.enumerationConstraints;
    }

    public List<ValueConstraint> getValueConstraints() {
        return this.valueConstraints;
    }

    @Override
    public void visit(AbstractSimpleType target, AbstractSimpleType source, int level) {
        if (target.getRestriction() != null) {
            if (SimpleTypeUtils.isEnumeration(target)) {
                EnumerationConstraint constraint = this.assembler.buildEnumerationConstraint(target, source);
                this.enumerationConstraints.add(constraint);
            } else {
                ValueConstraint constraint = this.assembler.buildValueConstraint(target);
                this.valueConstraints.add(constraint);
            }
        }
    }

    @Override
    public SimpleType getTopLevelSimpleType(QName name) {
        return this.simpleTypeMap.get(name.getLocalPart());
    }

    @Override
    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }
}

