/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.collector;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.plasma.query.InvalidPathPredicateException;
import org.plasma.query.QueryException;
import org.plasma.query.collector.CollectorSupport;
import org.plasma.query.collector.Selection;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Select;
import org.plasma.query.model.Where;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.sdo.PlasmaType;

public class SelectionCollector
extends CollectorSupport
implements Selection {
    private static Set<Property> EMPTY_PROPERTY_SET = new HashSet<Property>();
    private Select select;
    private Where where;
    private Map<Property, Where> predicateMap;
    private Map<Type, Set<Property>> propertyMap;
    private Map<Type, Set<Property>> singularPropertyMap;
    private Map<Type, Set<Property>> inheritedPropertyMap;
    private Map<Property, Map<Integer, Where>> predicateLevelMap;
    private Map<Type, Map<Integer, Set<Property>>> propertyLevelMap;
    private Map<Type, Map<Integer, Set<Property>>> singularPropertyLevelMap;
    private Map<Type, Map<Integer, Set<Property>>> inheritedPropertyLevelMap;
    private Map<Property, Map<Property, Where>> predicateEdgeMap;
    private Map<Type, Map<Property, Set<Property>>> propertyEdgeMap;
    private Map<Type, Map<Property, Set<Property>>> singularPropertyEdgeMap;
    private Map<Type, Map<Property, Set<Property>>> inheritedPropertyEdgeMap;

    public SelectionCollector(Select select, Type rootType) {
        super(rootType);
        this.select = select;
    }

    public SelectionCollector(Select select, Type rootType, boolean onlySingularProperties) {
        super(rootType, onlySingularProperties);
        this.select = select;
    }

    public SelectionCollector(Select select, Where where, Type rootType) {
        super(rootType);
        this.select = select;
        this.where = where;
    }

    public SelectionCollector(Select select, Where where, Type rootType, boolean onlySingularProperties) {
        super(rootType, onlySingularProperties);
        this.select = select;
        this.where = where;
    }

    public SelectionCollector(Where where, Type rootType) {
        super(rootType);
        this.where = where;
    }

    public SelectionCollector(Where where, Type rootType, boolean onlySingularProperties) {
        super(rootType, onlySingularProperties);
        this.where = where;
    }

    private boolean initialized() {
        return this.propertyMap != null;
    }

    private void init() {
        if (!this.initialized()) {
            DefaultQueryVisitor visitor;
            this.propertyMap = new HashMap<Type, Set<Property>>();
            this.singularPropertyMap = new HashMap<Type, Set<Property>>();
            this.inheritedPropertyMap = new HashMap<Type, Set<Property>>();
            this.predicateMap = new HashMap<Property, Where>();
            this.propertyLevelMap = new HashMap<Type, Map<Integer, Set<Property>>>();
            this.singularPropertyLevelMap = new HashMap<Type, Map<Integer, Set<Property>>>();
            this.inheritedPropertyLevelMap = new HashMap<Type, Map<Integer, Set<Property>>>();
            this.predicateLevelMap = new HashMap<Property, Map<Integer, Where>>();
            this.propertyEdgeMap = new HashMap<Type, Map<Property, Set<Property>>>();
            this.singularPropertyEdgeMap = new HashMap<Type, Map<Property, Set<Property>>>();
            this.inheritedPropertyEdgeMap = new HashMap<Type, Map<Property, Set<Property>>>();
            this.predicateEdgeMap = new HashMap<Property, Map<Property, Where>>();
            if (this.select != null) {
                visitor = new DefaultQueryVisitor(){

                    @Override
                    public void start(org.plasma.query.model.Property property) {
                        SelectionCollector.this.collect(property);
                        super.start(property);
                    }

                    @Override
                    public void start(WildcardProperty wildcardProperty) {
                        SelectionCollector.this.collect(wildcardProperty);
                        super.start(wildcardProperty);
                    }
                };
                this.select.accept(visitor);
            }
            if (this.where != null) {
                visitor = new DefaultQueryVisitor(){

                    @Override
                    public void start(org.plasma.query.model.Property property) {
                        SelectionCollector.this.collect(property);
                        super.start(property);
                    }

                    @Override
                    public void start(WildcardProperty wildcardProperty) {
                        SelectionCollector.this.collect(wildcardProperty);
                        super.start(wildcardProperty);
                    }
                };
                this.where.accept(visitor);
            }
        }
    }

    @Deprecated
    public Map<Property, Where> getPredicateMap() {
        if (!this.initialized()) {
            this.init();
        }
        return this.predicateMap;
    }

    @Override
    public boolean hasPredicates() {
        if (!this.initialized()) {
            this.init();
        }
        if (this.predicateMap == null) {
            return false;
        }
        return this.predicateMap.size() > 0;
    }

    @Override
    public Where getPredicate(Property property) {
        if (!this.initialized()) {
            this.init();
        }
        if (this.predicateMap != null) {
            return this.predicateMap.get(property);
        }
        return null;
    }

    @Override
    public Set<Property> getSingularProperties(Type type) {
        Set<Property> result;
        if (!this.initialized()) {
            this.init();
        }
        if ((result = this.singularPropertyMap.get(type)) != null) {
            return result;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getProperties(Type type) {
        Set<Property> result;
        if (!this.initialized()) {
            this.init();
        }
        if ((result = this.propertyMap.get(type)) != null) {
            return result;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getInheritedProperties(Type type) {
        Set<Property> result;
        if (!this.initialized()) {
            this.init();
        }
        if ((result = this.inheritedPropertyMap.get(type)) != null) {
            return result;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getInheritedProperties(Type type, Property sourceProperty) {
        Set<Property> set;
        Map<Property, Set<Property>> edgeMap;
        if (!this.initialized()) {
            this.init();
        }
        if ((edgeMap = this.inheritedPropertyEdgeMap.get(type)) != null && (set = edgeMap.get(sourceProperty)) != null) {
            return set;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getInheritedProperties(Type type, int level) {
        Set<Property> set;
        Map<Integer, Set<Property>> levelMap;
        if (!this.initialized()) {
            this.init();
        }
        if ((levelMap = this.inheritedPropertyLevelMap.get(type)) != null && (set = levelMap.get(level)) != null) {
            return set;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getInheritedProperties(Type type, Property sourceProperty, int level) {
        HashSet<Property> result = new HashSet<Property>();
        Set<Property> levelProps = this.getInheritedProperties(type, level);
        Set<Property> edgeProps = this.getInheritedProperties(type, sourceProperty);
        for (Property p : levelProps) {
            if (!edgeProps.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    public List<Type> getTypes() {
        if (!this.initialized()) {
            this.init();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        result.addAll(this.propertyMap.keySet());
        result.addAll(this.inheritedPropertyMap.keySet());
        return result;
    }

    @Override
    public boolean hasType(Type type) {
        if (!this.initialized()) {
            this.init();
        }
        return this.propertyMap.get(type) != null;
    }

    @Override
    public List<Type> getInheritedTypes() {
        if (!this.initialized()) {
            this.init();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        result.addAll(this.inheritedPropertyMap.keySet());
        return result;
    }

    @Override
    public boolean hasInheritedType(Type type) {
        if (!this.initialized()) {
            this.init();
        }
        return this.inheritedPropertyMap.get(type) != null;
    }

    @Override
    public boolean hasProperty(Type type, Property property) {
        Set<Property> props;
        if (!this.initialized()) {
            this.init();
        }
        return (props = this.propertyMap.get(type)) != null && props.size() > 0 && props.contains(property);
    }

    @Override
    public List<Type> addProperty(Type rootType, String path) {
        ArrayList<Type> result = new ArrayList<Type>();
        Type contextType = rootType;
        StringBuilder buf = new StringBuilder();
        String[] tokens = path.split("/");
        for (int i = 0; i < tokens.length; ++i) {
            int attr;
            String token;
            int right;
            if (i > 0) {
                buf.append("/");
            }
            if ((right = (token = tokens[i]).indexOf("[")) >= 0) {
                token = token.substring(0, right);
            }
            if ((attr = token.indexOf("@")) == 0) {
                token = token.substring(1);
            }
            Property prop = contextType.getProperty(token);
            this.addProperty(contextType, prop, this.propertyMap);
            this.addInheritedProperty(contextType, prop, this.inheritedPropertyMap);
            if (!prop.getType().isDataType()) {
                contextType = prop.getType();
                result.add(contextType);
            }
            buf.append(prop.getName());
        }
        return result;
    }

    @Override
    public boolean hasInheritedProperty(Type type, Property property) {
        Set<Property> props;
        if (!this.initialized()) {
            this.init();
        }
        return (props = this.inheritedPropertyMap.get(type)) != null && props.size() > 0 && props.contains(property);
    }

    @Override
    public Set<Property> getProperties(Type type, int level) {
        Set<Property> set;
        Map<Integer, Set<Property>> levelMap;
        if (!this.initialized()) {
            this.init();
        }
        if ((levelMap = this.propertyLevelMap.get(type)) != null && (set = levelMap.get(level)) != null) {
            return set;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getProperties(Type type, Property sourceProperty) {
        Set<Property> set;
        Map<Property, Set<Property>> edgeMap;
        if (!this.initialized()) {
            this.init();
        }
        if ((edgeMap = this.propertyEdgeMap.get(type)) != null && (set = edgeMap.get(sourceProperty)) != null) {
            return set;
        }
        return EMPTY_PROPERTY_SET;
    }

    @Override
    public Set<Property> getProperties(Type type, Property sourceProperty, int level) {
        HashSet<Property> result = new HashSet<Property>();
        result.addAll(this.getProperties(type, level));
        result.addAll(this.getProperties(type, sourceProperty));
        return result;
    }

    private void collect(AbstractProperty abstractProperty) {
        Path path = null;
        if (abstractProperty instanceof org.plasma.query.model.Property) {
            path = ((org.plasma.query.model.Property)abstractProperty).getPath();
        } else if (abstractProperty instanceof WildcardProperty) {
            path = ((WildcardProperty)abstractProperty).getPath();
        } else {
            throw new IllegalArgumentException("unknown property class, " + abstractProperty.getClass().getName());
        }
        if (path == null) {
            Property[] props = this.findProperties(this.rootType, abstractProperty);
            this.mapProperties(this.rootType, props, this.propertyMap);
            this.mapInheritedProperties(this.rootType, props, this.inheritedPropertyMap);
            Integer level = 0;
            this.mapProperties(this.rootType, level, props, this.propertyLevelMap);
            this.mapInheritedProperties(this.rootType, level, props, this.inheritedPropertyLevelMap);
        } else if (!this.isOnlySingularProperties()) {
            this.collect(path, this.rootType, path.getPathNodes().get(0), 0, abstractProperty, null, 0);
        } else if (this.isSingularPath(path, this.rootType, abstractProperty)) {
            this.collect(path, this.rootType, path.getPathNodes().get(0), 0, abstractProperty, null, 0);
        }
    }

    private void collect(Path path, Type currType, PathNode currPathode, int curPathElementIndex, AbstractProperty abstractProperty, Property edge, int level) {
        AbstractPathElement currPathElement = currPathode.getPathElement();
        if (currPathElement instanceof PathElement) {
            PathElement pathElement = (PathElement)currPathElement;
            Property prop = currType.getProperty(pathElement.getValue());
            if (prop.getType().isDataType()) {
                if (abstractProperty instanceof org.plasma.query.model.Property) {
                    throw new QueryException("traversal path for property '" + ((org.plasma.query.model.Property)abstractProperty).getName() + "' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
                }
                throw new QueryException("traversal path for wildcard property ' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
            }
            if (currPathode.getWhere() != null) {
                this.predicateMap.put(prop, currPathode.getWhere());
            }
            if (prop.isMany() && this.isOnlySingularProperties()) {
                return;
            }
            Type nextType = prop.getType();
            if (path.getPathNodes().size() > curPathElementIndex + 1) {
                this.addProperty(currType, prop, this.propertyMap);
                this.addInheritedProperty(currType, prop, this.inheritedPropertyMap);
                this.addProperty(currType, level, prop, this.propertyLevelMap);
                this.addInheritedProperty(currType, level, prop, this.inheritedPropertyLevelMap);
                if (edge != null) {
                    this.addProperty(currType, edge, prop, this.propertyEdgeMap);
                    this.addInheritedProperty(currType, edge, prop, this.inheritedPropertyEdgeMap);
                }
                int nextPathElementIndex = curPathElementIndex + 1;
                PathNode nextPathNode = path.getPathNodes().get(nextPathElementIndex);
                this.collect(path, nextType, nextPathNode, nextPathElementIndex, abstractProperty, prop, level + 1);
            } else {
                this.addProperty(currType, prop, this.propertyMap);
                this.addInheritedProperty(currType, prop, this.inheritedPropertyMap);
                this.addProperty(currType, level, prop, this.propertyLevelMap);
                this.addInheritedProperty(currType, level, prop, this.inheritedPropertyLevelMap);
                Property[] props = this.findProperties(nextType, abstractProperty);
                this.mapProperties(nextType, props, this.propertyMap);
                this.mapInheritedProperties(nextType, props, this.inheritedPropertyMap);
                this.mapProperties(nextType, level + 1, props, this.propertyLevelMap);
                this.mapInheritedProperties(nextType, level + 1, props, this.inheritedPropertyLevelMap);
                this.mapProperties(nextType, prop, props, this.propertyEdgeMap);
                this.mapInheritedProperties(nextType, prop, props, this.inheritedPropertyEdgeMap);
            }
        } else if (currPathElement instanceof WildcardPathElement) {
            List<Property> properties = null;
            properties = this.onlyDeclaredProperties ? currType.getDeclaredProperties() : currType.getProperties();
            if (currPathode.getWhere() != null) {
                throw new InvalidPathPredicateException("path predicate found on wildcard path element");
            }
            for (Property prop : properties) {
                if (prop.getType().isDataType()) continue;
                if (prop.isMany() && this.isOnlySingularProperties()) {
                    return;
                }
                Type nextType = prop.getType();
                if (path.getPathNodes().size() > curPathElementIndex + 1) {
                    this.addProperty(currType, prop, this.propertyMap);
                    this.addInheritedProperty(currType, prop, this.inheritedPropertyMap);
                    this.addProperty(currType, level, prop, this.propertyLevelMap);
                    this.addInheritedProperty(currType, level, prop, this.inheritedPropertyLevelMap);
                    if (edge != null) {
                        this.addProperty(currType, edge, prop, this.propertyEdgeMap);
                        this.addInheritedProperty(currType, edge, prop, this.inheritedPropertyEdgeMap);
                    }
                    int nextPathElementIndex = curPathElementIndex + 1;
                    PathNode nextPathNode = path.getPathNodes().get(nextPathElementIndex);
                    this.collect(path, nextType, nextPathNode, nextPathElementIndex, abstractProperty, prop, level + 1);
                    continue;
                }
                this.addProperty(currType, prop, this.propertyMap);
                this.addInheritedProperty(currType, prop, this.inheritedPropertyMap);
                this.addProperty(currType, level + 1, prop, this.propertyLevelMap);
                this.addInheritedProperty(currType, level + 1, prop, this.inheritedPropertyLevelMap);
                this.addProperty(currType, edge, prop, this.propertyEdgeMap);
                this.addInheritedProperty(currType, edge, prop, this.inheritedPropertyEdgeMap);
                Property[] props = this.findProperties(nextType, abstractProperty);
                this.mapProperties(nextType, props, this.propertyMap);
                this.mapInheritedProperties(nextType, props, this.inheritedPropertyMap);
                this.mapProperties(nextType, level + 1, props, this.propertyLevelMap);
                this.mapInheritedProperties(nextType, level + 1, props, this.inheritedPropertyLevelMap);
                this.mapProperties(nextType, prop, props, this.propertyEdgeMap);
                this.mapInheritedProperties(nextType, prop, props, this.inheritedPropertyEdgeMap);
            }
        } else {
            throw new IllegalArgumentException("unknown path element class, " + currPathElement.getClass().getName());
        }
    }

    public String dumpProperties() {
        StringBuilder buf = new StringBuilder();
        for (PlasmaType plasmaType : this.propertyMap.keySet()) {
            buf.append("\n" + plasmaType.getURI() + "#" + plasmaType.getName());
            Set<Property> props = this.propertyMap.get(plasmaType);
            for (Property prop : props) {
                buf.append("\n\t" + prop.getName());
            }
        }
        return buf.toString();
    }

    public String dumpInheritedProperties() {
        StringBuilder buf = new StringBuilder();
        for (PlasmaType plasmaType : this.inheritedPropertyMap.keySet()) {
            buf.append("\n" + plasmaType.getURI() + "#" + plasmaType.getName());
            Set<Property> props = this.inheritedPropertyMap.get(plasmaType);
            for (Property prop : props) {
                buf.append("\n\t" + prop.getName());
            }
        }
        return buf.toString();
    }
}

