/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataObject;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaChangeSummary;

public class DataObjectPathDepthComparator
implements Comparator<DataObject> {
    private static Log log = LogFactory.getFactory().getInstance(DataObjectPathDepthComparator.class);

    @Override
    public int compare(DataObject target, DataObject source) {
        if (target.getDataGraph() == null) {
            throw new IllegalArgumentException("target data-object has no data-graph - data-objects compared for commit operations must have a data graph");
        }
        if (source.getDataGraph() == null) {
            throw new IllegalArgumentException("source data-object has no data-graph - data-objects compared for commit operations must have a data graph");
        }
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)target.getChangeSummary();
        int targetDepth = changeSummary.getPathDepth(target);
        int sourceDepth = changeSummary.getPathDepth(source);
        int result = 0;
        result = changeSummary.isCreated(target) ? (targetDepth > sourceDepth ? 1 : (sourceDepth > targetDepth ? -1 : 0)) : (changeSummary.isModified(target) ? (targetDepth > sourceDepth ? 1 : (sourceDepth > targetDepth ? -1 : 0)) : (targetDepth > sourceDepth ? -1 : (sourceDepth > targetDepth ? 1 : 0)));
        return result;
    }
}

