/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.service;

import commonj.sdo.DataGraph;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.query.model.Query;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataAccessService;
import org.plasma.sdo.access.PlasmaDataAccessService;
import org.plasma.sdo.core.SnapshotMap;

@Stateless
@Local
@TransactionManagement(value=TransactionManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class DataAccessServiceEJB
implements DataAccessService {
    private static Log log = LogFactory.getLog(DataAccessServiceEJB.class);
    private PlasmaDataAccessService service;

    @Override
    @PostConstruct
    public void initialize() {
        try {
            if (this.service == null) {
                this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
                this.service.initialize();
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
    }

    @PreDestroy
    public void preDestroy() {
        log.debug((Object)"preDestroy()");
        this.close();
    }

    @Override
    public DataGraph[] find(Query query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find(Query query) - (" + this.toString() + ")"));
        }
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.find(query);
    }

    @Override
    public DataGraph[] find(Query query, int maxResults) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find(Query query) - (" + this.toString() + ")"));
        }
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.find(query, maxResults);
    }

    public List find(Query[] queries) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find(Query[] queries) - (" + this.toString() + ")"));
        }
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.find(queries);
    }

    @Override
    public int[] count(Query[] queries) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("count(Query[] queries) - (" + this.toString() + ")"));
        }
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.count(queries);
    }

    @Override
    public int count(Query query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("count(Query query) - (" + this.toString() + ")"));
        }
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.count(query);
    }

    @Override
    public SnapshotMap commit(DataGraph dataGraph, String username) {
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.commit(dataGraph, username);
    }

    @Override
    public SnapshotMap commit(DataGraph[] dataGraphs, String username) {
        if (this.service == null) {
            this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getClassName());
            this.service.initialize();
        }
        return this.service.commit(dataGraphs, username);
    }

    protected PlasmaDataAccessService createProvider(String qualifiedName) {
        try {
            Class<?> providerClass = Class.forName(qualifiedName);
            Class[] argClasses = new Class[]{};
            Object[] args = new Object[]{};
            Constructor<?> constructor = providerClass.getConstructor(argClasses);
            return (PlasmaDataAccessService)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw new DataAccessException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DataAccessException(e);
        }
        catch (InstantiationException e) {
            throw new DataAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new DataAccessException(e);
        }
    }
}

