/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.Type;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Duration;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.helper.InvalidDataConversionException;

public class DataConverter {
    private static Log log = LogFactory.getFactory().getInstance(DataConverter.class);
    public static DataConverter INSTANCE = DataConverter.initializeInstance();
    public static final String FORMAT_PATTERN_TIME = "HH:mm:ss'.'SSS'Z'";
    public static final String FORMAT_PATTERN_DATE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FORMAT_PATTERN_DATETIME = "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'";
    public static final String FORMAT_PATTERN_DAY = "dd";
    public static final String FORMAT_PATTERN_MONTH = "MM";
    public static final String FORMAT_PATTERN_MONTHDAY = "MM-dd";
    public static final String FORMAT_PATTERN_YEAR = "yyyy";
    public static final String FORMAT_PATTERN_YEARMONTH = "yyyy-MM";
    public static final String FORMAT_PATTERN_YEARMONTHDAY = "yyyy-MM-dd";
    private static Map<Class<?>, Map<String, DataType>> javaClassToAllowableTypesMap;
    private static Map<Class<?>, Method> javaClassToConverterFromMethodMap;
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss'.'SSS'Z'");
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private PeriodFormatter durationFormat;
    private DateFormat dayFormat;
    private DateFormat monthFormat;
    private DateFormat monthDayFormat;
    private DateFormat yearFormat;
    private DateFormat yearMonthFormat;
    private DateFormat yearMonthDayFormat;

    private DataConverter() {
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateFormat = new SimpleDateFormat(FORMAT_PATTERN_DATE);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateTimeFormat = new SimpleDateFormat(FORMAT_PATTERN_DATETIME);
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.durationFormat = ISOPeriodFormat.standard();
        this.dayFormat = new SimpleDateFormat(FORMAT_PATTERN_DAY);
        this.dayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.monthFormat = new SimpleDateFormat(FORMAT_PATTERN_MONTH);
        this.monthFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.monthDayFormat = new SimpleDateFormat(FORMAT_PATTERN_MONTHDAY);
        this.monthDayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.yearFormat = new SimpleDateFormat(FORMAT_PATTERN_YEAR);
        this.yearFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.yearMonthFormat = new SimpleDateFormat(FORMAT_PATTERN_YEARMONTH);
        this.yearMonthFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.yearMonthDayFormat = new SimpleDateFormat(FORMAT_PATTERN_YEARMONTHDAY);
        this.yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (javaClassToAllowableTypesMap == null) {
            javaClassToAllowableTypesMap = new HashMap();
            for (int i = 0; i < DataType.values().length; ++i) {
                DataType dataTypeEnum = DataType.values()[i];
                Class<?> javaClass = this.toPrimitiveJavaClass(dataTypeEnum);
                HashMap<String, DataType> allowableMap = new HashMap<String, DataType>();
                List<DataType> list = this.getAllowableTargetTypes(dataTypeEnum);
                for (DataType allowableType : list) {
                    allowableMap.put(allowableType.toString(), allowableType);
                }
                javaClassToAllowableTypesMap.put(javaClass, allowableMap);
            }
        }
        if (javaClassToConverterFromMethodMap == null) {
            javaClassToConverterFromMethodMap = new HashMap();
            Map<Class<?>, Method> map = javaClassToConverterFromMethodMap;
            try {
                Method method = this.getClass().getMethod("fromBoolean", Type.class, Boolean.TYPE);
                map.put(Boolean.class, method);
                map.put(Boolean.TYPE, method);
                method = this.getClass().getMethod("fromByte", Type.class, Byte.TYPE);
                map.put(Byte.class, method);
                map.put(Byte.TYPE, method);
                method = this.getClass().getMethod("fromBytes", Type.class, byte[].class);
                map.put(Byte[].class, method);
                map.put(byte[].class, method);
                method = this.getClass().getMethod("fromCharacter", Type.class, Character.TYPE);
                map.put(Character.class, method);
                map.put(Character.TYPE, method);
                method = this.getClass().getMethod("fromDate", Type.class, Date.class);
                map.put(Date.class, method);
                method = this.getClass().getMethod("fromDecimal", Type.class, BigDecimal.class);
                map.put(BigDecimal.class, method);
                method = this.getClass().getMethod("fromDouble", Type.class, Double.TYPE);
                map.put(Double.class, method);
                map.put(Double.TYPE, method);
                method = this.getClass().getMethod("fromFloat", Type.class, Float.TYPE);
                map.put(Float.class, method);
                map.put(Float.TYPE, method);
                method = this.getClass().getMethod("fromInt", Type.class, Integer.TYPE);
                map.put(Integer.TYPE, method);
                map.put(Integer.class, method);
                method = this.getClass().getMethod("fromInteger", Type.class, BigInteger.class);
                map.put(BigInteger.class, method);
                method = this.getClass().getMethod("fromLong", Type.class, Long.TYPE);
                map.put(Long.class, method);
                map.put(Long.TYPE, method);
                method = this.getClass().getMethod("fromShort", Type.class, Short.TYPE);
                map.put(Short.class, method);
                map.put(Short.TYPE, method);
                method = this.getClass().getMethod("fromString", Type.class, String.class);
                map.put(String.class, method);
                method = this.getClass().getMethod("fromStrings", Type.class, List.class);
                map.put(List.class, method);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static synchronized DataConverter initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataConverter();
        }
        return INSTANCE;
    }

    public DateFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public PeriodFormatter getDurationFormat() {
        return this.durationFormat;
    }

    public DateFormat getDayFormat() {
        return this.dayFormat;
    }

    public DateFormat getMonthFormat() {
        return this.monthFormat;
    }

    public DateFormat getMonthDayFormat() {
        return this.monthDayFormat;
    }

    public DateFormat getYearFormat() {
        return this.yearFormat;
    }

    public DateFormat getYearMonthFormat() {
        return this.yearMonthFormat;
    }

    public DateFormat getYearMonthDayFormat() {
        return this.yearMonthDayFormat;
    }

    public Object convert(Type targetType, Object value) {
        if (!targetType.isDataType()) {
            throw new IllegalArgumentException("type " + targetType.getURI() + "#" + targetType.getName() + " is not a data-type");
        }
        Method method = javaClassToConverterFromMethodMap.get(value.getClass());
        try {
            return method.invoke((Object)this, targetType, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidDataConversionException) {
                throw (InvalidDataConversionException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object convert(Type targetType, Type sourceType, Object value) {
        if (!targetType.isDataType()) {
            throw new IllegalArgumentException("type " + targetType.getURI() + "#" + targetType.getName() + " is not a data-type");
        }
        if (!sourceType.isDataType()) {
            throw new IllegalArgumentException("type " + sourceType.getURI() + "#" + sourceType.getName() + " is not a data-type");
        }
        DataType targetDataType = DataType.valueOf(targetType.getName());
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (targetDataType) {
            case Boolean: {
                return this.toBoolean(sourceType, value);
            }
            case Byte: {
                return this.toByte(sourceType, value);
            }
            case Bytes: {
                return this.toBytes(sourceType, value);
            }
            case Character: {
                return Character.valueOf(this.toCharacter(sourceType, value));
            }
            case Decimal: {
                return this.toDecimal(sourceType, value);
            }
            case Double: {
                return this.toDouble(sourceType, value);
            }
            case Float: {
                return Float.valueOf(this.toFloat(sourceType, value));
            }
            case Int: {
                return this.toInt(sourceType, value);
            }
            case Integer: {
                return this.toInteger(sourceType, value);
            }
            case Long: {
                return this.toLong(sourceType, value);
            }
            case Short: {
                return this.toShort(sourceType, value);
            }
            case String: {
                return this.toString(sourceType, value);
            }
            case Strings: {
                return this.toStrings(sourceType, value);
            }
            case Date: {
                return this.toDate(sourceType, value);
            }
            case Duration: 
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: {
                return this.toTemporalDataType(targetType, sourceType, value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public boolean toBoolean(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Boolean: {
                return (Boolean)value;
            }
            case String: {
                return Boolean.parseBoolean(value.toString());
            }
        }
        throw new InvalidDataConversionException(DataType.Boolean, sourceDataType, value);
    }

    public Object fromBoolean(Type targetType, boolean value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Boolean: {
                return value;
            }
            case String: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Boolean, value);
    }

    public byte toByte(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Byte: {
                return (Byte)value;
            }
            case Double: {
                return ((Double)value).byteValue();
            }
            case Float: {
                return ((Float)value).byteValue();
            }
            case Int: {
                return ((Integer)value).byteValue();
            }
            case Long: {
                return ((Long)value).byteValue();
            }
            case Short: {
                return ((Short)value).byteValue();
            }
            case String: {
                return Integer.valueOf((String)value).byteValue();
            }
        }
        throw new InvalidDataConversionException(DataType.Byte, sourceDataType, value);
    }

    public Object fromByte(Type targetType, byte value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Byte: {
                return value;
            }
            case Double: {
                return (double)(value & 0xFF);
            }
            case Float: {
                return Float.valueOf(value & 0xFF);
            }
            case Int: {
                return value & 0xFF;
            }
            case Long: {
                return (long)(value & 0xFF);
            }
            case Short: {
                return new Short(Integer.valueOf(value & 0xFF).shortValue());
            }
            case String: {
                return Integer.valueOf(value & 0xFF).toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Byte, value);
    }

    public byte[] toBytes(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Bytes: {
                return (byte[])value;
            }
            case String: {
                return ((String)value).getBytes();
            }
            case Integer: {
                return ((BigInteger)value).toByteArray();
            }
        }
        throw new InvalidDataConversionException(DataType.Bytes, sourceDataType, value);
    }

    public Object fromBytes(Type targetType, byte[] value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Bytes: {
                return value;
            }
            case String: {
                return this.toHexString(value);
            }
            case Integer: {
                return new BigInteger(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Bytes, value);
    }

    public char toCharacter(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Character: {
                return ((Character)value).charValue();
            }
            case String: {
                return ((String)value).charAt(0);
            }
        }
        throw new InvalidDataConversionException(DataType.Character, sourceDataType, value);
    }

    public Object fromCharacter(Type targetType, char value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Character: {
                return Character.valueOf(value);
            }
            case String: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Character, Character.valueOf(value));
    }

    public BigDecimal toDecimal(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Decimal: {
                return (BigDecimal)value;
            }
            case Double: 
            case Float: 
            case Int: 
            case Integer: 
            case Long: {
                return new BigDecimal(((Number)value).doubleValue());
            }
            case String: {
                return new BigDecimal((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Decimal, sourceDataType, value);
    }

    public Object fromDecimal(Type targetType, BigDecimal value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Decimal: {
                return value;
            }
            case Double: {
                return new Double(value.doubleValue());
            }
            case Float: {
                return new Float(value.floatValue());
            }
            case Int: {
                return new Integer(value.intValue());
            }
            case Long: {
                return new Long(value.longValue());
            }
            case Integer: {
                return value.toBigInteger();
            }
            case String: {
                return value.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Decimal, value);
    }

    public double toDouble(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Double: {
                return (Double)value;
            }
            case Byte: {
                return ((Byte)value).doubleValue();
            }
            case Float: {
                return ((Float)value).doubleValue();
            }
            case Int: {
                return ((Integer)value).doubleValue();
            }
            case Long: {
                return ((Long)value).doubleValue();
            }
            case Short: {
                return ((Short)value).doubleValue();
            }
            case Integer: {
                return ((BigInteger)value).doubleValue();
            }
            case Decimal: {
                return ((BigDecimal)value).doubleValue();
            }
            case String: {
                return Double.parseDouble((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Double, sourceDataType, value);
    }

    public Object fromDouble(Type targetType, double value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Double: {
                return value;
            }
            case Byte: {
                return new Byte(Double.valueOf(value).byteValue());
            }
            case Float: {
                return new Float(Double.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Double.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Double.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Double.valueOf(value).shortValue());
            }
            case Integer: {
                return BigInteger.valueOf(Double.valueOf(value).longValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case String: {
                return Double.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Double, value);
    }

    public float toFloat(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Float: {
                return ((Float)value).floatValue();
            }
            case Byte: {
                return ((Byte)value).floatValue();
            }
            case Double: {
                return ((Double)value).floatValue();
            }
            case Int: {
                return ((Integer)value).floatValue();
            }
            case Long: {
                return ((Long)value).floatValue();
            }
            case Short: {
                return ((Short)value).floatValue();
            }
            case Decimal: {
                return ((BigDecimal)value).floatValue();
            }
            case Integer: {
                return ((BigInteger)value).floatValue();
            }
            case String: {
                return Float.valueOf((String)value).floatValue();
            }
        }
        throw new InvalidDataConversionException(DataType.Float, sourceDataType, value);
    }

    public Object fromFloat(Type targetType, float value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Float: {
                return Float.valueOf(value);
            }
            case Byte: {
                return new Byte(Float.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Float.valueOf(value).doubleValue());
            }
            case Int: {
                return new Integer(Float.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Float.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Float.valueOf(value).shortValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case Integer: {
                return BigInteger.valueOf(Double.valueOf(value).longValue());
            }
            case String: {
                return Float.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Float, Float.valueOf(value));
    }

    public int toInt(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Int: {
                return (Integer)value;
            }
            case Byte: {
                return ((Byte)value).intValue();
            }
            case Double: {
                return ((Double)value).intValue();
            }
            case Float: {
                return ((Float)value).intValue();
            }
            case Long: {
                return ((Long)value).intValue();
            }
            case Short: {
                return ((Short)value).intValue();
            }
            case Decimal: {
                return ((BigDecimal)value).intValue();
            }
            case Integer: {
                return ((BigInteger)value).intValue();
            }
            case String: {
                return Integer.parseInt((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Int, sourceDataType, value);
    }

    public Object fromInt(Type targetType, int value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Int: {
                return value;
            }
            case Byte: {
                return new Byte(Integer.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Integer.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Integer.valueOf(value).floatValue());
            }
            case Long: {
                return new Long(Integer.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Integer.valueOf(value).shortValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case Integer: {
                return BigInteger.valueOf(Integer.valueOf(value).longValue());
            }
            case String: {
                return Integer.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Int, value);
    }

    public BigInteger toInteger(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Integer: {
                return (BigInteger)value;
            }
            case Double: {
                return BigInteger.valueOf(((Double)value).longValue());
            }
            case Float: {
                return BigInteger.valueOf(((Float)value).longValue());
            }
            case Int: {
                return BigInteger.valueOf(((Integer)value).longValue());
            }
            case Long: {
                return BigInteger.valueOf((Long)value);
            }
            case Decimal: {
                return BigInteger.valueOf(((BigDecimal)value).longValue());
            }
            case Bytes: {
                return new BigInteger((byte[])value);
            }
            case String: {
                return new BigInteger((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Integer, sourceDataType, value);
    }

    public Object fromInteger(Type targetType, BigInteger value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Integer: {
                return value;
            }
            case Double: {
                return new Double(value.doubleValue());
            }
            case Float: {
                return new Float(value.floatValue());
            }
            case Int: {
                return new Integer(value.intValue());
            }
            case Long: {
                return new Long(value.longValue());
            }
            case Decimal: {
                return new BigDecimal(value.doubleValue());
            }
            case Bytes: {
                return value.toByteArray();
            }
            case String: {
                return value.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Integer, value);
    }

    public long toLong(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Long: {
                return (Long)value;
            }
            case Byte: {
                return ((Byte)value).longValue();
            }
            case Double: {
                return ((Double)value).longValue();
            }
            case Float: {
                return ((Float)value).longValue();
            }
            case Int: {
                return ((Integer)value).longValue();
            }
            case Short: {
                return ((Short)value).longValue();
            }
            case Decimal: {
                return ((BigDecimal)value).longValue();
            }
            case Integer: {
                return ((BigInteger)value).longValue();
            }
            case Date: {
                return ((Date)value).getTime();
            }
            case String: {
                return Long.parseLong((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Long, sourceDataType, value);
    }

    public Object fromLong(Type targetType, long value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Long: {
                return value;
            }
            case Byte: {
                return new Byte(Long.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Long.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Long.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Long.valueOf(value).intValue());
            }
            case Short: {
                return new Short(Long.valueOf(value).shortValue());
            }
            case Decimal: {
                return new BigDecimal(value);
            }
            case Integer: {
                return BigInteger.valueOf(value);
            }
            case Date: {
                return new Date(value);
            }
            case String: {
                return Long.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Long, value);
    }

    public short toShort(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Short: {
                return (Short)value;
            }
            case Byte: {
                return ((Byte)value).shortValue();
            }
            case Double: {
                return ((Double)value).shortValue();
            }
            case Float: {
                return ((Float)value).shortValue();
            }
            case Int: {
                return ((Integer)value).shortValue();
            }
            case Long: {
                return ((Long)value).shortValue();
            }
            case String: {
                return Short.parseShort((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Short, sourceDataType, value);
    }

    public Object fromShort(Type targetType, short value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Short: {
                return value;
            }
            case Byte: {
                return new Byte(Short.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Short.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Short.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Short.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Short.valueOf(value).longValue());
            }
            case String: {
                return Short.valueOf(value).toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Short, value);
    }

    public String toString(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case String: {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object listValue : (List)value) {
                        if (listValue instanceof String) continue;
                        this.throwExpectedInstance(sourceDataType, String.class, listValue.getClass());
                    }
                    return Arrays.toString(list.toArray());
                }
                this.throwExpectedInstance(sourceDataType, String.class, value.getClass());
            }
            case Decimal: {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toString();
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object listValue : (List)value) {
                        if (listValue instanceof BigDecimal) continue;
                        this.throwExpectedInstance(sourceDataType, BigDecimal.class, listValue.getClass());
                    }
                    return Arrays.toString(list.toArray());
                }
                this.throwExpectedInstance(sourceDataType, BigDecimal.class, value.getClass());
            }
            case Bytes: {
                if (value instanceof byte[]) {
                    return this.toHexString((byte[])value);
                }
                if (value instanceof List) {
                    ArrayList<String> result = new ArrayList<String>();
                    List list = (List)value;
                    for (Object listValue : list) {
                        if (!(listValue instanceof byte[])) {
                            this.throwExpectedInstance(sourceDataType, byte[].class, listValue.getClass());
                        }
                        result.add(this.toHexString((byte[])listValue));
                    }
                    return Arrays.toString(result.toArray());
                }
                this.throwExpectedInstance(sourceDataType, byte[].class, value.getClass());
            }
            case Byte: {
                if (value instanceof Byte) {
                    return Integer.valueOf((Byte)value & 0xFF).toString();
                }
                if (value instanceof List) {
                    ArrayList<String> result = new ArrayList<String>();
                    List list = (List)value;
                    for (Object listValue : list) {
                        if (!(listValue instanceof Byte)) {
                            this.throwExpectedInstance(sourceDataType, Byte.class, listValue.getClass());
                        }
                        result.add(Integer.valueOf((Byte)listValue & 0xFF).toString());
                    }
                    return Arrays.toString(result.toArray());
                }
                this.throwExpectedInstance(sourceDataType, Byte.class, value.getClass());
            }
            case Boolean: {
                return this.toString(sourceDataType, Boolean.class, value);
            }
            case Character: {
                return this.toString(sourceDataType, Character.class, value);
            }
            case Double: {
                return this.toString(sourceDataType, Double.class, value);
            }
            case Float: {
                return this.toString(sourceDataType, Float.class, value);
            }
            case Int: {
                return this.toString(sourceDataType, Integer.class, value);
            }
            case Integer: {
                return this.toString(sourceDataType, BigInteger.class, value);
            }
            case Long: {
                return this.toString(sourceDataType, Long.class, value);
            }
            case Short: {
                return this.toString(sourceDataType, Short.class, value);
            }
            case Strings: {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("expected value as class " + List.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                StringBuffer buf = new StringBuffer();
                List list = (List)value;
                Iterator iter = list.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append((String)iter.next());
                    ++i;
                }
                return buf.toString();
            }
            case URI: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("expected value as class " + String.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                return (String)value;
            }
            case Date: {
                if (!(value instanceof Date)) {
                    throw new IllegalArgumentException("expected value as class " + Date.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                return this.dateFormat.format(value);
            }
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("expected value as class " + String.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                return (String)value;
            }
            case Duration: {
                return String.valueOf(value);
            }
            case Object: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(DataType.String, sourceDataType, value);
    }

    private String toString(DataType sourceDataType, Class<?> typeClass, Object value) {
        String result = null;
        if (typeClass.isAssignableFrom(value.getClass())) {
            result = String.valueOf(value);
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object listValue : (List)value) {
                if (typeClass.isAssignableFrom(listValue.getClass())) continue;
                this.throwExpectedInstance(sourceDataType, typeClass, listValue.getClass());
            }
            result = Arrays.toString(list.toArray());
        } else {
            this.throwExpectedInstance(sourceDataType, typeClass, value.getClass());
        }
        return result;
    }

    private void throwExpectedInstance(DataType dataType, Class expectedClass, Class foundClass) {
        throw new IllegalArgumentException("expected value or list of class " + expectedClass.getName() + ", not " + foundClass.getName() + ", for datatype '" + dataType.name() + "'");
    }

    public Object fromString(Type targetType, String value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case String: {
                if (!value.startsWith("[")) {
                    return value;
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String arrayValue : strings) {
                    list.add(arrayValue);
                }
                return list;
            }
            case Decimal: {
                if (!value.startsWith("[")) {
                    return new BigDecimal(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                for (String arrayValue : strings) {
                    list.add(new BigDecimal(arrayValue));
                }
                return list;
            }
            case Bytes: {
                if (!value.startsWith("[")) {
                    return value.getBytes();
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                for (String arrayValue : strings) {
                    list.add(value.getBytes());
                }
                return list;
            }
            case Byte: {
                if (!value.startsWith("[")) {
                    byte[] byteArray = value.getBytes();
                    return new Byte(byteArray[0]);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Byte> list = new ArrayList<Byte>();
                byte[] byteArray = null;
                for (String arrayValue : strings) {
                    byteArray = arrayValue.getBytes();
                    list.add(new Byte(byteArray[0]));
                }
                return list;
            }
            case Boolean: {
                if (!value.startsWith("[")) {
                    return Boolean.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                for (String arrayValue : strings) {
                    list.add(Boolean.valueOf(arrayValue));
                }
                return list;
            }
            case Character: {
                if (!value.startsWith("[")) {
                    return Character.valueOf(value.charAt(0));
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Character> list = new ArrayList<Character>();
                for (String arrayValue : strings) {
                    list.add(Character.valueOf(arrayValue.charAt(0)));
                }
                return list;
            }
            case Double: {
                if (!value.startsWith("[")) {
                    return Double.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Double> list = new ArrayList<Double>();
                for (String arrayValue : strings) {
                    list.add(Double.valueOf(arrayValue));
                }
                return list;
            }
            case Float: {
                if (!value.startsWith("[")) {
                    return Float.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Float> list = new ArrayList<Float>();
                for (String arrayValue : strings) {
                    list.add(Float.valueOf(arrayValue));
                }
                return list;
            }
            case Int: {
                if (!value.startsWith("[")) {
                    return Integer.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (String arrayValue : strings) {
                    list.add(Integer.valueOf(arrayValue));
                }
                return list;
            }
            case Integer: {
                if (!value.startsWith("[")) {
                    return new BigInteger(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<BigInteger> list = new ArrayList<BigInteger>();
                for (String arrayValue : strings) {
                    list.add(new BigInteger(arrayValue));
                }
                return list;
            }
            case Long: {
                if (!value.startsWith("[")) {
                    return Long.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Long> list = new ArrayList<Long>();
                for (String arrayValue : strings) {
                    list.add(Long.valueOf(arrayValue));
                }
                return list;
            }
            case Short: {
                if (!value.startsWith("[")) {
                    return Short.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Short> list = new ArrayList<Short>();
                for (String arrayValue : strings) {
                    list.add(Short.valueOf(arrayValue));
                }
                return list;
            }
            case Strings: {
                if (!value.startsWith("[")) {
                    String[] values = value.split("\\s");
                    ArrayList<String> list = new ArrayList<String>(values.length);
                    for (int i = 0; i < values.length; ++i) {
                        list.add(values[i]);
                    }
                    return list;
                }
                String tempValue = value.replaceAll("[\\[\\]]", "");
                tempValue.trim();
                String[] strings = tempValue.split(",");
                ArrayList list = new ArrayList();
                for (String arrayValue : strings) {
                    String[] values = arrayValue.split("\\s");
                    ArrayList<String> subList = new ArrayList<String>(values.length);
                    for (int i = 0; i < values.length; ++i) {
                        subList.add(values[i]);
                    }
                    list.add(subList);
                }
                return list;
            }
            case Date: {
                try {
                    if (!value.startsWith("[")) {
                        return this.dateFormat.parse(value);
                    }
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Date> list = new ArrayList<Date>();
                    for (String arrayValue : strings) {
                        list.add(this.dateFormat.parse(arrayValue));
                    }
                    return list;
                }
                catch (ParseException e) {
                    throw new PlasmaDataObjectException(e);
                }
            }
            case Duration: 
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: 
            case URI: {
                if (!value.startsWith("[")) {
                    return value;
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String arrayValue : strings) {
                    list.add(arrayValue);
                }
                return list;
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.String, value);
    }

    public List<String> toStrings(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Strings: {
                return (List)value;
            }
            case String: {
                String[] values = ((String)value).split("\\s");
                ArrayList<String> list = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    list.add(values[i]);
                }
                return list;
            }
        }
        throw new InvalidDataConversionException(DataType.Strings, sourceDataType, value);
    }

    public Object fromStrings(Type targetType, List<String> value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Strings: {
                return value;
            }
            case String: {
                StringBuffer buf = new StringBuffer();
                Iterator<String> iter = value.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append(iter.next());
                    ++i;
                }
                return buf.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Strings, value);
    }

    public Date toDate(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            case Date: {
                return (Date)value;
            }
            case Long: {
                return new Date((Long)value);
            }
            case String: 
            case Duration: 
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: {
                try {
                    return this.dateTimeFormat.parse((String)value);
                }
                catch (ParseException e) {
                    throw new PlasmaDataObjectException(e);
                }
            }
        }
        throw new InvalidDataConversionException(DataType.Date, sourceDataType, value);
    }

    public Object fromDate(Type targetType, Date value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        switch (targetDataType) {
            case Date: {
                return value;
            }
            case DateTime: {
                return this.dateTimeFormat.format(value);
            }
            case Day: {
                return this.dayFormat.format(value);
            }
            case Month: {
                return this.monthFormat.format(value);
            }
            case MonthDay: {
                return this.monthDayFormat.format(value);
            }
            case Time: {
                return this.timeFormat.format(value);
            }
            case Year: {
                return this.yearFormat.format(value);
            }
            case YearMonth: {
                return this.yearMonthFormat.format(value);
            }
            case YearMonthDay: {
                return this.yearMonthDayFormat.format(value);
            }
            case Long: {
                return new Long(value.getTime());
            }
            case String: {
                return this.dateTimeFormat.format(value);
            }
            case Duration: {
                return new Duration(value.getTime());
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Date, value);
    }

    public String toTemporalDataType(Type targetType, Type sourceType, Object value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (sourceDataType) {
            default: 
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public Object fromTemporalDataType(Type targetType, Type sourceType, String value) {
        DataType targetDataType = DataType.valueOf(targetType.getName());
        DataType sourceDataType = DataType.valueOf(sourceType.getName());
        switch (targetDataType) {
            default: 
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public Class<?> toPrimitiveJavaClass(DataType dataType) {
        switch (dataType) {
            case Boolean: {
                return Boolean.TYPE;
            }
            case Byte: {
                return Byte.TYPE;
            }
            case Bytes: {
                return byte[].class;
            }
            case Character: {
                return Character.TYPE;
            }
            case Date: {
                return Date.class;
            }
            case DateTime: {
                return String.class;
            }
            case Day: {
                return String.class;
            }
            case Decimal: {
                return BigDecimal.class;
            }
            case Double: {
                return Double.TYPE;
            }
            case Duration: {
                return String.class;
            }
            case Float: {
                return Float.TYPE;
            }
            case Int: {
                return Integer.TYPE;
            }
            case Integer: {
                return BigInteger.class;
            }
            case Long: {
                return Long.TYPE;
            }
            case Month: {
                return String.class;
            }
            case MonthDay: {
                return String.class;
            }
            case Object: {
                return Object.class;
            }
            case Short: {
                return Short.TYPE;
            }
            case String: {
                return String.class;
            }
            case Strings: {
                return List.class;
            }
            case Time: {
                return String.class;
            }
            case URI: {
                return String.class;
            }
            case Year: {
                return String.class;
            }
            case YearMonth: {
                return String.class;
            }
            case YearMonthDay: {
                return String.class;
            }
        }
        throw new PlasmaDataObjectException("unknown SDO datatype, " + dataType.toString());
    }

    public Class<?> toWrapperJavaClass(DataType dataType) {
        switch (dataType) {
            case Boolean: {
                return Boolean.class;
            }
            case Byte: {
                return Byte.class;
            }
            case Bytes: {
                return byte[].class;
            }
            case Character: {
                return Character.class;
            }
            case Date: {
                return Date.class;
            }
            case DateTime: {
                return String.class;
            }
            case Day: {
                return String.class;
            }
            case Decimal: {
                return BigDecimal.class;
            }
            case Double: {
                return Double.class;
            }
            case Duration: {
                return String.class;
            }
            case Float: {
                return Float.class;
            }
            case Int: {
                return Integer.class;
            }
            case Integer: {
                return BigInteger.class;
            }
            case Long: {
                return Long.class;
            }
            case Month: {
                return String.class;
            }
            case MonthDay: {
                return String.class;
            }
            case Object: {
                return Object.class;
            }
            case Short: {
                return Short.class;
            }
            case String: {
                return String.class;
            }
            case Strings: {
                return List.class;
            }
            case Time: {
                return String.class;
            }
            case URI: {
                return String.class;
            }
            case Year: {
                return String.class;
            }
            case YearMonth: {
                return String.class;
            }
            case YearMonthDay: {
                return String.class;
            }
        }
        throw new PlasmaDataObjectException("unknown SDO datatype, " + dataType.toString());
    }

    public List<DataType> getAllowableTargetTypes(DataType dataType) {
        ArrayList<DataType> result = new ArrayList<DataType>();
        switch (dataType) {
            case Boolean: {
                result.add(DataType.Boolean);
                result.add(DataType.String);
                break;
            }
            case Byte: {
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.String);
                break;
            }
            case Bytes: {
                result.add(DataType.Bytes);
                result.add(DataType.String);
                result.add(DataType.Integer);
                break;
            }
            case Character: {
                result.add(DataType.Character);
                result.add(DataType.String);
                break;
            }
            case Decimal: {
                result.add(DataType.Decimal);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Double: {
                result.add(DataType.Double);
                result.add(DataType.Byte);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Float: {
                result.add(DataType.Float);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Int: {
                result.add(DataType.Int);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Integer: {
                result.add(DataType.Integer);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Bytes);
                result.add(DataType.Decimal);
                result.add(DataType.String);
                break;
            }
            case Long: {
                result.add(DataType.Long);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Short: {
                result.add(DataType.Short);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.String);
                break;
            }
            case String: {
                result.add(DataType.String);
                result.add(DataType.Boolean);
                result.add(DataType.Byte);
                result.add(DataType.Bytes);
                result.add(DataType.Character);
                result.add(DataType.Date);
                result.add(DataType.DateTime);
                result.add(DataType.Day);
                result.add(DataType.Decimal);
                result.add(DataType.Double);
                result.add(DataType.Duration);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Integer);
                result.add(DataType.Long);
                result.add(DataType.Month);
                result.add(DataType.MonthDay);
                result.add(DataType.Short);
                result.add(DataType.Strings);
                result.add(DataType.Time);
                result.add(DataType.URI);
                result.add(DataType.Year);
                result.add(DataType.YearMonth);
                result.add(DataType.YearMonthDay);
                break;
            }
            case Strings: {
                result.add(DataType.Strings);
                result.add(DataType.String);
                break;
            }
            case Date: {
                result.add(DataType.Date);
                result.add(DataType.Long);
                result.add(DataType.String);
                break;
            }
            case Duration: {
                result.add(DataType.Duration);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case DateTime: {
                result.add(DataType.DateTime);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Day: {
                result.add(DataType.Day);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Month: {
                result.add(DataType.Month);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case MonthDay: {
                result.add(DataType.MonthDay);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Year: {
                result.add(DataType.Year);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case YearMonth: {
                result.add(DataType.YearMonth);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case YearMonthDay: {
                result.add(DataType.YearMonthDay);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Time: {
                result.add(DataType.Time);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case URI: {
                result.add(DataType.String);
                break;
            }
        }
        return result;
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
        }
        return buf.toString();
    }
}

