/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl;

import java.util.HashMap;
import java.util.Map;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.text.lang3gl.Lang3GLContext;

public class DefaultLang3GLContext
implements Lang3GLContext {
    private Map<String, Class> classMap = new HashMap<String, Class>();
    private Map<String, Package> packageMap = new HashMap<String, Package>();

    private DefaultLang3GLContext() {
    }

    public DefaultLang3GLContext(Model packages) {
        for (Package pkg : packages.getPackages()) {
            for (Class cls : pkg.getClazzs()) {
                String key = pkg.getUri() + "#" + cls.getName();
                this.classMap.put(key, cls);
                this.packageMap.put(key, pkg);
            }
        }
    }

    @Override
    public Class findClass(ClassRef cref) {
        String key = cref.getUri() + "#" + cref.getName();
        return this.classMap.get(key);
    }

    @Override
    public Class findClass(String qualifiedName) {
        return this.classMap.get(qualifiedName);
    }

    @Override
    public Package findPackage(ClassRef cref) {
        String key = cref.getUri() + "#" + cref.getName();
        return this.packageMap.get(key);
    }

    @Override
    public Package findPackage(String qualifiedName) {
        return this.packageMap.get(qualifiedName);
    }

    @Override
    public boolean usePrimitives() {
        return true;
    }

    @Override
    public String getIndentationToken() {
        return "\t";
    }
}

